/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;

public class Base64InputStream
extends InputStream {
    private static final int EOF = -1;
    private static final byte[] LOOKUP;
    private Reader source;
    private char[] quadBuffer = new char[4];
    private byte[] triple = new byte[3];
    private int tripleIndex = 4;
    private int tripleFilled;

    public Base64InputStream(Reader reader) {
        if (reader == null) {
            throw new NullPointerException("source must not be null");
        }
        this.source = reader;
    }

    public int read() throws IOException {
        this.checkOpen();
        if (this.tripleIndex >= this.tripleFilled && !this.readNextTriple()) {
            return -1;
        }
        return this.triple[this.tripleIndex++];
    }

    private boolean readNextTriple() throws IOException {
        int n;
        int n2 = 0;
        while (n2 < 4) {
            n = this.source.read();
            if (n < 0) {
                return false;
            }
            if (n == 13 || n == 10 || n == 32) continue;
            this.quadBuffer[n2++] = (char)n;
        }
        n = 0;
        this.tripleFilled = 3;
        for (int i = 0; i < 4; ++i) {
            int n3 = -1;
            char c = this.quadBuffer[i];
            if ('=' == c) {
                if (i < 2) {
                    throw new IOException("Padding character at invalid position");
                }
                this.tripleFilled = Math.min(i - 1, this.tripleFilled);
                break;
            }
            if (c < '\u0080') {
                n3 = LOOKUP[c];
            }
            if (n3 < 0) {
                throw new IOException("Illegal Base64 character encountered: " + c);
            }
            n |= n3 << (3 - i) * 6;
        }
        this.triple[0] = (byte)((n & 0xFF0000) >> 16);
        this.triple[1] = (byte)((n & 0xFF00) >> 8);
        this.triple[2] = (byte)(n & 0xFF);
        this.tripleIndex = 0;
        return true;
    }

    private void checkOpen() throws IOException {
        if (this.source == null) {
            throw new IOException("Stream is already closed");
        }
    }

    public void close() throws IOException {
        this.source.close();
        this.source = null;
    }

    static {
        int n;
        LOOKUP = new byte[128];
        Arrays.fill(LOOKUP, (byte)-1);
        int n2 = 0;
        for (n = 65; n <= 90; n = (int)((char)(n + 1))) {
            Base64InputStream.LOOKUP[n] = (byte)n2++;
        }
        for (n = 97; n <= 122; n = (int)((char)(n + 1))) {
            Base64InputStream.LOOKUP[n] = (byte)n2++;
        }
        for (n = 48; n <= 57; n = (int)((char)(n + 1))) {
            Base64InputStream.LOOKUP[n] = (byte)n2++;
        }
        Base64InputStream.LOOKUP[45] = (byte)n2;
        Base64InputStream.LOOKUP[43] = (byte)n2++;
        Base64InputStream.LOOKUP[95] = (byte)n2;
        Base64InputStream.LOOKUP[47] = (byte)n2++;
    }
}

