/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.output.svg;

import ai.org.krysalis.barcode4j.BarcodeDimension;
import ai.org.krysalis.barcode4j.TextAlignment;
import ai.org.krysalis.barcode4j.output.BarcodeCanvasSetupException;
import ai.org.krysalis.barcode4j.output.svg.AbstractSVGGeneratingCanvasProvider;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class SVGCanvasProvider
extends AbstractSVGGeneratingCanvasProvider {
    private DOMImplementation domImpl;
    private Document doc;
    private Element detailGroup;

    public SVGCanvasProvider(String string, int n) throws BarcodeCanvasSetupException {
        this(null, string, n);
    }

    public SVGCanvasProvider(DOMImplementation dOMImplementation, String string, int n) throws BarcodeCanvasSetupException {
        super(string, n);
        this.domImpl = dOMImplementation;
        this.init();
    }

    public SVGCanvasProvider(boolean bl, int n) throws BarcodeCanvasSetupException {
        this(null, bl, n);
    }

    public SVGCanvasProvider(DOMImplementation dOMImplementation, boolean bl, int n) throws BarcodeCanvasSetupException {
        super(bl, n);
        this.domImpl = dOMImplementation;
        this.init();
    }

    public SVGCanvasProvider(int n) throws BarcodeCanvasSetupException {
        super(n);
        this.init();
    }

    private void init() {
        this.doc = this.createDocument();
        Element element = this.doc.getDocumentElement();
        this.detailGroup = this.createElement("g");
        element.appendChild(this.detailGroup);
        this.detailGroup.setAttribute("fill", "black");
        this.detailGroup.setAttribute("stroke", "none");
    }

    private Element createElement(String string) {
        Element element = this.isNamespaceEnabled() ? this.doc.createElementNS("http://www.w3.org/2000/svg", this.getQualifiedName(string)) : this.doc.createElement(string);
        return element;
    }

    private Document createDocument() {
        try {
            Object object;
            if (this.domImpl == null) {
                object = DocumentBuilderFactory.newInstance();
                ((DocumentBuilderFactory)object).setNamespaceAware(true);
                ((DocumentBuilderFactory)object).setValidating(false);
                DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
                this.domImpl = documentBuilder.getDOMImplementation();
            }
            if (this.isNamespaceEnabled()) {
                object = this.domImpl.createDocument("http://www.w3.org/2000/svg", this.getQualifiedName("svg"), null);
                return object;
            }
            return this.domImpl.createDocument(null, "svg", null);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException.getMessage());
        }
    }

    public Document getDOM() {
        return this.doc;
    }

    public DocumentFragment getDOMFragment() {
        DocumentFragment documentFragment = this.doc.createDocumentFragment();
        documentFragment.appendChild(this.doc.importNode(this.doc.getFirstChild(), true));
        return documentFragment;
    }

    public void establishDimensions(BarcodeDimension barcodeDimension) {
        String string;
        super.establishDimensions(barcodeDimension);
        int n = BarcodeDimension.normalizeOrientation(this.getOrientation());
        Element element = this.doc.getDocumentElement();
        element.setAttribute("width", this.addUnit(barcodeDimension.getWidthPlusQuiet(n)));
        element.setAttribute("height", this.addUnit(barcodeDimension.getHeightPlusQuiet(n)));
        String string2 = this.getDecimalFormat().format(barcodeDimension.getWidthPlusQuiet(n));
        String string3 = this.getDecimalFormat().format(barcodeDimension.getHeightPlusQuiet(n));
        element.setAttribute("viewBox", "0 0 " + string2 + " " + string3);
        switch (n) {
            case 90: {
                string = "rotate(-90) translate(-" + string3 + ")";
                break;
            }
            case 180: {
                string = "rotate(-180) translate(-" + string2 + " -" + string3 + ")";
                break;
            }
            case 270: {
                string = "rotate(-270) translate(0 -" + string2 + ")";
                break;
            }
            default: {
                string = null;
            }
        }
        if (string != null) {
            this.detailGroup.setAttribute("transform", string);
        }
    }

    public void deviceFillRect(double d, double d2, double d3, double d4) {
        Element element = this.createElement("rect");
        element.setAttribute("x", this.getDecimalFormat().format(d));
        element.setAttribute("y", this.getDecimalFormat().format(d2));
        element.setAttribute("width", this.getDecimalFormat().format(d3));
        element.setAttribute("height", this.getDecimalFormat().format(d4));
        this.detailGroup.appendChild(element);
    }

    public void deviceText(String string, double d, double d2, double d3, String string2, double d4, TextAlignment textAlignment) {
        double d5;
        String string3;
        Element element = this.createElement("text");
        if (textAlignment == TextAlignment.TA_LEFT) {
            string3 = "start";
            d5 = d;
        } else if (textAlignment == TextAlignment.TA_RIGHT) {
            string3 = "end";
            d5 = d2;
        } else {
            string3 = "middle";
            d5 = d + (d2 - d) / 2.0;
        }
        element.setAttribute("font-family", string2);
        element.setAttribute("font-size", this.getDecimalFormat().format(d4));
        element.setAttribute("text-anchor", string3);
        element.setAttribute("x", this.getDecimalFormat().format(d5));
        element.setAttribute("y", this.getDecimalFormat().format(d3));
        if (textAlignment == TextAlignment.TA_JUSTIFY) {
            element.setAttribute("textLength", this.getDecimalFormat().format(d2 - d));
        }
        element.appendChild(this.doc.createTextNode(string));
        this.detailGroup.appendChild(element);
    }
}

