/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.output.eps;

import ai.org.krysalis.barcode4j.BarcodeDimension;
import ai.org.krysalis.barcode4j.TextAlignment;
import ai.org.krysalis.barcode4j.output.AbstractCanvasProvider;
import ai.org.krysalis.barcode4j.tools.UnitConv;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EPSCanvasProvider
extends AbstractCanvasProvider {
    private Writer writer;
    private DecimalFormat df;
    private IOException firstError;
    private double height;

    public EPSCanvasProvider(OutputStream outputStream, int n) throws IOException {
        super(n);
        try {
            this.writer = new OutputStreamWriter(outputStream, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Incompatible VM: Need US-ASCII encoding. " + unsupportedEncodingException.getMessage());
        }
    }

    protected DecimalFormat getDecimalFormat() {
        if (this.df == null) {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator('.');
            this.df = new DecimalFormat("0.####", decimalFormatSymbols);
        }
        return this.df;
    }

    private String format(double d) {
        return this.getDecimalFormat().format(d);
    }

    private String formatmm(double d) {
        return this.getDecimalFormat().format(UnitConv.mm2pt(d));
    }

    private String formatmm(double d, double d2) {
        return this.formatmm(d) + " " + this.formatmm(this.height - d2);
    }

    private void writeHeader(double d, double d2) throws IOException {
        this.writer.write("%!PS-Adobe-3.0 EPSF-3.0\n");
        double d3 = UnitConv.mm2pt(d);
        double d4 = UnitConv.mm2pt(d2);
        this.writer.write("%%BoundingBox: 0 0 " + Math.round(Math.ceil(d3)) + " " + Math.round(Math.ceil(d4)) + "\n");
        this.writer.write("%%HiResBoundingBox: 0 0 " + this.format(d3) + " " + this.format(d4) + "\n");
        this.writer.write("%%Creator: Barcode4J (http://barcode4j.krysalis.org)\n");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        this.writer.write("%%CreationDate: " + simpleDateFormat.format(new Date()) + "\n");
        this.writer.write("%%LanguageLevel: 1\n");
        this.writer.write("%%EndComments\n");
        this.writer.write("%%BeginProlog\n");
        this.writer.write("%%BeginProcSet: barcode4j-procset 1.1\n");
        this.writer.write("/rf {\n");
        this.writer.write("newpath\n");
        this.writer.write("4 -2 roll moveto\n");
        this.writer.write("dup neg 0 exch rlineto\n");
        this.writer.write("exch 0 rlineto\n");
        this.writer.write("0 neg exch rlineto\n");
        this.writer.write("closepath fill\n");
        this.writer.write("} def\n");
        this.writer.write("/ct {\n");
        this.writer.write("moveto dup stringwidth\n");
        this.writer.write("2 div neg exch 2 div neg exch\n");
        this.writer.write("rmoveto show\n");
        this.writer.write("} def\n");
        this.writer.write("/rt {\n");
        this.writer.write("4 -1 roll dup stringwidth pop\n");
        this.writer.write("5 -2 roll 1 index sub\n");
        this.writer.write("3 -1 roll sub\n");
        this.writer.write("add\n");
        this.writer.write("3 -1 roll moveto show\n");
        this.writer.write("} def\n");
        this.writer.write("/jt {\n");
        this.writer.write("4 -1 roll dup stringwidth pop\n");
        this.writer.write("5 -2 roll 1 index sub\n");
        this.writer.write("3 -1 roll sub\n");
        this.writer.write("2 index length\n");
        this.writer.write("1 sub div\n");
        this.writer.write("0 4 -1 roll 4 -1 roll 5 -1 roll\n");
        this.writer.write("moveto ashow\n");
        this.writer.write("} def\n");
        this.writer.write("%%EndProcSet: barcode4j-procset 1.0\n");
        this.writer.write("%%EndProlog\n");
    }

    public void finish() throws IOException {
        if (this.firstError != null) {
            throw this.firstError;
        }
        this.writer.write("%%EOF\n");
        this.writer.flush();
    }

    public void establishDimensions(BarcodeDimension barcodeDimension) {
        super.establishDimensions(barcodeDimension);
        int n = BarcodeDimension.normalizeOrientation(this.getOrientation());
        if (this.firstError != null) {
            return;
        }
        this.height = barcodeDimension.getHeightPlusQuiet();
        try {
            this.writeHeader(barcodeDimension.getWidthPlusQuiet(n), barcodeDimension.getHeightPlusQuiet(n));
            String string = this.formatmm(barcodeDimension.getWidthPlusQuiet());
            String string2 = this.formatmm(barcodeDimension.getHeightPlusQuiet());
            switch (n) {
                case 90: {
                    this.writer.write("90 rotate 0 -" + string2 + " translate\n");
                    break;
                }
                case 180: {
                    this.writer.write("180 rotate -" + string + " -" + string2 + " translate\n");
                    break;
                }
                case 270: {
                    this.writer.write("270 rotate -" + string + " 0 translate\n");
                    break;
                }
            }
        }
        catch (IOException iOException) {
            this.firstError = iOException;
        }
    }

    public void deviceFillRect(double d, double d2, double d3, double d4) {
        if (this.firstError != null) {
            return;
        }
        try {
            this.writer.write(this.formatmm(d, d2) + " " + this.formatmm(d3) + " " + this.formatmm(d4) + " rf\n");
        }
        catch (IOException iOException) {
            this.firstError = iOException;
        }
    }

    public void deviceText(String string, double d, double d2, double d3, String string2, double d4, TextAlignment textAlignment) {
        if (this.firstError != null) {
            return;
        }
        this.checkFontName(string2);
        try {
            this.writer.write("/" + string2 + " findfont " + UnitConv.mm2pt(d4) + " scalefont setfont\n");
            if (textAlignment == TextAlignment.TA_LEFT) {
                this.writer.write(this.formatmm(d, d3) + " moveto (" + string + ") show\n");
            } else if (textAlignment == TextAlignment.TA_RIGHT) {
                this.writer.write("(" + string + ") " + this.formatmm(d) + " " + this.formatmm(d2) + " " + this.formatmm(this.height - d3) + " rt\n");
            } else if (textAlignment == TextAlignment.TA_CENTER) {
                this.writer.write("(" + string + ") " + this.formatmm((d + d2) / 2.0, d3) + " ct\n");
            } else if (textAlignment == TextAlignment.TA_JUSTIFY) {
                this.writer.write("(" + string + ") " + this.formatmm(d) + " " + this.formatmm(d2) + " " + this.formatmm(this.height - d3) + " jt\n");
            }
        }
        catch (IOException iOException) {
            this.firstError = iOException;
        }
    }

    private void checkFontName(String string) {
        if (string.indexOf(32) >= 0) {
            throw new IllegalArgumentException("PostScript/EPS output does not support font names with spaces ('" + string + "'). Please use the PostScript name of the font!");
        }
    }
}

