/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.output.bitmap;

import ai.org.krysalis.barcode4j.output.bitmap.BitmapEncoder;
import ai.org.krysalis.barcode4j.output.bitmap.ImageIOBitmapEncoder;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class BitmapEncoderRegistry {
    private static Set encoders = new TreeSet();

    protected BitmapEncoderRegistry() {
        throw new UnsupportedOperationException();
    }

    private static synchronized void register(String string, int n, boolean bl) {
        boolean bl2 = false;
        try {
            Class<?> clazz = Class.forName(string);
            BitmapEncoder bitmapEncoder = (BitmapEncoder)clazz.newInstance();
            encoders.add(new Entry(bitmapEncoder, n));
        }
        catch (Exception exception) {
            bl2 = true;
        }
        catch (LinkageError linkageError) {
            bl2 = true;
        }
        if (bl2) {
            if (bl) {
                throw new IllegalArgumentException("The implementation being registered is unavailable or cannot be instantiated: " + string);
            }
            return;
        }
    }

    public static void register(String string, int n) {
        BitmapEncoderRegistry.register(string, n, true);
    }

    public static boolean supports(BitmapEncoder bitmapEncoder, String string) {
        String[] stringArray = bitmapEncoder.getSupportedMIMETypes();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean supports(String string) {
        for (Entry entry : encoders) {
            BitmapEncoder bitmapEncoder = entry.encoder;
            if (!BitmapEncoderRegistry.supports(bitmapEncoder, string)) continue;
            return true;
        }
        return false;
    }

    public static BitmapEncoder getInstance(String string) {
        for (Entry entry : encoders) {
            BitmapEncoder bitmapEncoder = entry.encoder;
            if (!BitmapEncoderRegistry.supports(bitmapEncoder, string)) continue;
            return bitmapEncoder;
        }
        throw new UnsupportedOperationException("No BitmapEncoder available for " + string);
    }

    public static Set getSupportedMIMETypes() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Entry entry : encoders) {
            BitmapEncoder bitmapEncoder = entry.encoder;
            String[] stringArray = bitmapEncoder.getSupportedMIMETypes();
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
        }
        return hashSet;
    }

    static {
        BitmapEncoderRegistry.register(ImageIOBitmapEncoder.class.getName(), 0, false);
    }

    private static class Entry
    implements Comparable {
        private BitmapEncoder encoder;
        private int priority;

        public Entry(BitmapEncoder bitmapEncoder, int n) {
            this.encoder = bitmapEncoder;
            this.priority = n;
        }

        public int compareTo(Object object) {
            Entry entry = (Entry)object;
            return entry.priority - this.priority;
        }
    }
}

