/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.output.bitmap;

import ai.org.krysalis.barcode4j.BarcodeDimension;
import ai.org.krysalis.barcode4j.TextAlignment;
import ai.org.krysalis.barcode4j.output.AbstractCanvasProvider;
import ai.org.krysalis.barcode4j.output.bitmap.BitmapBuilder;
import ai.org.krysalis.barcode4j.output.bitmap.BitmapEncoder;
import ai.org.krysalis.barcode4j.output.bitmap.BitmapEncoderRegistry;
import ai.org.krysalis.barcode4j.output.java2d.Java2DCanvasProvider;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;

public class BitmapCanvasProvider
extends AbstractCanvasProvider {
    private OutputStream out;
    private String mime;
    private int resolution;
    private int imageType;
    private boolean antiAlias;
    private BufferedImage image;
    private Java2DCanvasProvider delegate;

    public BitmapCanvasProvider(OutputStream outputStream, String string, int n, int n2, boolean bl, int n3) {
        super(n3);
        this.out = outputStream;
        this.mime = string;
        this.resolution = n;
        this.imageType = n2;
        this.antiAlias = bl;
    }

    public BitmapCanvasProvider(int n, int n2, boolean bl, int n3) {
        this(null, null, n, n2, bl, n3);
    }

    public void finish() throws IOException {
        this.image.flush();
        if (this.out != null) {
            BitmapEncoder bitmapEncoder = BitmapEncoderRegistry.getInstance(this.mime);
            bitmapEncoder.encode(this.image, this.out, this.mime, this.resolution);
        }
    }

    public BufferedImage getBufferedImage() {
        return this.image;
    }

    public void establishDimensions(BarcodeDimension barcodeDimension) {
        super.establishDimensions(barcodeDimension);
        this.image = BitmapBuilder.prepareImage(barcodeDimension, this.getOrientation(), this.resolution, this.imageType);
        this.delegate = new Java2DCanvasProvider(BitmapBuilder.prepareGraphics2D(this.image, barcodeDimension, this.getOrientation(), this.antiAlias), this.getOrientation());
        this.delegate.establishDimensions(barcodeDimension);
    }

    public void deviceFillRect(double d, double d2, double d3, double d4) {
        this.delegate.deviceFillRect(d, d2, d3, d4);
    }

    public void deviceText(String string, double d, double d2, double d3, String string2, double d4, TextAlignment textAlignment) {
        this.delegate.deviceText(string, d, d2, d3, string2, d4, textAlignment);
    }
}

