/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.upcean;

import ai.org.krysalis.barcode4j.BarGroup;
import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.ClassicBarcodeLogicHandler;

public abstract class UPCEANLogicImpl {
    protected static final byte LEFT_HAND_A = 0;
    protected static final byte LEFT_HAND_B = 1;
    protected static final byte RIGHT_HAND = 2;
    protected static final byte ODD_PARITY = 0;
    protected static final byte EVEN_PARITY = 1;
    private static final byte[][] CHARSET = new byte[][]{{3, 2, 1, 1}, {2, 2, 2, 1}, {2, 1, 2, 2}, {1, 4, 1, 1}, {1, 1, 3, 2}, {1, 2, 3, 1}, {1, 1, 1, 4}, {1, 3, 1, 2}, {1, 2, 1, 3}, {3, 1, 1, 2}};
    private static final byte O = 0;
    private static final byte E = 1;
    private static final byte[][] SUPP2_PARITY = new byte[][]{{0, 0}, {0, 1}, {1, 0}, {1, 1}};
    private static final byte[][] SUPP5_PARITY = new byte[][]{{1, 1, 0, 0, 0}, {1, 0, 1, 0, 0}, {1, 0, 0, 1, 0}, {1, 0, 0, 0, 1}, {0, 1, 1, 0, 0}, {0, 0, 1, 1, 0}, {0, 0, 0, 1, 1}, {0, 1, 0, 1, 0}, {0, 1, 0, 0, 1}, {0, 0, 1, 0, 1}};
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;

    public UPCEANLogicImpl(ChecksumMode checksumMode) {
        this.checksumMode = checksumMode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public static void validateMessage(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            throw new IllegalArgumentException("Invalid characters found. Valid are 0-9 only. Message: " + string);
        }
    }

    public static char calcChecksum(String string) {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = string.length() - 1; n >= 0; --n) {
            if ((string.length() - n) % 2 == 0) {
                n3 += Character.digit(string.charAt(n), 10);
                continue;
            }
            n2 += Character.digit(string.charAt(n), 10);
        }
        n = 10 - (n3 + 3 * n2) % 10;
        if (n >= 10) {
            n = 0;
        }
        return Character.forDigit(n, 10);
    }

    private int widthAt(char c, int n) {
        if (Character.isDigit(c)) {
            int n2 = Character.digit(c, 10);
            byte by = CHARSET[n2][n];
            return by;
        }
        throw new IllegalArgumentException("Invalid character '" + c + "'. Expected a digit.");
    }

    protected void encodeChar(ClassicBarcodeLogicHandler classicBarcodeLogicHandler, char c, int n) {
        classicBarcodeLogicHandler.startBarGroup(BarGroup.MSG_CHARACTER, new Character(c).toString());
        if (n == 1) {
            for (int n2 = 0; n2 < 4; n2 = (int)((byte)(n2 + 1))) {
                int n3 = this.widthAt(c, 3 - n2);
                boolean bl = n2 % 2 != 0;
                classicBarcodeLogicHandler.addBar(bl, n3);
            }
        } else {
            for (int n4 = 0; n4 < 4; n4 = (int)((byte)(n4 + 1))) {
                int n5 = this.widthAt(c, n4);
                boolean bl = n4 % 2 == 0 && n == 2 || n4 % 2 != 0 && n == 0;
                classicBarcodeLogicHandler.addBar(bl, n5);
            }
        }
        classicBarcodeLogicHandler.endBarGroup();
    }

    protected void drawSideGuard(ClassicBarcodeLogicHandler classicBarcodeLogicHandler) {
        classicBarcodeLogicHandler.startBarGroup(BarGroup.UPC_EAN_GUARD, null);
        classicBarcodeLogicHandler.addBar(true, 1);
        classicBarcodeLogicHandler.addBar(false, 1);
        classicBarcodeLogicHandler.addBar(true, 1);
        classicBarcodeLogicHandler.endBarGroup();
    }

    protected void drawCenterGuard(ClassicBarcodeLogicHandler classicBarcodeLogicHandler) {
        classicBarcodeLogicHandler.startBarGroup(BarGroup.UPC_EAN_GUARD, null);
        classicBarcodeLogicHandler.addBar(false, 1);
        classicBarcodeLogicHandler.addBar(true, 1);
        classicBarcodeLogicHandler.addBar(false, 1);
        classicBarcodeLogicHandler.addBar(true, 1);
        classicBarcodeLogicHandler.addBar(false, 1);
        classicBarcodeLogicHandler.endBarGroup();
    }

    private void drawSuppLeftGuard(ClassicBarcodeLogicHandler classicBarcodeLogicHandler) {
        classicBarcodeLogicHandler.startBarGroup(BarGroup.UPC_EAN_GUARD, null);
        classicBarcodeLogicHandler.addBar(true, 1);
        classicBarcodeLogicHandler.addBar(false, 1);
        classicBarcodeLogicHandler.addBar(true, 2);
        classicBarcodeLogicHandler.endBarGroup();
    }

    private void drawSuppSeparator(ClassicBarcodeLogicHandler classicBarcodeLogicHandler) {
        classicBarcodeLogicHandler.startBarGroup(BarGroup.UPC_EAN_GUARD, null);
        classicBarcodeLogicHandler.addBar(false, 1);
        classicBarcodeLogicHandler.addBar(true, 1);
        classicBarcodeLogicHandler.endBarGroup();
    }

    private void drawSupplemental2(ClassicBarcodeLogicHandler classicBarcodeLogicHandler, String string) {
        int n = Integer.parseInt(string);
        int n2 = n % 4;
        classicBarcodeLogicHandler.startBarGroup(BarGroup.UPC_EAN_SUPP, string);
        this.drawSuppLeftGuard(classicBarcodeLogicHandler);
        this.encodeChar(classicBarcodeLogicHandler, string.charAt(0), SUPP2_PARITY[n2][0]);
        this.drawSuppSeparator(classicBarcodeLogicHandler);
        this.encodeChar(classicBarcodeLogicHandler, string.charAt(1), SUPP2_PARITY[n2][1]);
        classicBarcodeLogicHandler.endBarGroup();
    }

    private void drawSupplemental5(ClassicBarcodeLogicHandler classicBarcodeLogicHandler, String string) {
        int n = Integer.parseInt(string);
        int n2 = 3 * (n / 10000 % 10) + 9 * (n / 1000 % 10) + 3 * (n / 100 % 10) + 9 * (n / 10 % 10) + 3 * (n % 10);
        byte by = (byte)(n2 % 10);
        classicBarcodeLogicHandler.startBarGroup(BarGroup.UPC_EAN_SUPP, string);
        this.drawSuppLeftGuard(classicBarcodeLogicHandler);
        for (int n3 = 0; n3 < 5; n3 = (int)((byte)(n3 + 1))) {
            if (n3 > 0) {
                this.drawSuppSeparator(classicBarcodeLogicHandler);
            }
            this.encodeChar(classicBarcodeLogicHandler, string.charAt(n3), SUPP5_PARITY[by][n3]);
        }
        classicBarcodeLogicHandler.endBarGroup();
    }

    protected void drawSupplemental(ClassicBarcodeLogicHandler classicBarcodeLogicHandler, String string) {
        if (string == null) {
            throw new NullPointerException("Supplemental message must not be null");
        }
        if (string.length() == 2) {
            this.drawSupplemental2(classicBarcodeLogicHandler, string);
        } else if (string.length() == 5) {
            this.drawSupplemental5(classicBarcodeLogicHandler, string);
        } else {
            throw new IllegalArgumentException("Only supplemental lengths 2 and 5 are allowed: " + string.length());
        }
    }

    protected static int getSupplementalLength(String string) {
        String string2 = UPCEANLogicImpl.retrieveSupplemental(string);
        if (string2 == null) {
            return 0;
        }
        if (string2.length() == 2) {
            return 2;
        }
        if (string2.length() == 5) {
            return 5;
        }
        throw new IllegalArgumentException("Illegal supplemental length (valid: 2 or 5): " + string2);
    }

    protected static String removeSupplemental(String string) {
        int n = string.indexOf(43);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    protected static String retrieveSupplemental(String string) {
        int n = string.indexOf(43);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return null;
    }

    public abstract void generateBarcodeLogic(ClassicBarcodeLogicHandler var1, String var2);
}

