/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.upcean;

import ai.org.krysalis.barcode4j.BarcodeDimension;
import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import ai.org.krysalis.barcode4j.impl.upcean.UPCEANCanvasLogicHandler;
import ai.org.krysalis.barcode4j.impl.upcean.UPCEANLogicImpl;
import ai.org.krysalis.barcode4j.output.Canvas;
import ai.org.krysalis.barcode4j.output.CanvasProvider;

public abstract class UPCEANBean
extends AbstractBarcodeBean {
    protected static final double DEFAULT_MODULE_WIDTH = (double)0.33f;
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;

    public UPCEANBean() {
        this.moduleWidth = 0.33f;
        this.setQuietZone(10.0 * this.moduleWidth);
        this.setVerticalQuietZone(0.0);
    }

    public void setChecksumMode(ChecksumMode checksumMode) {
        this.checksumMode = checksumMode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public double getBarWidth(int n) {
        if (n >= 1 && n <= 4) {
            return (double)n * this.moduleWidth;
        }
        throw new IllegalArgumentException("Only widths 1 to 4 allowed");
    }

    public abstract UPCEANLogicImpl createLogicImpl();

    public void generateBarcode(CanvasProvider canvasProvider, String string) {
        if (string == null || string.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        UPCEANCanvasLogicHandler uPCEANCanvasLogicHandler = new UPCEANCanvasLogicHandler(this, new Canvas(canvasProvider));
        UPCEANLogicImpl uPCEANLogicImpl = this.createLogicImpl();
        uPCEANLogicImpl.generateBarcodeLogic(uPCEANCanvasLogicHandler, string);
    }

    protected double supplementalWidth(String string) {
        double d = 0.0;
        int n = UPCEANLogicImpl.getSupplementalLength(string);
        if (n > 0) {
            d += this.quietZone;
            d += 4.0 * this.moduleWidth;
            d += (double)(n * 7) * this.moduleWidth;
            d += (double)((n - 1) * 2) * this.moduleWidth;
        }
        return d;
    }

    public BarcodeDimension calcDimensions(String string) {
        double d = 3.0 * this.moduleWidth;
        d += 42.0 * this.moduleWidth;
        d += 5.0 * this.moduleWidth;
        d += 42.0 * this.moduleWidth;
        d += 3.0 * this.moduleWidth;
        double d2 = this.hasQuietZone() ? this.quietZone : 0.0;
        return new BarcodeDimension(d += this.supplementalWidth(string), this.getHeight(), d + 2.0 * d2, this.getHeight(), this.quietZone, 0.0);
    }
}

