/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.upcean;

import ai.org.krysalis.barcode4j.BarGroup;
import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import ai.org.krysalis.barcode4j.impl.upcean.UPCEANLogicImpl;

public class UPCALogicImpl
extends UPCEANLogicImpl {
    public UPCALogicImpl(ChecksumMode checksumMode) {
        super(checksumMode);
    }

    public static void validateMessage(String string) {
        UPCEANLogicImpl.validateMessage(string);
        if (string.length() < 11 || string.length() > 12) {
            throw new IllegalArgumentException("Message must be 11 or 12 characters long. Message: " + string);
        }
    }

    public static String handleChecksum(String string, ChecksumMode checksumMode) {
        if (checksumMode == ChecksumMode.CP_AUTO) {
            if (string.length() == 11) {
                checksumMode = ChecksumMode.CP_ADD;
            } else if (string.length() == 12) {
                checksumMode = ChecksumMode.CP_CHECK;
            } else {
                throw new RuntimeException("Internal error");
            }
        }
        if (checksumMode == ChecksumMode.CP_ADD) {
            if (string.length() != 11) {
                throw new IllegalArgumentException("Message must be 11 characters long");
            }
            return string + UPCALogicImpl.calcChecksum(string);
        }
        if (checksumMode == ChecksumMode.CP_CHECK) {
            char c;
            if (string.length() != 12) {
                throw new IllegalArgumentException("Message must be 12 characters long");
            }
            char c2 = string.charAt(11);
            if (c2 != (c = UPCALogicImpl.calcChecksum(string.substring(0, 11)))) {
                throw new IllegalArgumentException("Checksum is bad (" + c2 + "). Expected: " + c);
            }
            return string;
        }
        if (checksumMode == ChecksumMode.CP_IGNORE) {
            if (string.length() != 12) {
                throw new IllegalArgumentException("Message must be 12 characters long");
            }
            return string;
        }
        throw new UnsupportedOperationException("Unknown checksum mode: " + checksumMode);
    }

    private String handleChecksum(String string) {
        return UPCALogicImpl.handleChecksum(string, this.getChecksumMode());
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler classicBarcodeLogicHandler, String string) {
        char c;
        String string2 = UPCALogicImpl.retrieveSupplemental(string);
        String string3 = UPCALogicImpl.removeSupplemental(string);
        UPCALogicImpl.validateMessage(string3);
        String string4 = string3 = this.handleChecksum(string3);
        if (string2 != null) {
            string4 = string4 + "+" + string2;
        }
        classicBarcodeLogicHandler.startBarcode(string4, string4);
        this.drawSideGuard(classicBarcodeLogicHandler);
        char c2 = string3.charAt(0);
        classicBarcodeLogicHandler.startBarGroup(BarGroup.UPC_EAN_LEAD, new Character(c2).toString());
        this.encodeChar(classicBarcodeLogicHandler, c2, 0);
        classicBarcodeLogicHandler.endBarGroup();
        classicBarcodeLogicHandler.startBarGroup(BarGroup.UPC_EAN_GROUP, string3.substring(1, 6));
        for (c = '\u0001'; c < '\u0006'; ++c) {
            this.encodeChar(classicBarcodeLogicHandler, string3.charAt(c), 0);
        }
        classicBarcodeLogicHandler.endBarGroup();
        this.drawCenterGuard(classicBarcodeLogicHandler);
        classicBarcodeLogicHandler.startBarGroup(BarGroup.UPC_EAN_GROUP, string3.substring(6, 11));
        for (c = '\u0006'; c < '\u000b'; ++c) {
            this.encodeChar(classicBarcodeLogicHandler, string3.charAt(c), 2);
        }
        classicBarcodeLogicHandler.endBarGroup();
        c = string3.charAt(11);
        classicBarcodeLogicHandler.startBarGroup(BarGroup.UPC_EAN_CHECK, new Character(c).toString());
        this.encodeChar(classicBarcodeLogicHandler, c, 2);
        classicBarcodeLogicHandler.endBarGroup();
        this.drawSideGuard(classicBarcodeLogicHandler);
        if (string2 != null) {
            this.drawSupplemental(classicBarcodeLogicHandler, string2);
        }
        classicBarcodeLogicHandler.endBarcode();
    }
}

