/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.postnet;

import ai.org.krysalis.barcode4j.BarcodeDimension;
import ai.org.krysalis.barcode4j.BaselineAlignment;
import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.HumanReadablePlacement;
import ai.org.krysalis.barcode4j.impl.HeightVariableBarcodeBean;
import ai.org.krysalis.barcode4j.impl.postnet.POSTNETLogicHandler;
import ai.org.krysalis.barcode4j.impl.postnet.POSTNETLogicImpl;
import ai.org.krysalis.barcode4j.output.Canvas;
import ai.org.krysalis.barcode4j.output.CanvasProvider;
import ai.org.krysalis.barcode4j.tools.UnitConv;

public class POSTNETBean
extends HeightVariableBarcodeBean {
    static final double DEFAULT_MODULE_WIDTH = (double)0.02f;
    static final double DEFAULT_TALL_BAR_HEIGHT = 0.125;
    static final double DEFAULT_SHORT_BAR_HEIGHT = (double)0.05f;
    static final double DEFAULT_HORZ_QUIET_ZONE_INCH = 0.125;
    static final double DEFAULT_VERT_QUIET_ZONE_INCH = 0.04;
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private double intercharGapWidth;
    private BaselineAlignment baselinePosition = BaselineAlignment.ALIGN_BOTTOM;
    private double shortBarHeight = UnitConv.in2mm(0.05f);
    private boolean displayChecksum = false;
    private Double quietZoneVertical;

    public POSTNETBean() {
        this.msgPos = HumanReadablePlacement.HRP_NONE;
        this.intercharGapWidth = this.moduleWidth = UnitConv.in2mm(0.02f);
        this.setQuietZone(UnitConv.in2mm(0.125));
        this.setVerticalQuietZone(UnitConv.in2mm(0.04));
        this.setBarHeight(UnitConv.in2mm(0.125));
    }

    public void setVerticalQuietZone(double d) {
        this.quietZoneVertical = new Double(d);
    }

    public double getVerticalQuietZone() {
        if (this.quietZoneVertical != null) {
            return this.quietZoneVertical;
        }
        return this.getQuietZone();
    }

    public void setChecksumMode(ChecksumMode checksumMode) {
        this.checksumMode = checksumMode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public double getIntercharGapWidth() {
        return this.intercharGapWidth;
    }

    public void setIntercharGapWidth(double d) {
        this.intercharGapWidth = d;
    }

    public double getShortBarHeight() {
        return this.shortBarHeight;
    }

    public void setShortBarHeight(double d) {
        this.shortBarHeight = d;
    }

    public double getBarWidth(int n) {
        if (n == 1) {
            return this.moduleWidth;
        }
        if (n == -1) {
            return this.intercharGapWidth;
        }
        throw new IllegalArgumentException("Only width 1 allowed");
    }

    public double getBarHeight(int n) {
        if (n == 2) {
            return this.getBarHeight();
        }
        if (n == 1) {
            return this.shortBarHeight;
        }
        if (n == -1) {
            return this.getBarHeight();
        }
        throw new IllegalArgumentException("Only height 0 or 1 allowed");
    }

    public boolean isDisplayChecksum() {
        return this.displayChecksum;
    }

    public void setDisplayChecksum(boolean bl) {
        this.displayChecksum = bl;
    }

    public void generateBarcode(CanvasProvider canvasProvider, String string) {
        if (string == null || string.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        POSTNETLogicHandler pOSTNETLogicHandler = new POSTNETLogicHandler(this, new Canvas(canvasProvider));
        POSTNETLogicImpl pOSTNETLogicImpl = new POSTNETLogicImpl(this.getChecksumMode(), this.isDisplayChecksum());
        pOSTNETLogicImpl.generateBarcodeLogic(pOSTNETLogicHandler, string);
    }

    public BarcodeDimension calcDimensions(String string) {
        String string2 = POSTNETLogicImpl.removeIgnoredCharacters(string);
        double d = (double)(string2.length() * 5 + 2) * this.moduleWidth + (double)(string2.length() * 5 + 1) * this.intercharGapWidth;
        double d2 = this.hasQuietZone() ? this.quietZone : 0.0;
        double d3 = this.hasQuietZone() ? this.getVerticalQuietZone() : 0.0;
        double d4 = this.getHeight();
        if (this.getMsgPosition() == HumanReadablePlacement.HRP_NONE) {
            d4 -= this.getHumanReadableHeight();
        }
        return new BarcodeDimension(d, d4, d + 2.0 * d2, d4 + 2.0 * d3, this.quietZone, d3);
    }

    public BaselineAlignment getBaselinePosition() {
        return this.baselinePosition;
    }

    public void setBaselinePosition(BaselineAlignment baselineAlignment) {
        this.baselinePosition = baselineAlignment;
    }
}

