/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.pdf417;

import ai.org.krysalis.barcode4j.BarGroup;
import ai.org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import ai.org.krysalis.barcode4j.TwoDimBarcodeLogicHandler;
import ai.org.krysalis.barcode4j.impl.pdf417.PDF417Bean;
import ai.org.krysalis.barcode4j.impl.pdf417.PDF417Constants;
import ai.org.krysalis.barcode4j.impl.pdf417.PDF417ErrorCorrection;
import ai.org.krysalis.barcode4j.impl.pdf417.PDF417HighLevelEncoder;
import java.awt.Dimension;

public class PDF417LogicImpl {
    public static int getNumberOfRows(int n, int n2, int n3) {
        int n4 = PDF417LogicImpl.calculateNumberOfRows(n, n2, n3);
        if (n4 > 90) {
            throw new IllegalArgumentException("The message doesn't fit in the configured symbol size. The resultant number of rows for this barcode exceeds 90. Please increase the number of columns or decrease the error correction level to reduce the number of rows.");
        }
        if (n4 < 3) {
            throw new IllegalArgumentException("The message is too short for the configured symbol size. The resultant number of rows is less than 3. Please decrease the number of columns or increase the error correction level to increase the number of rows.");
        }
        return n4;
    }

    public static int calculateNumberOfRows(int n, int n2, int n3) {
        int n4 = (n + 1 + n2) / n3 + 1;
        if (n3 * n4 >= n + 1 + n2 + n3) {
            --n4;
        }
        return n4;
    }

    public static int getNumberOfPadCodewords(int n, int n2, int n3, int n4) {
        int n5 = n3 * n4 - n2;
        if (n5 > n + 1) {
            return n5 - n - 1;
        }
        return 0;
    }

    public static int getNumberOfDataCodewords(int n, int n2, int n3) {
        int n4 = PDF417ErrorCorrection.getErrorCorrectionCodewordCount(n2);
        int n5 = PDF417LogicImpl.getNumberOfRows(n, n4, n3);
        return n3 * n5 - n4;
    }

    private static void encodeChar(int n, int n2, ClassicBarcodeLogicHandler classicBarcodeLogicHandler) {
        int n3 = 1 << n2 - 1;
        boolean bl = (n & n3) != 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            boolean bl2;
            boolean bl3 = bl2 = (n & n3) != 0;
            if (bl == bl2) {
                ++n4;
            } else {
                classicBarcodeLogicHandler.addBar(bl, n4);
                bl = bl2;
                n4 = 1;
            }
            n3 >>= 1;
        }
        classicBarcodeLogicHandler.addBar(bl, n4);
    }

    private static void encodeLowLevel(String string, int n, int n2, int n3, TwoDimBarcodeLogicHandler twoDimBarcodeLogicHandler) {
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5;
            int n6;
            int n7 = i % 3;
            twoDimBarcodeLogicHandler.startRow();
            twoDimBarcodeLogicHandler.startBarGroup(BarGroup.START_CHARACTER, null);
            PDF417LogicImpl.encodeChar(130728, 17, twoDimBarcodeLogicHandler);
            twoDimBarcodeLogicHandler.endBarGroup();
            if (n7 == 0) {
                n6 = 30 * (i / 3) + (n2 - 1) / 3;
                n5 = 30 * (i / 3) + (n - 1);
            } else if (n7 == 1) {
                n6 = 30 * (i / 3) + n3 * 3 + (n2 - 1) % 3;
                n5 = 30 * (i / 3) + (n2 - 1) / 3;
            } else {
                n6 = 30 * (i / 3) + (n - 1);
                n5 = 30 * (i / 3) + n3 * 3 + (n2 - 1) % 3;
            }
            twoDimBarcodeLogicHandler.startBarGroup(BarGroup.MSG_CHARACTER, null);
            int n8 = PDF417Constants.CODEWORD_TABLE[n7][n6];
            PDF417LogicImpl.encodeChar(n8, 17, twoDimBarcodeLogicHandler);
            twoDimBarcodeLogicHandler.endBarGroup();
            for (int j = 0; j < n; ++j) {
                twoDimBarcodeLogicHandler.startBarGroup(BarGroup.MSG_CHARACTER, null);
                n8 = PDF417Constants.CODEWORD_TABLE[n7][string.charAt(n4)];
                PDF417LogicImpl.encodeChar(n8, 17, twoDimBarcodeLogicHandler);
                twoDimBarcodeLogicHandler.endBarGroup();
                ++n4;
            }
            twoDimBarcodeLogicHandler.startBarGroup(BarGroup.MSG_CHARACTER, null);
            n8 = PDF417Constants.CODEWORD_TABLE[n7][n5];
            PDF417LogicImpl.encodeChar(n8, 17, twoDimBarcodeLogicHandler);
            twoDimBarcodeLogicHandler.endBarGroup();
            twoDimBarcodeLogicHandler.startBarGroup(BarGroup.STOP_CHARACTER, null);
            PDF417LogicImpl.encodeChar(260649, 18, twoDimBarcodeLogicHandler);
            twoDimBarcodeLogicHandler.endBarGroup();
            twoDimBarcodeLogicHandler.endRow();
        }
    }

    public static void generateBarcodeLogic(TwoDimBarcodeLogicHandler twoDimBarcodeLogicHandler, String string, PDF417Bean pDF417Bean) {
        int n = pDF417Bean.getErrorCorrectionLevel();
        int n2 = PDF417ErrorCorrection.getErrorCorrectionCodewordCount(n);
        String string2 = PDF417HighLevelEncoder.encodeHighLevel(string);
        int n3 = string2.length();
        Dimension dimension = PDF417LogicImpl.determineDimensions(pDF417Bean, n3);
        if (dimension == null) {
            throw new IllegalArgumentException("Unable to fit message in columns");
        }
        int n4 = dimension.height;
        int n5 = dimension.width;
        int n6 = PDF417LogicImpl.getNumberOfPadCodewords(n3, n2, n5, n4);
        int n7 = PDF417LogicImpl.getNumberOfDataCodewords(n3, n, n5);
        if (n7 > 929) {
            throw new IllegalArgumentException("Encoded message contains to many code words, message to big (" + string.length() + " bytes)");
        }
        StringBuffer stringBuffer = new StringBuffer(n7);
        stringBuffer.append((char)n7);
        stringBuffer.append(string2);
        for (int i = 0; i < n6; ++i) {
            stringBuffer.append('\u0384');
        }
        String string3 = stringBuffer.toString();
        String string4 = PDF417ErrorCorrection.generateErrorCorrection(string3, n);
        String string5 = string3 + string4;
        twoDimBarcodeLogicHandler.startBarcode(string, string);
        PDF417LogicImpl.encodeLowLevel(string5, n5, n4, n, twoDimBarcodeLogicHandler);
        twoDimBarcodeLogicHandler.endBarcode();
    }

    public static Dimension determineDimensions(PDF417Bean pDF417Bean, int n) {
        int n2;
        int n3 = pDF417Bean.getMinCols();
        int n4 = pDF417Bean.getMaxCols();
        int n5 = pDF417Bean.getMaxRows();
        int n6 = pDF417Bean.getMinRows();
        double d = pDF417Bean.getWidthToHeightRatio();
        double d2 = 0.0;
        Dimension dimension = null;
        int n7 = PDF417ErrorCorrection.getErrorCorrectionCodewordCount(pDF417Bean.getErrorCorrectionLevel());
        for (int i = n3; i <= n4 && (n2 = PDF417LogicImpl.calculateNumberOfRows(n, n7, i)) >= n6; ++i) {
            if (n2 > n5) continue;
            double d3 = (double)(17 * i + 69) * pDF417Bean.getModuleWidth() / ((double)n2 * pDF417Bean.getBarHeight());
            if (dimension != null && Math.abs(d3 - d) > Math.abs(d2 - d)) continue;
            d2 = d3;
            dimension = new Dimension(i, n2);
        }
        return dimension;
    }
}

