/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.pdf417;

import ai.org.krysalis.barcode4j.BarcodeDimension;
import ai.org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import ai.org.krysalis.barcode4j.impl.DefaultTwoDimCanvasLogicHandler;
import ai.org.krysalis.barcode4j.impl.pdf417.PDF417HighLevelEncoder;
import ai.org.krysalis.barcode4j.impl.pdf417.PDF417LogicImpl;
import ai.org.krysalis.barcode4j.output.Canvas;
import ai.org.krysalis.barcode4j.output.CanvasProvider;
import ai.org.krysalis.barcode4j.tools.UnitConv;
import java.awt.Dimension;

public class PDF417Bean
extends AbstractBarcodeBean {
    protected static final double DEFAULT_MODULE_WIDTH = UnitConv.in2mm(0.013888888888888888);
    protected static final int DEFAULT_X_TO_Y_FACTOR = 3;
    protected static final int DEFAULT_COLUMN_COUNT = 2;
    protected static final int DEFAULT_ERROR_CORRECTION_LEVEL = 0;
    private static final double DEFAULT_WIDTH_TO_HEIGHT_RATIO = 3.0;
    private static final int MAX_ROW_COUNT = 90;
    private static final int MIN_ROW_COUNT = 3;
    private static final int MIN_COLUMN_COUNT = 1;
    private static final int MAX_COLUMN_COUNT = 30;
    private int minRows = 3;
    private int maxRows = 90;
    private int minCols = 1;
    private int maxCols = 30;
    private double widthToHeightRatio = 3.0;
    private int errorCorrectionLevel = 0;

    public PDF417Bean() {
        this.moduleWidth = DEFAULT_MODULE_WIDTH;
        this.height = 3.0 * this.moduleWidth;
        this.setQuietZone(2.0 * this.moduleWidth);
        this.setColumns(2);
    }

    public void generateBarcode(CanvasProvider canvasProvider, String string) {
        if (string == null || string.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultTwoDimCanvasLogicHandler defaultTwoDimCanvasLogicHandler = new DefaultTwoDimCanvasLogicHandler(this, new Canvas(canvasProvider));
        PDF417LogicImpl.generateBarcodeLogic(defaultTwoDimCanvasLogicHandler, string, this);
    }

    public BarcodeDimension calcDimensions(String string) {
        int n = PDF417HighLevelEncoder.encodeHighLevel(string).length();
        Dimension dimension = PDF417LogicImpl.determineDimensions(this, n);
        if (dimension == null) {
            throw new IllegalArgumentException("Unable to fit message in columns");
        }
        double d = (double)(17 * dimension.width + 69) * this.getModuleWidth();
        double d2 = this.getBarHeight() * (double)dimension.height;
        double d3 = this.hasQuietZone() ? this.getQuietZone() : 0.0;
        double d4 = this.hasQuietZone() ? this.getVerticalQuietZone() : 0.0;
        return new BarcodeDimension(d, d2, d + 2.0 * d3, d2 + 2.0 * d4, d3, d4);
    }

    public double getBarWidth(int n) {
        return (double)n * this.moduleWidth;
    }

    public int getColumns() {
        return this.minCols;
    }

    public int getErrorCorrectionLevel() {
        return this.errorCorrectionLevel;
    }

    public int getMaxCols() {
        return this.maxCols;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public int getMinCols() {
        return this.minCols;
    }

    public int getMinRows() {
        return this.minRows;
    }

    public double getRowHeight() {
        return this.getBarHeight();
    }

    public double getWidthToHeightRatio() {
        return this.widthToHeightRatio;
    }

    private void checkValidColumnCount(int n) {
        if (n < 1 || n > 30) {
            throw new IllegalArgumentException("The number of columns must be between 1 and 30");
        }
    }

    private void checkValidRowCount(int n) {
        if (n < 3 || n > 90) {
            throw new IllegalArgumentException("The number of rows must be between 3 and 90");
        }
    }

    public void setColumns(int n) {
        this.setMinCols(n);
        this.setMaxCols(n);
    }

    public void setErrorCorrectionLevel(int n) {
        if (n < 0 || n > 8) {
            throw new IllegalArgumentException("Error correction level must be between 0 and 8!");
        }
        this.errorCorrectionLevel = n;
    }

    public void setMaxCols(int n) {
        this.checkValidColumnCount(n);
        this.maxCols = n;
    }

    public void setMaxRows(int n) {
        this.checkValidRowCount(n);
        this.maxRows = n;
    }

    public void setMinCols(int n) {
        this.checkValidColumnCount(n);
        this.minCols = n;
    }

    public void setMinRows(int n) {
        this.checkValidRowCount(n);
        this.minRows = n;
    }

    public void setRowHeight(double d) {
        this.setBarHeight(d);
    }

    public void setWidthToHeightRatio(double d) {
        this.widthToHeightRatio = d;
    }
}

