/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.int2of5;

import ai.org.krysalis.barcode4j.BarGroup;
import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.ClassicBarcodeLogicHandler;

public class Interleaved2Of5LogicImpl {
    private static final byte[][] CHARSET = new byte[][]{{1, 1, 2, 2, 1}, {2, 1, 1, 1, 2}, {1, 2, 1, 1, 2}, {2, 2, 1, 1, 1}, {1, 1, 2, 1, 2}, {2, 1, 2, 1, 1}, {1, 2, 2, 1, 1}, {1, 1, 1, 2, 2}, {2, 1, 1, 2, 1}, {1, 2, 1, 2, 1}};
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private boolean displayChecksum = false;

    public Interleaved2Of5LogicImpl(ChecksumMode checksumMode, boolean bl) {
        this.checksumMode = checksumMode;
        this.displayChecksum = bl;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public static char calcChecksum(String string, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < string.length(); ++n3) {
            if (n3 % 2 == 0) {
                n5 += Character.digit(string.charAt(n3), 10);
                continue;
            }
            n4 += Character.digit(string.charAt(n3), 10);
        }
        n3 = 10 - (n5 * n + n4 * n2) % 10;
        if (n3 >= 10) {
            n3 = 0;
        }
        return Character.forDigit(n3, 10);
    }

    public static char calcChecksum(String string) {
        return Interleaved2Of5LogicImpl.calcChecksum(string, 3, 1);
    }

    public static boolean validateChecksum(String string) {
        char c;
        char c2 = string.charAt(string.length() - 1);
        return c2 == (c = Interleaved2Of5LogicImpl.calcChecksum(string.substring(0, string.length() - 1)));
    }

    private int widthAt(char c, int n) {
        if (Character.isDigit(c)) {
            int n2 = Character.digit(c, 10);
            byte by = CHARSET[n2][n];
            return by;
        }
        throw new IllegalArgumentException("Invalid character '" + c + " (" + Character.getNumericValue(c) + ")'. Expected a digit.");
    }

    private void encodeGroup(ClassicBarcodeLogicHandler classicBarcodeLogicHandler, String string) {
        if (string.length() != 2) {
            throw new IllegalArgumentException("Parameter group must have two characters");
        }
        classicBarcodeLogicHandler.startBarGroup(BarGroup.MSG_CHARACTER, string);
        for (int i = 0; i < 5; ++i) {
            classicBarcodeLogicHandler.addBar(true, this.widthAt(string.charAt(0), i));
            classicBarcodeLogicHandler.addBar(false, this.widthAt(string.charAt(1), i));
        }
        classicBarcodeLogicHandler.endBarGroup();
    }

    protected String doHandleChecksum(StringBuffer stringBuffer, ChecksumMode checksumMode) {
        if (checksumMode == ChecksumMode.CP_ADD) {
            if (this.displayChecksum) {
                stringBuffer.append(Interleaved2Of5LogicImpl.calcChecksum(stringBuffer.toString()));
                return stringBuffer.toString();
            }
            String string = stringBuffer.toString();
            stringBuffer.append(Interleaved2Of5LogicImpl.calcChecksum(string));
            return string;
        }
        if (checksumMode == ChecksumMode.CP_CHECK) {
            if (!Interleaved2Of5LogicImpl.validateChecksum(stringBuffer.toString())) {
                throw new IllegalArgumentException("Message '" + stringBuffer.toString() + "' has a bad checksum. Expected: " + Interleaved2Of5LogicImpl.calcChecksum(stringBuffer.substring(0, stringBuffer.length() - 1)));
            }
            if (this.displayChecksum) {
                return stringBuffer.toString();
            }
            return stringBuffer.substring(0, stringBuffer.length() - 1);
        }
        if (checksumMode == ChecksumMode.CP_IGNORE) {
            return stringBuffer.toString();
        }
        throw new UnsupportedOperationException("Invalid checksum mode: " + this.getChecksumMode());
    }

    protected String handleChecksum(StringBuffer stringBuffer) {
        if (this.getChecksumMode() == ChecksumMode.CP_AUTO) {
            return this.doHandleChecksum(stringBuffer, ChecksumMode.CP_IGNORE);
        }
        return this.doHandleChecksum(stringBuffer, this.getChecksumMode());
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler classicBarcodeLogicHandler, String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = this.handleChecksum(stringBuffer);
        if (stringBuffer.length() % 2 != 0) {
            stringBuffer.insert(0, '0');
        }
        classicBarcodeLogicHandler.startBarcode(string, string2);
        classicBarcodeLogicHandler.startBarGroup(BarGroup.START_CHARACTER, null);
        classicBarcodeLogicHandler.addBar(true, 1);
        classicBarcodeLogicHandler.addBar(false, 1);
        classicBarcodeLogicHandler.addBar(true, 1);
        classicBarcodeLogicHandler.addBar(false, 1);
        classicBarcodeLogicHandler.endBarGroup();
        int n = 0;
        do {
            this.encodeGroup(classicBarcodeLogicHandler, stringBuffer.substring(n, n + 2));
        } while ((n += 2) < stringBuffer.length());
        classicBarcodeLogicHandler.startBarGroup(BarGroup.STOP_CHARACTER, null);
        classicBarcodeLogicHandler.addBar(true, 2);
        classicBarcodeLogicHandler.addBar(false, 1);
        classicBarcodeLogicHandler.addBar(true, 1);
        classicBarcodeLogicHandler.endBarGroup();
        classicBarcodeLogicHandler.endBarcode();
    }
}

