/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.int2of5;

import ai.org.krysalis.barcode4j.BarcodeDimension;
import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import ai.org.krysalis.barcode4j.impl.DefaultCanvasLogicHandler;
import ai.org.krysalis.barcode4j.impl.int2of5.Interleaved2Of5LogicImpl;
import ai.org.krysalis.barcode4j.output.Canvas;
import ai.org.krysalis.barcode4j.output.CanvasProvider;

public class Interleaved2Of5Bean
extends AbstractBarcodeBean {
    protected static final double DEFAULT_MODULE_WIDTH = (double)0.21f;
    public static final double DEFAULT_WIDE_FACTOR = 3.0;
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private double wideFactor = 3.0;
    private boolean displayChecksum = false;

    public Interleaved2Of5Bean() {
        this.moduleWidth = 0.21f;
        this.setQuietZone(10.0 * this.moduleWidth);
        this.setVerticalQuietZone(0.0);
    }

    public boolean isDisplayChecksum() {
        return this.displayChecksum;
    }

    public void setDisplayChecksum(boolean bl) {
        this.displayChecksum = bl;
    }

    public void generateBarcode(CanvasProvider canvasProvider, String string) {
        if (string == null || string.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultCanvasLogicHandler defaultCanvasLogicHandler = new DefaultCanvasLogicHandler(this, new Canvas(canvasProvider));
        Interleaved2Of5LogicImpl interleaved2Of5LogicImpl = new Interleaved2Of5LogicImpl(this.getChecksumMode(), this.isDisplayChecksum());
        interleaved2Of5LogicImpl.generateBarcodeLogic(defaultCanvasLogicHandler, string);
    }

    public BarcodeDimension calcDimensions(String string) {
        int n = string.length();
        if (this.getChecksumMode() == ChecksumMode.CP_ADD) {
            ++n;
        }
        if (n % 2 != 0) {
            ++n;
        }
        double d = 2.0 * this.wideFactor + 3.0;
        double d2 = ((double)n * d + 6.0 + this.wideFactor) * this.moduleWidth;
        double d3 = this.hasQuietZone() ? this.quietZone : 0.0;
        return new BarcodeDimension(d2, this.getHeight(), d2 + 2.0 * d3, this.getHeight(), this.quietZone, 0.0);
    }

    public double getBarWidth(int n) {
        if (n == 1) {
            return this.moduleWidth;
        }
        if (n == 2) {
            return this.moduleWidth * this.wideFactor;
        }
        throw new IllegalArgumentException("Only widths 1 and 2 allowed");
    }

    public void setChecksumMode(ChecksumMode checksumMode) {
        this.checksumMode = checksumMode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public double getWideFactor() {
        return this.wideFactor;
    }

    public void setWideFactor(double d) {
        if (d <= 1.0) {
            throw new IllegalArgumentException("wide factor must be > 1.0");
        }
        this.wideFactor = d;
    }
}

