/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.int2of5;

import ai.org.krysalis.barcode4j.HumanReadablePlacement;
import ai.org.krysalis.barcode4j.impl.DefaultCanvasLogicHandler;
import ai.org.krysalis.barcode4j.impl.int2of5.ITF14Bean;
import ai.org.krysalis.barcode4j.output.Canvas;

public class ITF14CanvasLogicHandler
extends DefaultCanvasLogicHandler {
    public ITF14CanvasLogicHandler(ITF14Bean iTF14Bean, Canvas canvas) {
        super(iTF14Bean, canvas);
    }

    private ITF14Bean getITF14Bean() {
        return (ITF14Bean)this.bcBean;
    }

    public void startBarcode(String string, String string2) {
        super.startBarcode(string, string2);
        ITF14Bean iTF14Bean = this.getITF14Bean();
        double d = iTF14Bean.getBearerBarWidth();
        double d2 = this.dimensions.getWidthPlusQuiet();
        double d3 = iTF14Bean.getBarHeight();
        double d4 = 0.0;
        if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
            d4 += this.bcBean.getHumanReadableHeight();
        }
        this.canvas.drawRect(0.0, d4, d2, d4 + d);
        this.canvas.drawRect(0.0, d4 + d + d3, d2, d4 + d + d3 + d);
        if (iTF14Bean.isBearerBox()) {
            this.canvas.drawRect(0.0, d4 + d, d, d4 + d + d3);
            this.canvas.drawRect(d2 - d, d4 + d, d2, d4 + d + d3);
        }
    }

    protected double getStartX() {
        ITF14Bean iTF14Bean = this.getITF14Bean();
        return super.getStartX() + (iTF14Bean.isBearerBox() ? iTF14Bean.getBearerBarWidth() : 0.0);
    }

    protected double getStartY() {
        double d = super.getStartY() + this.getITF14Bean().getBearerBarWidth();
        return d;
    }

    protected double getTextBaselinePosition() {
        if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
            double d = super.getTextBaselinePosition();
            return d += 2.0 * this.getITF14Bean().getBearerBarWidth();
        }
        return super.getTextBaselinePosition();
    }
}

