/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.int2of5;

import ai.org.krysalis.barcode4j.BarcodeDimension;
import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.impl.int2of5.ITF14CanvasLogicHandler;
import ai.org.krysalis.barcode4j.impl.int2of5.ITF14LogicImpl;
import ai.org.krysalis.barcode4j.impl.int2of5.Interleaved2Of5Bean;
import ai.org.krysalis.barcode4j.output.Canvas;
import ai.org.krysalis.barcode4j.output.CanvasProvider;

public class ITF14Bean
extends Interleaved2Of5Bean {
    static final double DEFAULT_MODULE_WIDTH = 1.016;
    static final double DEFAULT_WIDE_FACTORY = 2.5;
    static final double DEFAULT_BAR_HEIGHT = 32.0;
    static final double DEFAULT_BEARER_BAR_WIDTH = 4.8;
    static final boolean DEFAULT_BEARER_BOX = true;
    private double bearerBarWidth;
    private boolean bearerBox;

    public ITF14Bean() {
        this.setModuleWidth(1.016);
        this.setQuietZone(10.0 * this.moduleWidth);
        this.doQuietZone(true);
        this.setWideFactor(2.5);
        this.setBarHeight(32.0);
        this.setBearerBarWidth(4.8);
        this.setBearerBox(true);
        this.setFontSize(3.0 * this.getBarWidth(2));
        this.setDisplayChecksum(true);
    }

    public boolean isBearerBox() {
        return this.bearerBox;
    }

    public void setBearerBox(boolean bl) {
        this.bearerBox = bl;
    }

    public double getBearerBarWidth() {
        return this.bearerBarWidth;
    }

    public void setBearerBarWidth(double d) {
        this.bearerBarWidth = d;
    }

    public void doQuietZone(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException("Quiet zone may not be disabled for ITF-14!");
        }
        super.doQuietZone(bl);
    }

    protected void validate() {
        if (this.getQuietZone() < 10.0 * this.getModuleWidth()) {
            throw new IllegalStateException("Quiet zone must be at least 10 times the module width!");
        }
    }

    public void generateBarcode(CanvasProvider canvasProvider, String string) {
        if (string == null || string.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        this.validate();
        ITF14CanvasLogicHandler iTF14CanvasLogicHandler = new ITF14CanvasLogicHandler(this, new Canvas(canvasProvider));
        ITF14LogicImpl iTF14LogicImpl = new ITF14LogicImpl(this.getChecksumMode(), this.isDisplayChecksum());
        iTF14LogicImpl.generateBarcodeLogic(iTF14CanvasLogicHandler, string);
    }

    public BarcodeDimension calcDimensions(String string) {
        int n = string.length();
        if (this.getChecksumMode() == ChecksumMode.CP_ADD) {
            ++n;
        }
        if (n % 2 != 0) {
            ++n;
        }
        double d = 2.0 * this.getWideFactor() + 3.0;
        double d2 = ((double)n * d + 6.0 + this.getWideFactor()) * this.getModuleWidth();
        double d3 = this.getQuietZone();
        double d4 = this.isBearerBox() ? this.getBearerBarWidth() : 0.0;
        return new BarcodeDimension(d2, this.getHeight(), d2 + 2.0 * d3 + 2.0 * d4, this.getHeight() + 2.0 * this.getBearerBarWidth(), d4 + this.getQuietZone(), this.getBearerBarWidth());
    }
}

