/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.fourstate;

import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import ai.org.krysalis.barcode4j.impl.fourstate.AbstractFourStateLogicImpl;
import ai.org.krysalis.barcode4j.tools.IOUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.MissingResourceException;
import java.util.StringTokenizer;

public class USPSIntelligentMailLogicImpl
extends AbstractFourStateLogicImpl {
    static final char[] TABLE5OF13 = new char[1287];
    static final char[] TABLE2OF13 = new char[78];
    static final BarToCharacterMapping[] TABLE_BAR_TO_CHARACTER = new BarToCharacterMapping[65];
    private static final String BAR_TO_CHARACTER_TABLE_FILENAME = "usps-4bc-bar-to-character-table.csv";
    private static final int GENERATOR_POLYNOMIAL = 3893;
    private static final int ELEVEN_BITS = 2047;

    public USPSIntelligentMailLogicImpl() {
        super(ChecksumMode.CP_AUTO);
    }

    private static int reverseUnsignedShort(int n) {
        int n2 = 0;
        for (int i = 0; i < 16; ++i) {
            n2 <<= 1;
            n2 |= n & 1;
            n >>= 1;
        }
        return n2;
    }

    private static void initializeNof13Table(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = n2 - 1;
        for (int i = 0; i < 8192; ++i) {
            int n5;
            int n6 = 0;
            for (n5 = 0; n5 < 13; ++n5) {
                if ((i & 1 << n5) == 0) continue;
                ++n6;
            }
            if (n6 != n || (n5 = USPSIntelligentMailLogicImpl.reverseUnsignedShort(i) >> 3) < i) continue;
            if (i == n5) {
                cArray[n4] = (char)i;
                --n4;
                continue;
            }
            cArray[n3] = (char)i;
            cArray[++n3] = (char)n5;
            ++n3;
        }
        if (n3 != n4 + 1) {
            throw new IllegalStateException("lookup table indices didn't meet properly!");
        }
    }

    private static void initializeBarToCharacterTable() {
        InputStream inputStream = USPSIntelligentMailLogicImpl.class.getResourceAsStream(BAR_TO_CHARACTER_TABLE_FILENAME);
        if (inputStream == null) {
            throw new MissingResourceException("Resource usps-4bc-bar-to-character-table.csv not found!", null, null);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string;
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                USPSIntelligentMailLogicImpl.TABLE_BAR_TO_CHARACTER[n] = new BarToCharacterMapping(n, string);
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not initialize constant due to I/O error: " + iOException.getMessage());
        }
        finally {
            IOUtil.closeQuietly(bufferedReader);
            IOUtil.closeQuietly(inputStream);
        }
    }

    public char calcChecksum(String string) {
        return '\u0000';
    }

    static BigInteger convertToBinary(String string) {
        BigInteger bigInteger;
        if (string.length() < 20) {
            throw new IllegalArgumentException("Message is too short. It must have at least 20 digits");
        }
        if (string.length() > 31) {
            throw new IllegalArgumentException("Message must not be longer than 31 digits");
        }
        String string2 = string.substring(20);
        int n = string2.length();
        switch (n) {
            case 0: {
                bigInteger = BigInteger.ZERO;
                break;
            }
            case 5: {
                bigInteger = new BigInteger(string2);
                bigInteger = bigInteger.add(BigInteger.ONE);
                break;
            }
            case 9: {
                bigInteger = new BigInteger(string2);
                bigInteger = bigInteger.add(BigInteger.valueOf(100001L));
                break;
            }
            case 11: {
                bigInteger = new BigInteger(string2);
                bigInteger = bigInteger.add(BigInteger.valueOf(1000100001L));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid length for the routing code. Expected 0, 5, 9 or 11 but got " + n);
            }
        }
        BigInteger bigInteger2 = bigInteger;
        BigInteger bigInteger3 = BigInteger.valueOf(5L);
        BigInteger bigInteger4 = BigInteger.valueOf(10L);
        String string3 = string.substring(0, 20);
        bigInteger2 = bigInteger2.multiply(bigInteger4);
        bigInteger2 = bigInteger2.add(new BigInteger(string3.substring(0, 1)));
        bigInteger2 = bigInteger2.multiply(bigInteger3);
        bigInteger2 = bigInteger2.add(new BigInteger(string3.substring(1, 2)));
        for (int i = 2; i < 20; ++i) {
            bigInteger2 = bigInteger2.multiply(bigInteger4);
            bigInteger2 = bigInteger2.add(new BigInteger(string3.substring(i, i + 1)));
        }
        return bigInteger2;
    }

    static byte[] to13ByteArray(BigInteger bigInteger) {
        byte[] byArray = new byte[13];
        byte[] byArray2 = bigInteger.toByteArray();
        System.arraycopy(byArray2, 0, byArray, 13 - byArray2.length, byArray2.length);
        return byArray;
    }

    static int calcFCS(byte[] byArray) {
        int n = 2047;
        for (int i = 0; i < 13; ++i) {
            int n2;
            int n3;
            if (i == 0) {
                n3 = 2;
                n2 = byArray[0] << 5;
            } else {
                n3 = 0;
                n2 = byArray[i] << 3;
            }
            for (int j = n3; j < 8; ++j) {
                n = ((n ^ n2) & 0x400) != 0 ? n << 1 ^ 0xF35 : (n <<= 1);
                n &= 0x7FF;
                n2 <<= 1;
            }
        }
        return n;
    }

    static int[] convertToCodewords(BigInteger bigInteger) {
        int[] nArray = new int[10];
        BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(BigInteger.valueOf(636L));
        nArray[9] = bigIntegerArray[1].intValue();
        bigInteger = bigIntegerArray[0];
        BigInteger bigInteger2 = BigInteger.valueOf(1365L);
        for (int i = 8; i >= 1; --i) {
            bigIntegerArray = bigInteger.divideAndRemainder(bigInteger2);
            nArray[i] = bigIntegerArray[1].intValue();
            bigInteger = bigIntegerArray[0];
        }
        nArray[0] = bigInteger.intValue();
        return nArray;
    }

    static int[] modifyCodewords(int[] nArray, int n) {
        int[] nArray2 = new int[10];
        nArray2[9] = nArray[9] * 2;
        System.arraycopy(nArray, 1, nArray2, 1, 8);
        nArray2[0] = (n & 0x400) != 0 ? nArray[0] + 659 : nArray[0];
        return nArray2;
    }

    static char[] convertToCharacters(int[] nArray, int n) {
        int n2 = nArray.length;
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            cArray[i] = n3 < TABLE5OF13.length ? TABLE5OF13[n3] : TABLE2OF13[n3 - TABLE5OF13.length];
            if ((n & 1 << i) == 0) continue;
            cArray[i] = (char)(~cArray[i] & 0x1FFF);
        }
        return cArray;
    }

    static String convertToBars(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer(65);
        stringBuffer.setLength(65);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            BarToCharacterMapping barToCharacterMapping = TABLE_BAR_TO_CHARACTER[i];
            int n = 0;
            char c = cArray[barToCharacterMapping.ascChar];
            if ((c & barToCharacterMapping.ascBitMap) != 0) {
                n |= 1;
            }
            if (((c = cArray[barToCharacterMapping.descChar]) & barToCharacterMapping.descBitMap) != 0) {
                n |= 2;
            }
            stringBuffer.setCharAt(i, (char)(n + 48));
        }
        return stringBuffer.toString();
    }

    protected String[] encodeHighLevel(String string) {
        BigInteger bigInteger = USPSIntelligentMailLogicImpl.convertToBinary(string);
        int n = USPSIntelligentMailLogicImpl.calcFCS(USPSIntelligentMailLogicImpl.to13ByteArray(bigInteger));
        int[] nArray = USPSIntelligentMailLogicImpl.convertToCodewords(bigInteger);
        int[] nArray2 = USPSIntelligentMailLogicImpl.modifyCodewords(nArray, n);
        char[] cArray = USPSIntelligentMailLogicImpl.convertToCharacters(nArray2, n);
        String string2 = USPSIntelligentMailLogicImpl.convertToBars(cArray);
        return new String[]{string2};
    }

    protected String normalizeMessage(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isDigit(c)) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler classicBarcodeLogicHandler, String string) {
        String string2 = this.normalizeMessage(string);
        String[] stringArray = this.encodeHighLevel(string2);
        classicBarcodeLogicHandler.startBarcode(string, string2);
        String string3 = stringArray[0];
        int n = string3.length();
        for (int i = 0; i < n; ++i) {
            int n2 = Integer.parseInt(string3.substring(i, i + 1));
            classicBarcodeLogicHandler.addBar(true, n2);
        }
        classicBarcodeLogicHandler.endBarcode();
    }

    static {
        USPSIntelligentMailLogicImpl.initializeNof13Table(TABLE5OF13, 5, TABLE5OF13.length);
        USPSIntelligentMailLogicImpl.initializeNof13Table(TABLE2OF13, 2, TABLE2OF13.length);
        USPSIntelligentMailLogicImpl.initializeBarToCharacterTable();
    }

    private static final class BarToCharacterMapping {
        private int descChar;
        private int descBitMap;
        private int ascChar;
        private int ascBitMap;

        private BarToCharacterMapping(int n, String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            if (Integer.parseInt(stringTokenizer.nextToken()) != n + 1) {
                throw new IllegalStateException("Encountered the wrong line number");
            }
            this.descChar = stringTokenizer.nextToken().charAt(0) - 65;
            this.descBitMap = 1 << Integer.parseInt(stringTokenizer.nextToken());
            this.ascChar = stringTokenizer.nextToken().charAt(0) - 65;
            this.ascBitMap = 1 << Integer.parseInt(stringTokenizer.nextToken());
        }
    }
}

