/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.fourstate;

import ai.org.krysalis.barcode4j.BarGroup;
import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.ClassicBarcodeLogicHandler;

public abstract class AbstractFourStateLogicImpl {
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;

    public AbstractFourStateLogicImpl(ChecksumMode checksumMode) {
        this.checksumMode = checksumMode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public abstract char calcChecksum(String var1);

    public boolean validateChecksum(String string) {
        char c;
        char c2 = string.charAt(string.length() - 1);
        return c2 == (c = this.calcChecksum(string.substring(0, string.length() - 1)));
    }

    public static boolean isIgnoredChar(char c) {
        return false;
    }

    protected abstract String normalizeMessage(String var1);

    protected abstract String[] encodeHighLevel(String var1);

    protected void encodeCodeword(ClassicBarcodeLogicHandler classicBarcodeLogicHandler, char c, String string) {
        classicBarcodeLogicHandler.startBarGroup(BarGroup.MSG_CHARACTER, new Character(c).toString());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            int n2 = Integer.parseInt(string.substring(i, i + 1));
            classicBarcodeLogicHandler.addBar(true, n2);
        }
        classicBarcodeLogicHandler.endBarGroup();
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler classicBarcodeLogicHandler, String string) {
        String string2 = this.normalizeMessage(string);
        String[] stringArray = this.encodeHighLevel(string2);
        classicBarcodeLogicHandler.startBarcode(string, string2);
        for (int i = 0; i < stringArray.length; ++i) {
            char c = string2.charAt(i);
            this.encodeCodeword(classicBarcodeLogicHandler, c, stringArray[i]);
        }
        classicBarcodeLogicHandler.endBarcode();
    }
}

