/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.fourstate;

import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.HumanReadablePlacement;
import ai.org.krysalis.barcode4j.impl.HeightVariableBarcodeBean;

public abstract class AbstractFourStateBean
extends HeightVariableBarcodeBean {
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private double intercharGapWidth;
    private double trackHeight;
    private double ascenderHeight;

    public AbstractFourStateBean() {
        this.msgPos = HumanReadablePlacement.HRP_NONE;
    }

    public void setChecksumMode(ChecksumMode checksumMode) {
        this.checksumMode = checksumMode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public double getVerticalQuietZone() {
        return this.getQuietZone();
    }

    public double getIntercharGapWidth() {
        return this.intercharGapWidth;
    }

    public void setIntercharGapWidth(double d) {
        this.intercharGapWidth = d;
    }

    public double getTrackHeight() {
        return this.trackHeight;
    }

    public void setTrackHeight(double d) {
        this.trackHeight = d;
        this.updateHeight();
    }

    public double getAscenderHeight() {
        return this.ascenderHeight;
    }

    public void setAscenderHeight(double d) {
        this.ascenderHeight = d;
        this.updateHeight();
    }

    protected void updateHeight() {
        this.setBarHeight(this.getTrackHeight() + 2.0 * this.getAscenderHeight());
    }

    public double getBarWidth(int n) {
        if (n == 1) {
            return this.moduleWidth;
        }
        if (n == -1) {
            return this.intercharGapWidth;
        }
        throw new IllegalArgumentException("Only width 1 allowed");
    }

    public double getBarHeight(int n) {
        switch (n) {
            case 0: {
                return this.trackHeight;
            }
            case 1: {
                return this.trackHeight + this.ascenderHeight;
            }
            case 2: {
                return this.trackHeight + this.ascenderHeight;
            }
            case 3: {
                return this.trackHeight + 2.0 * this.ascenderHeight;
            }
        }
        throw new IllegalArgumentException("Only height 0-3 allowed");
    }
}

