/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.datamatrix;

import ai.org.krysalis.barcode4j.BarcodeDimension;
import ai.org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import ai.org.krysalis.barcode4j.impl.DefaultTwoDimCanvasLogicHandler;
import ai.org.krysalis.barcode4j.impl.datamatrix.DataMatrixHighLevelEncoder;
import ai.org.krysalis.barcode4j.impl.datamatrix.DataMatrixLogicImpl;
import ai.org.krysalis.barcode4j.impl.datamatrix.DataMatrixSymbolInfo;
import ai.org.krysalis.barcode4j.impl.datamatrix.SymbolShapeHint;
import ai.org.krysalis.barcode4j.output.Canvas;
import ai.org.krysalis.barcode4j.output.CanvasProvider;
import ai.org.krysalis.barcode4j.tools.UnitConv;
import java.awt.Dimension;
import java.io.IOException;

public class DataMatrixBean
extends AbstractBarcodeBean {
    protected static final double DEFAULT_MODULE_WIDTH = UnitConv.in2mm(0.013888888888888888);
    private SymbolShapeHint shape;
    private Dimension minSize;
    private Dimension maxSize;

    public DataMatrixBean() {
        this.height = 0.0;
        this.moduleWidth = DEFAULT_MODULE_WIDTH;
        this.setQuietZone(1.0 * this.moduleWidth);
        this.shape = SymbolShapeHint.FORCE_NONE;
    }

    public void setShape(SymbolShapeHint symbolShapeHint) {
        this.shape = symbolShapeHint;
    }

    public SymbolShapeHint getShape() {
        return this.shape;
    }

    public void setMinSize(Dimension dimension) {
        this.minSize = new Dimension(dimension);
    }

    public Dimension getMinSize() {
        if (this.minSize != null) {
            return new Dimension(this.minSize);
        }
        return null;
    }

    public void setMaxSize(Dimension dimension) {
        this.maxSize = new Dimension(dimension);
    }

    public Dimension getMaxSize() {
        if (this.maxSize != null) {
            return new Dimension(this.maxSize);
        }
        return null;
    }

    public void generateBarcode(CanvasProvider canvasProvider, String string) {
        if (string == null || string.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultTwoDimCanvasLogicHandler defaultTwoDimCanvasLogicHandler = new DefaultTwoDimCanvasLogicHandler(this, new Canvas(canvasProvider));
        DataMatrixLogicImpl dataMatrixLogicImpl = new DataMatrixLogicImpl();
        dataMatrixLogicImpl.generateBarcodeLogic(defaultTwoDimCanvasLogicHandler, string, this.getShape(), this.getMinSize(), this.getMaxSize());
    }

    public BarcodeDimension calcDimensions(String string) {
        String string2;
        try {
            string2 = DataMatrixHighLevelEncoder.encodeHighLevel(string, this.shape, this.getMinSize(), this.getMaxSize());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot fetch data: " + iOException.getLocalizedMessage());
        }
        DataMatrixSymbolInfo dataMatrixSymbolInfo = DataMatrixSymbolInfo.lookup(string2.length(), this.shape);
        double d = (double)dataMatrixSymbolInfo.getSymbolWidth() * this.getModuleWidth();
        double d2 = (double)dataMatrixSymbolInfo.getSymbolHeight() * this.getBarHeight();
        double d3 = this.hasQuietZone() ? this.getQuietZone() : 0.0;
        double d4 = this.hasQuietZone() ? this.getVerticalQuietZone() : 0.0;
        return new BarcodeDimension(d, d2, d + 2.0 * d3, d2 + 2.0 * d4, d3, d4);
    }

    public double getVerticalQuietZone() {
        return this.getQuietZone();
    }

    public double getBarWidth(int n) {
        return this.moduleWidth;
    }

    public double getBarHeight() {
        return this.moduleWidth;
    }
}

