/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.code39;

import ai.org.krysalis.barcode4j.BarGroup;
import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.ClassicBarcodeLogicHandler;

public class Code39LogicImpl {
    private static final char[] CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '-', '.', ' ', '$', '/', '+', '%', '*'};
    private static final char STARTSTOP = '*';
    private static final byte[][] CHARSET = new byte[][]{{0, 0, 0, 1, 1, 0, 1, 0, 0}, {1, 0, 0, 1, 0, 0, 0, 0, 1}, {0, 0, 1, 1, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 0, 1}, {1, 0, 0, 1, 1, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 1, 0, 1}, {1, 0, 0, 1, 0, 0, 1, 0, 0}, {0, 0, 1, 1, 0, 0, 1, 0, 0}, {1, 0, 0, 0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 1, 0, 0, 1}, {1, 0, 1, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 1, 0, 0, 1}, {1, 0, 0, 0, 1, 1, 0, 0, 0}, {0, 0, 1, 0, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 0, 1}, {1, 0, 0, 0, 0, 1, 1, 0, 0}, {0, 0, 1, 0, 0, 1, 1, 0, 0}, {0, 0, 0, 0, 1, 1, 1, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 1, 1}, {0, 0, 1, 0, 0, 0, 0, 1, 1}, {1, 0, 1, 0, 0, 0, 0, 1, 0}, {0, 0, 0, 0, 1, 0, 0, 1, 1}, {1, 0, 0, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 0, 1, 0, 0, 1, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 1}, {1, 0, 0, 0, 0, 0, 1, 1, 0}, {0, 0, 1, 0, 0, 0, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 1, 1, 0}, {1, 1, 0, 0, 0, 0, 0, 0, 1}, {0, 1, 1, 0, 0, 0, 0, 0, 1}, {1, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 1, 0, 0, 0, 1}, {1, 1, 0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 0, 1, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0, 1, 0, 1}, {1, 1, 0, 0, 0, 0, 1, 0, 0}, {0, 1, 1, 0, 0, 0, 1, 0, 0}, {0, 1, 0, 1, 0, 1, 0, 0, 0}, {0, 1, 0, 1, 0, 0, 0, 1, 0}, {0, 1, 0, 0, 0, 1, 0, 1, 0}, {0, 0, 0, 1, 0, 1, 0, 1, 0}, {0, 1, 0, 0, 1, 0, 1, 0, 0}};
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private boolean displayStartStop = false;
    private boolean displayChecksum = false;
    private boolean extendedCharSet = false;

    public Code39LogicImpl(ChecksumMode checksumMode, boolean bl, boolean bl2, boolean bl3) {
        this.checksumMode = checksumMode;
        this.displayStartStop = bl;
        this.displayChecksum = bl2;
        this.extendedCharSet = bl3;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    private static void invalidCharacter(char c) {
        if (c != '*') {
            throw new IllegalArgumentException("Invalid character: " + c);
        }
        throw new IllegalArgumentException("You may not include '*' as part of the message. This start/stop character is automatically added before and after the message.");
    }

    StringBuffer prepareMessage(String string) {
        if (this.extendedCharSet) {
            return Code39LogicImpl.escapeExtended(string, null);
        }
        if (string.startsWith("*") && string.endsWith("*")) {
            return new StringBuffer(string.substring(1, string.length() - 1));
        }
        return new StringBuffer(string);
    }

    public static StringBuffer escapeExtended(String string, StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer(string.length());
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\u0000') {
                stringBuffer.append("%U");
                continue;
            }
            if (c >= '\u0001' && c <= '\u001a') {
                stringBuffer.append('$').append((char)(65 + c - 1));
                continue;
            }
            if (c >= '\u001b' && c <= '\u001f') {
                stringBuffer.append('%').append((char)(65 + c - 27));
                continue;
            }
            if (c == ' ') {
                stringBuffer.append(c);
                continue;
            }
            if (c >= '!' && c <= '/') {
                stringBuffer.append('/').append((char)(65 + c - 33));
                continue;
            }
            if (c >= '0' && c <= '9') {
                stringBuffer.append(c);
                continue;
            }
            if (c == ':') {
                stringBuffer.append("/Z");
                continue;
            }
            if (c >= ';' && c <= '?') {
                stringBuffer.append('%').append((char)(70 + c - 59));
                continue;
            }
            if (c == '@') {
                stringBuffer.append("%V");
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                stringBuffer.append(c);
                continue;
            }
            if (c >= '[' && c <= '_') {
                stringBuffer.append('%').append((char)(75 + c - 91));
                continue;
            }
            if (c == '`') {
                stringBuffer.append("%W");
                continue;
            }
            if (c >= 'a' && c <= 'z') {
                stringBuffer.append('+').append((char)(65 + c - 97));
                continue;
            }
            if (c >= '{' && c <= '\u007f') {
                stringBuffer.append('%').append((char)(80 + c - 123));
                continue;
            }
            throw new IllegalArgumentException("Character 0x" + Integer.toHexString(c) + " is not supported by Extended Code 39!");
        }
        return stringBuffer;
    }

    public static char calcChecksum(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            int n2 = Code39LogicImpl.getCharIndex(string.charAt(i));
            if (n2 >= 0) {
                n += n2;
                continue;
            }
            Code39LogicImpl.invalidCharacter(string.charAt(i));
        }
        return CHARACTERS[n % 43];
    }

    public static boolean validateChecksum(String string) {
        char c;
        char c2 = string.charAt(string.length() - 1);
        return c2 == (c = Code39LogicImpl.calcChecksum(string.substring(0, string.length() - 1)));
    }

    private static int getCharIndex(char c) {
        char c2 = c >= 'a' && c <= 'z' ? Character.toUpperCase(c) : c;
        for (int i = 0; i < CHARACTERS.length; ++i) {
            if (c2 != CHARACTERS[i]) continue;
            return i;
        }
        return -1;
    }

    private static boolean isValidChar(char c) {
        if (c == '*') {
            return false;
        }
        return Code39LogicImpl.getCharIndex(c) >= 0;
    }

    private int widthAt(char c, int n) {
        int n2 = Code39LogicImpl.getCharIndex(c);
        if (n2 >= 0) {
            byte by = CHARSET[n2][n];
            return by + 1;
        }
        Code39LogicImpl.invalidCharacter(c);
        return 0;
    }

    protected void encodeChar(ClassicBarcodeLogicHandler classicBarcodeLogicHandler, char c) {
        classicBarcodeLogicHandler.startBarGroup(BarGroup.MSG_CHARACTER, new Character(c).toString());
        for (int n = 0; n < 9; n = (int)((byte)(n + 1))) {
            int n2 = this.widthAt(c, n);
            boolean bl = n % 2 == 0;
            classicBarcodeLogicHandler.addBar(bl, n2);
        }
        classicBarcodeLogicHandler.endBarGroup();
    }

    private void addIntercharacterGap(ClassicBarcodeLogicHandler classicBarcodeLogicHandler) {
        classicBarcodeLogicHandler.addBar(false, -1);
    }

    private String handleChecksum(StringBuffer stringBuffer) {
        if (this.getChecksumMode() == ChecksumMode.CP_ADD) {
            if (this.displayChecksum) {
                stringBuffer.append(Code39LogicImpl.calcChecksum(stringBuffer.toString()));
                return stringBuffer.toString();
            }
            String string = stringBuffer.toString();
            stringBuffer.append(Code39LogicImpl.calcChecksum(string));
            return string;
        }
        if (this.getChecksumMode() == ChecksumMode.CP_CHECK) {
            if (!Code39LogicImpl.validateChecksum(stringBuffer.toString())) {
                throw new IllegalArgumentException("Message '" + stringBuffer.toString() + "' has a bad checksum. Expected: " + Code39LogicImpl.calcChecksum(stringBuffer.toString()));
            }
            if (this.displayChecksum) {
                return stringBuffer.toString();
            }
            return stringBuffer.substring(0, stringBuffer.length() - 1);
        }
        if (this.getChecksumMode() == ChecksumMode.CP_IGNORE) {
            return stringBuffer.toString();
        }
        if (this.getChecksumMode() == ChecksumMode.CP_AUTO) {
            return stringBuffer.toString();
        }
        throw new IllegalStateException("Unknown checksum mode");
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler classicBarcodeLogicHandler, String string) {
        String string2;
        StringBuffer stringBuffer = this.prepareMessage(string);
        String string3 = this.handleChecksum(stringBuffer);
        if (this.extendedCharSet) {
            string2 = string;
        } else {
            string2 = string3;
            if (this.displayStartStop) {
                string2 = '*' + string2 + '*';
            }
        }
        classicBarcodeLogicHandler.startBarcode(stringBuffer.toString(), string2);
        classicBarcodeLogicHandler.startBarGroup(BarGroup.START_CHARACTER, new Character('*').toString());
        this.encodeChar(classicBarcodeLogicHandler, '*');
        classicBarcodeLogicHandler.endBarGroup();
        for (int i = 0; i < stringBuffer.length(); ++i) {
            this.addIntercharacterGap(classicBarcodeLogicHandler);
            char c = stringBuffer.charAt(i);
            if (!Code39LogicImpl.isValidChar(c)) {
                throw new IllegalArgumentException("Invalid character: " + c);
            }
            this.encodeChar(classicBarcodeLogicHandler, c);
        }
        this.addIntercharacterGap(classicBarcodeLogicHandler);
        classicBarcodeLogicHandler.startBarGroup(BarGroup.STOP_CHARACTER, new Character('*').toString());
        this.encodeChar(classicBarcodeLogicHandler, '*');
        classicBarcodeLogicHandler.endBarGroup();
        classicBarcodeLogicHandler.endBarcode();
    }
}

