/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.code128;

import ai.org.krysalis.barcode4j.BarcodeDimension;
import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.impl.DefaultCanvasLogicHandler;
import ai.org.krysalis.barcode4j.impl.code128.Code128Bean;
import ai.org.krysalis.barcode4j.impl.code128.EAN128LogicImpl;
import ai.org.krysalis.barcode4j.output.Canvas;
import ai.org.krysalis.barcode4j.output.CanvasProvider;

public class EAN128Bean
extends Code128Bean {
    public static final char DEFAULT_GROUP_SEPARATOR = '\u001d';
    public static final char DEFAULT_CHECK_DIGIT_MARKER = '\u00f0';
    private EAN128LogicImpl impl;
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private String template = null;
    private char groupSeparator = (char)29;
    private char checkDigitMarker = (char)240;
    private boolean omitBrackets = false;

    public EAN128Bean() {
        this.impl = new EAN128LogicImpl(this.checksumMode, this.template, this.groupSeparator);
    }

    public BarcodeDimension calcDimensions(String string) {
        int n = this.impl.getEncodedMessage(string).length + 1;
        double d = (double)(n * 11 + 13) * this.getModuleWidth();
        double d2 = this.hasQuietZone() ? this.quietZone : 0.0;
        return new BarcodeDimension(d, this.getHeight(), d + 2.0 * d2, this.getHeight(), this.quietZone, 0.0);
    }

    public void generateBarcode(CanvasProvider canvasProvider, String string) {
        if (string == null || string.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultCanvasLogicHandler defaultCanvasLogicHandler = new DefaultCanvasLogicHandler(this, new Canvas(canvasProvider));
        this.impl.generateBarcodeLogic(defaultCanvasLogicHandler, string);
    }

    public void setChecksumMode(ChecksumMode checksumMode) {
        this.checksumMode = checksumMode;
        this.impl.setChecksumMode(checksumMode);
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public char getGroupSeparator() {
        return this.groupSeparator;
    }

    public void setGroupSeparator(char c) {
        this.groupSeparator = c;
        this.impl.setGroupSeparator(c);
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String string) {
        this.template = string;
        this.impl.setTemplate(string);
    }

    public char getCheckDigitMarker() {
        return this.checkDigitMarker;
    }

    public void setCheckDigitMarker(char c) {
        this.checkDigitMarker = c;
        this.impl.setCheckDigitMarker(c);
    }

    public boolean isOmitBrackets() {
        return this.omitBrackets;
    }

    public void setOmitBrackets(boolean bl) {
        this.omitBrackets = bl;
        this.impl.setOmitBrackets(bl);
    }
}

