/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.code128;

import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.impl.code128.Code128;
import ai.org.krysalis.barcode4j.impl.code128.EAN128Bean;
import ai.org.krysalis.barcode4j.tools.Length;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class EAN128
extends Code128
implements Configurable {
    public EAN128() {
        this.bean = new EAN128Bean();
    }

    public EAN128Bean getEAN128Bean() {
        return (EAN128Bean)this.getBean();
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Length length = new Length(configuration.getChild("module-width").getValue("0.21mm"), "mm");
        this.getEAN128Bean().setModuleWidth(length.getValueAsMillimeter());
        super.configure(configuration);
        this.getEAN128Bean().setChecksumMode(ChecksumMode.byName(configuration.getChild("checksum").getValue(ChecksumMode.CP_AUTO.getName())));
        this.getEAN128Bean().setCheckDigitMarker(this.getFirstChar(configuration.getChild("check-digit-marker").getValue("\u00f0")));
        this.getEAN128Bean().setTemplate(configuration.getChild("template").getValue(""));
        this.getEAN128Bean().setGroupSeparator(this.getFirstChar(configuration.getChild("group-separator").getValue("\u00f1")));
        Configuration configuration2 = configuration.getChild("human-readable", false);
        if (configuration2 != null) {
            this.getEAN128Bean().setOmitBrackets(configuration2.getChild("omit-brackets").getValueAsBoolean(false));
        }
    }

    private char getFirstChar(String string) {
        if (string != null && string.length() > 0) {
            return string.charAt(0);
        }
        throw new IllegalArgumentException("Value must have at least one character");
    }
}

