/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.code128;

import ai.org.krysalis.barcode4j.impl.code128.Code128Constants;
import ai.org.krysalis.barcode4j.impl.code128.Code128Encoder;

public class DefaultCode128Encoder
implements Code128Encoder,
Code128Constants {
    private static final int START_A = 103;
    private static final int START_B = 104;
    private static final int START_C = 105;
    private static final int GOTO_A = 101;
    private static final int GOTO_B = 100;
    private static final int GOTO_C = 99;
    private static final int FNC_1 = 102;
    private static final int FNC_2 = 97;
    private static final int FNC_3 = 96;
    private static final int FNC_4 = 244;
    private static final int SHIFT = 98;
    private int codesets;

    public DefaultCode128Encoder(int n) {
        this.codesets = n;
    }

    public DefaultCode128Encoder() {
        this(7);
    }

    private boolean needA(char c) {
        return c < ' ';
    }

    private boolean needB(char c) {
        return c >= '`' && c < '\u0080';
    }

    private int encodeAorB(char c, int n) {
        if (c == '\u00f1') {
            return 102;
        }
        if (c == '\u00f2') {
            return 97;
        }
        if (c == '\u00f3') {
            return 96;
        }
        if (c == '\u00f4') {
            if (n == 1) {
                return 101;
            }
            return 100;
        }
        if (n == 1) {
            if (c >= '\u0000' && c < ' ') {
                return c + 64;
            }
            if (c >= ' ' && c <= '_') {
                return c - 32;
            }
            throw new IllegalArgumentException("Illegal character: " + c);
        }
        if (n == 2) {
            if (c >= ' ' && c < '\u0080') {
                return c - 32;
            }
            throw new IllegalArgumentException("Illegal character: " + c);
        }
        throw new IllegalArgumentException("Only A or B allowed");
    }

    private boolean isAllowed(int n) {
        return (this.codesets & n) != 0;
    }

    private boolean isAAllowed() {
        return this.isAllowed(1);
    }

    private boolean isBAllowed() {
        return this.isAllowed(2);
    }

    private boolean isCAllowed() {
        return this.isAllowed(4);
    }

    public int[] encode(String string) {
        int n;
        int[] nArray = new int[string.length() * 2];
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        for (int i = 0; i < n4; i += n + 1) {
            int n5;
            n = 0;
            int n6 = 0;
            boolean bl = false;
            while (this.isCAllowed() && i + n < n4) {
                n5 = string.charAt(i + n);
                if (n5 >= 48 && n5 <= 57) {
                    if (i + n + 1 == n4) {
                        bl = true;
                        break;
                    }
                    n5 = string.charAt(i + n + 1);
                    if (n5 < 48 || n5 > 57) break;
                    ++n6;
                    n += 2;
                    continue;
                }
                if (n5 != 241 || i != 0 && n <= 0) break;
                ++n;
            }
            if (n6 < 2 && n != n4) continue;
            if (bl && ((n5 = string.indexOf(241, i)) < 0 || n5 > i + n)) {
                ++i;
            }
            n2 += this.encodeAordB(string, n3, i, nArray, n2);
            n3 = i + n;
            n2 += this.encodeC(string, i, n3, nArray, n2);
        }
        n2 += this.encodeAordB(string, n3, n4, nArray, n2);
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
        return nArray2;
    }

    private int encodeC(String string, int n, int n2, int[] nArray, int n3) {
        if (n == n2) {
            return 0;
        }
        int n4 = n3;
        nArray[n4++] = n == 0 ? 105 : 99;
        int n5 = n;
        while (n5 < n2) {
            char c = string.charAt(n5);
            if (c == '\u00f1') {
                nArray[n4++] = 102;
                ++n5;
                continue;
            }
            nArray[n4++] = Character.digit(c, 10) * 10 + Character.digit(string.charAt(n5 + 1), 10);
            n5 += 2;
        }
        return n4 - n3;
    }

    private int encodeAordB(String string, int n, int n2, int[] nArray, int n3) {
        char c;
        int n4;
        if (n == n2) {
            return 0;
        }
        int n5 = n3;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.isBAllowed()) {
            bl3 = true;
            for (n4 = n; n4 < n2; ++n4) {
                c = string.charAt(n4);
                if (this.needA(c)) {
                    bl3 = false;
                } else {
                    if (!this.needB(c)) continue;
                    bl3 = true;
                }
                break;
            }
        } else if (!this.isAAllowed()) {
            if (n2 - n == 1) {
                throw new IllegalArgumentException("The message has an odd number of digits. The number of digits must be even for Codeset C.");
            }
            throw new IllegalArgumentException("Invalid characters found for Code 128 Codeset A or B which are disabled.");
        }
        if (bl3) {
            nArray[n5++] = n == 0 ? 104 : 100;
            bl2 = true;
        } else {
            nArray[n5++] = n == 0 ? 103 : 101;
            bl = true;
        }
        for (n4 = n; n4 < n2; ++n4) {
            c = string.charAt(n4);
            if (bl3) {
                if (this.needA(c)) {
                    if (n4 + 1 < n2 && this.needA(string.charAt(n4 + 1))) {
                        nArray[n5++] = 101;
                        bl3 = false;
                    } else {
                        nArray[n5++] = 98;
                    }
                    bl = true;
                    nArray[n5++] = this.encodeAorB(c, 1);
                    continue;
                }
                nArray[n5++] = this.encodeAorB(c, 2);
                continue;
            }
            if (this.needB(c)) {
                if (n4 + 1 < n2 && this.needB(string.charAt(n4 + 1))) {
                    nArray[n5++] = 100;
                    bl3 = true;
                } else {
                    nArray[n5++] = 98;
                }
                bl2 = true;
                nArray[n5++] = this.encodeAorB(c, 2);
                continue;
            }
            nArray[n5++] = this.encodeAorB(c, 1);
        }
        if (bl && !this.isAAllowed()) {
            throw new IllegalArgumentException("Invalid characters found for Code 128 Codeset A which is disabled.");
        }
        if (bl2 && !this.isBAllowed()) {
            throw new IllegalArgumentException("Invalid characters found for Code 128 Codeset B which is disabled.");
        }
        return n5 - n3;
    }
}

