/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.code128;

import ai.org.krysalis.barcode4j.BarGroup;
import ai.org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import ai.org.krysalis.barcode4j.impl.code128.Code128Encoder;
import ai.org.krysalis.barcode4j.impl.code128.DefaultCode128Encoder;
import ai.org.krysalis.barcode4j.tools.MessageUtil;

public class Code128LogicImpl {
    public static final char FNC_1 = '\u00f1';
    public static final char FNC_2 = '\u00f2';
    public static final char FNC_3 = '\u00f3';
    public static final char FNC_4 = '\u00f4';
    private static final byte[][] CHARSET = new byte[][]{{2, 1, 2, 2, 2, 2}, {2, 2, 2, 1, 2, 2}, {2, 2, 2, 2, 2, 1}, {1, 2, 1, 2, 2, 3}, {1, 2, 1, 3, 2, 2}, {1, 3, 1, 2, 2, 2}, {1, 2, 2, 2, 1, 3}, {1, 2, 2, 3, 1, 2}, {1, 3, 2, 2, 1, 2}, {2, 2, 1, 2, 1, 3}, {2, 2, 1, 3, 1, 2}, {2, 3, 1, 2, 1, 2}, {1, 1, 2, 2, 3, 2}, {1, 2, 2, 1, 3, 2}, {1, 2, 2, 2, 3, 1}, {1, 1, 3, 2, 2, 2}, {1, 2, 3, 1, 2, 2}, {1, 2, 3, 2, 2, 1}, {2, 2, 3, 2, 1, 1}, {2, 2, 1, 1, 3, 2}, {2, 2, 1, 2, 3, 1}, {2, 1, 3, 2, 1, 2}, {2, 2, 3, 1, 1, 2}, {3, 1, 2, 1, 3, 1}, {3, 1, 1, 2, 2, 2}, {3, 2, 1, 1, 2, 2}, {3, 2, 1, 2, 2, 1}, {3, 1, 2, 2, 1, 2}, {3, 2, 2, 1, 1, 2}, {3, 2, 2, 2, 1, 1}, {2, 1, 2, 1, 2, 3}, {2, 1, 2, 3, 2, 1}, {2, 3, 2, 1, 2, 1}, {1, 1, 1, 3, 2, 3}, {1, 3, 1, 1, 2, 3}, {1, 3, 1, 3, 2, 1}, {1, 1, 2, 3, 1, 3}, {1, 3, 2, 1, 1, 3}, {1, 3, 2, 3, 1, 1}, {2, 1, 1, 3, 1, 3}, {2, 3, 1, 1, 1, 3}, {2, 3, 1, 3, 1, 1}, {1, 1, 2, 1, 3, 3}, {1, 1, 2, 3, 3, 1}, {1, 3, 2, 1, 3, 1}, {1, 1, 3, 1, 2, 3}, {1, 1, 3, 3, 2, 1}, {1, 3, 3, 1, 2, 1}, {3, 1, 3, 1, 2, 1}, {2, 1, 1, 3, 3, 1}, {2, 3, 1, 1, 3, 1}, {2, 1, 3, 1, 1, 3}, {2, 1, 3, 3, 1, 1}, {2, 1, 3, 1, 3, 1}, {3, 1, 1, 1, 2, 3}, {3, 1, 1, 3, 2, 1}, {3, 3, 1, 1, 2, 1}, {3, 1, 2, 1, 1, 3}, {3, 1, 2, 3, 1, 1}, {3, 3, 2, 1, 1, 1}, {3, 1, 4, 1, 1, 1}, {2, 2, 1, 4, 1, 1}, {4, 3, 1, 1, 1, 1}, {1, 1, 1, 2, 2, 4}, {1, 1, 1, 4, 2, 2}, {1, 2, 1, 1, 2, 4}, {1, 2, 1, 4, 2, 1}, {1, 4, 1, 1, 2, 2}, {1, 4, 1, 2, 2, 1}, {1, 1, 2, 2, 1, 4}, {1, 1, 2, 4, 1, 2}, {1, 2, 2, 1, 1, 4}, {1, 2, 2, 4, 1, 1}, {1, 4, 2, 1, 1, 2}, {1, 4, 2, 2, 1, 1}, {2, 4, 1, 2, 1, 1}, {2, 2, 1, 1, 1, 4}, {4, 1, 3, 1, 1, 1}, {2, 4, 1, 1, 1, 2}, {1, 3, 4, 1, 1, 1}, {1, 1, 1, 2, 4, 2}, {1, 2, 1, 1, 4, 2}, {1, 2, 1, 2, 4, 1}, {1, 1, 4, 2, 1, 2}, {1, 2, 4, 1, 1, 2}, {1, 2, 4, 2, 1, 1}, {4, 1, 1, 2, 1, 2}, {4, 2, 1, 1, 1, 2}, {4, 2, 1, 2, 1, 1}, {2, 1, 2, 1, 4, 1}, {2, 1, 4, 1, 2, 1}, {4, 1, 2, 1, 2, 1}, {1, 1, 1, 1, 4, 3}, {1, 1, 1, 3, 4, 1}, {1, 3, 1, 1, 4, 1}, {1, 1, 4, 1, 1, 3}, {1, 1, 4, 3, 1, 1}, {4, 1, 1, 1, 1, 3}, {4, 1, 1, 3, 1, 1}, {1, 1, 3, 1, 4, 1}, {1, 1, 4, 1, 3, 1}, {3, 1, 1, 1, 4, 1}, {4, 1, 1, 1, 3, 1}, {2, 1, 1, 4, 1, 2}, {2, 1, 1, 2, 1, 4}, {2, 1, 1, 2, 3, 2}};
    private static final byte[] STOP = new byte[]{2, 3, 3, 1, 1, 1, 2};
    private int codeset;

    public Code128LogicImpl() {
        this(7);
    }

    public Code128LogicImpl(int n) {
        this.codeset = n;
    }

    public static boolean isValidChar(char c) {
        return c >= '\u0000' && c <= '\u007f' || c >= '\u00f1' && c <= '\u00f4';
    }

    public static boolean isInCodeSetA(char c) {
        return c >= '\u0000' && c <= '_' || c >= '\u00f1' && c <= '\u00f4';
    }

    public static boolean isInCodeSetB(char c) {
        return c >= ' ' && c <= '\u007f' || c >= '\u00f1' && c <= '\u00f4';
    }

    public static boolean canBeInCodeSetC(char c, boolean bl) {
        if (bl) {
            return c >= '0' && c <= '9';
        }
        return c >= '0' && c <= '9' || c == '\u00f1';
    }

    public static String symbolCharToString(int n) {
        switch (n) {
            case 96: {
                return "FNC3/96";
            }
            case 97: {
                return "FNC2/97";
            }
            case 98: {
                return "Shift/98";
            }
            case 99: {
                return "CodeC/99";
            }
            case 100: {
                return "CodeB/FNC4";
            }
            case 101: {
                return "CodeA/FNC4";
            }
            case 102: {
                return "FNC1";
            }
            case 103: {
                return "StartA";
            }
            case 104: {
                return "StartB";
            }
            case 105: {
                return "StartC";
            }
        }
        return "idx" + Integer.toString(n);
    }

    public static String toString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append(Code128LogicImpl.symbolCharToString(nArray[i]));
        }
        return stringBuffer.toString();
    }

    protected void encodeChar(ClassicBarcodeLogicHandler classicBarcodeLogicHandler, int n) {
        classicBarcodeLogicHandler.startBarGroup(BarGroup.MSG_CHARACTER, Code128LogicImpl.symbolCharToString(n));
        for (int n2 = 0; n2 < 6; n2 = (int)((byte)(n2 + 1))) {
            byte by = CHARSET[n][n2];
            boolean bl = n2 % 2 == 0;
            classicBarcodeLogicHandler.addBar(bl, by);
        }
        classicBarcodeLogicHandler.endBarGroup();
    }

    protected void encodeStop(ClassicBarcodeLogicHandler classicBarcodeLogicHandler) {
        classicBarcodeLogicHandler.startBarGroup(BarGroup.STOP_CHARACTER, null);
        for (int n = 0; n < 7; n = (int)((byte)(n + 1))) {
            byte by = STOP[n];
            boolean bl = n % 2 == 0;
            classicBarcodeLogicHandler.addBar(bl, by);
        }
        classicBarcodeLogicHandler.endBarGroup();
    }

    protected Code128Encoder getEncoder() {
        return new DefaultCode128Encoder(this.codeset);
    }

    int[] createEncodedMessage(String string) {
        return this.getEncoder().encode(string);
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler classicBarcodeLogicHandler, String string) {
        int n;
        classicBarcodeLogicHandler.startBarcode(string, MessageUtil.filterNonPrintableCharacters(string));
        int[] nArray = this.createEncodedMessage(string);
        for (n = 0; n < nArray.length; ++n) {
            this.encodeChar(classicBarcodeLogicHandler, nArray[n]);
        }
        n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            n += i * nArray[i];
        }
        this.encodeChar(classicBarcodeLogicHandler, n %= 103);
        this.encodeStop(classicBarcodeLogicHandler);
        classicBarcodeLogicHandler.endBarcode();
    }
}

