/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.codabar;

import ai.org.krysalis.barcode4j.BarGroup;
import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.ClassicBarcodeLogicHandler;

public class CodabarLogicImpl {
    private static final char[] CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'n', 't', '-', '$', ':', '/', '.', '+', '*'};
    static final byte[][] CHARSET = new byte[][]{{0, 0, 0, 0, 0, 1, 1}, {0, 0, 0, 0, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 1}, {1, 1, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 1, 0}, {0, 1, 0, 0, 0, 0, 1}, {0, 1, 0, 0, 1, 0, 0}, {0, 1, 1, 0, 0, 0, 0}, {1, 0, 0, 1, 0, 0, 0}, {0, 0, 1, 1, 0, 1, 0}, {0, 1, 0, 1, 0, 0, 1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 0, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 1, 0}, {0, 1, 0, 1, 0, 0, 1}, {0, 0, 1, 1, 0, 1, 0}, {0, 0, 0, 1, 1, 0, 0}, {0, 0, 1, 1, 0, 0, 0}, {1, 0, 0, 0, 1, 0, 1}, {1, 0, 1, 0, 0, 0, 1}, {1, 0, 1, 0, 1, 0, 0}, {0, 0, 1, 0, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 1}};
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private boolean displayStartStop = false;

    public CodabarLogicImpl(ChecksumMode checksumMode) {
        this.checksumMode = checksumMode;
    }

    public CodabarLogicImpl(ChecksumMode checksumMode, boolean bl) {
        this.checksumMode = checksumMode;
        this.displayStartStop = bl;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    protected static int getCharIndex(char c) {
        for (int i = 0; i < CHARACTERS.length; ++i) {
            if (c != CHARACTERS[i]) continue;
            return i;
        }
        return -1;
    }

    protected static boolean isValidChar(char c) {
        return CodabarLogicImpl.getCharIndex(Character.toLowerCase(c)) >= 0;
    }

    protected static boolean isStartStopChar(char c) {
        return (c = Character.toLowerCase(c)) == 'a' || c == 'b' || c == 'c' || c == 'd' || c == 'e' || c == '*' || c == 'n' || c == 't';
    }

    private int widthAt(char c, int n) throws IllegalArgumentException {
        int n2 = CodabarLogicImpl.getCharIndex(c = Character.toLowerCase(c));
        if (n2 >= 0) {
            byte by = CHARSET[n2][n];
            return by + 1;
        }
        throw new IllegalArgumentException("Invalid character: " + c);
    }

    protected void encodeChar(ClassicBarcodeLogicHandler classicBarcodeLogicHandler, char c) {
        c = Character.toLowerCase(c);
        classicBarcodeLogicHandler.startBarGroup(BarGroup.MSG_CHARACTER, new Character(c).toString());
        for (int n = 0; n < 7; n = (int)((byte)(n + 1))) {
            int n2 = this.widthAt(c, n);
            boolean bl = n % 2 == 0;
            classicBarcodeLogicHandler.addBar(bl, n2);
        }
        classicBarcodeLogicHandler.endBarGroup();
    }

    private void handleChecksum(StringBuffer stringBuffer) {
        if (this.getChecksumMode() == ChecksumMode.CP_ADD || this.getChecksumMode() == ChecksumMode.CP_CHECK) {
            throw new UnsupportedOperationException("No checksums are currently supported for Codabar symbols");
        }
        if (this.getChecksumMode() == ChecksumMode.CP_IGNORE) {
            return;
        }
        if (this.getChecksumMode() == ChecksumMode.CP_AUTO) {
            return;
        }
    }

    private StringBuffer prepareMessage(String string) {
        if (CodabarLogicImpl.isStartStopChar(string.charAt(0)) && CodabarLogicImpl.isStartStopChar(string.charAt(string.length() - 1))) {
            return new StringBuffer(string.substring(1, string.length() - 1));
        }
        return new StringBuffer(string);
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler classicBarcodeLogicHandler, String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        this.handleChecksum(stringBuffer);
        String string2 = stringBuffer.toString();
        String string3 = this.displayStartStop ? stringBuffer.toString() : this.prepareMessage(string).toString();
        classicBarcodeLogicHandler.startBarcode(string2, string3);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c;
            if (i > 0) {
                classicBarcodeLogicHandler.addBar(false, 1);
            }
            if (!CodabarLogicImpl.isValidChar(c = stringBuffer.charAt(i))) {
                throw new IllegalArgumentException("Invalid character: " + c);
            }
            this.encodeChar(classicBarcodeLogicHandler, c);
        }
        classicBarcodeLogicHandler.endBarcode();
    }
}

