/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl;

import ai.org.krysalis.barcode4j.BarGroup;
import ai.org.krysalis.barcode4j.BarcodeDimension;
import ai.org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import ai.org.krysalis.barcode4j.HumanReadablePlacement;
import ai.org.krysalis.barcode4j.TextAlignment;
import ai.org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import ai.org.krysalis.barcode4j.impl.DrawingUtil;
import ai.org.krysalis.barcode4j.output.Canvas;
import ai.org.krysalis.barcode4j.tools.MessagePatternUtil;

public class DefaultCanvasLogicHandler
implements ClassicBarcodeLogicHandler {
    protected AbstractBarcodeBean bcBean;
    protected Canvas canvas;
    protected BarcodeDimension dimensions;
    private double x = 0.0;
    private double y;
    private String formattedMsg;

    public DefaultCanvasLogicHandler(AbstractBarcodeBean abstractBarcodeBean, Canvas canvas) {
        this.bcBean = abstractBarcodeBean;
        this.canvas = canvas;
    }

    protected double getStartX() {
        if (this.bcBean.hasQuietZone()) {
            return this.bcBean.getQuietZone();
        }
        return 0.0;
    }

    protected double getStartY() {
        double d = 0.0;
        if (this.bcBean.hasQuietZone()) {
            d += this.bcBean.getVerticalQuietZone();
        }
        if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
            d += this.bcBean.getHumanReadableHeight();
        }
        return d;
    }

    public void startBarcode(String string, String string2) {
        this.formattedMsg = MessagePatternUtil.applyCustomMessagePattern(string2, this.bcBean.getPattern());
        this.dimensions = this.bcBean.calcDimensions(string);
        this.canvas.establishDimensions(this.dimensions);
        this.x = this.getStartX();
        this.y = this.getStartY();
    }

    public void startBarGroup(BarGroup barGroup, String string) {
    }

    public void addBar(boolean bl, int n) {
        double d = this.bcBean.getBarWidth(n);
        if (bl) {
            this.canvas.drawRectWH(this.x, this.y, d, this.bcBean.getBarHeight());
        }
        this.x += d;
    }

    public void endBarGroup() {
    }

    public void endBarcode() {
        if (this.bcBean.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            double d = this.getTextBaselinePosition();
            DrawingUtil.drawText(this.canvas, this.bcBean, this.formattedMsg, this.getStartX(), this.x, d, TextAlignment.TA_CENTER);
        }
    }

    protected double getTextBaselinePosition() {
        if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
            double d = this.bcBean.getHumanReadableHeight();
            if (this.bcBean.hasFontDescender()) {
                d -= this.bcBean.getHumanReadableHeight() / 13.0 * 3.0;
            }
            return d;
        }
        if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
            double d = this.bcBean.getHeight();
            if (this.bcBean.hasFontDescender()) {
                d -= this.bcBean.getHumanReadableHeight() / 13.0 * 3.0;
            }
            return d;
        }
        throw new IllegalStateException("not applicable");
    }
}

