/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl;

import ai.org.krysalis.barcode4j.BarGroup;
import ai.org.krysalis.barcode4j.BarcodeDimension;
import ai.org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import ai.org.krysalis.barcode4j.HumanReadablePlacement;
import ai.org.krysalis.barcode4j.TextAlignment;
import ai.org.krysalis.barcode4j.impl.DrawingUtil;
import ai.org.krysalis.barcode4j.impl.HeightVariableBarcodeBean;
import ai.org.krysalis.barcode4j.output.Canvas;
import ai.org.krysalis.barcode4j.tools.MessagePatternUtil;

public abstract class AbstractVariableHeightLogicHandler
implements ClassicBarcodeLogicHandler {
    protected HeightVariableBarcodeBean bcBean;
    protected Canvas canvas;
    protected double x = 0.0;
    protected double y = 0.0;
    private String formattedMsg;
    private TextAlignment textAlignment = TextAlignment.TA_CENTER;

    public AbstractVariableHeightLogicHandler(HeightVariableBarcodeBean heightVariableBarcodeBean, Canvas canvas) {
        this.bcBean = heightVariableBarcodeBean;
        this.canvas = canvas;
    }

    public void setTextAlignment(TextAlignment textAlignment) {
        if (textAlignment == null) {
            throw new NullPointerException("align must not be null");
        }
        this.textAlignment = textAlignment;
    }

    private double getStartX() {
        if (this.bcBean.hasQuietZone()) {
            return this.bcBean.getQuietZone();
        }
        return 0.0;
    }

    public void startBarcode(String string, String string2) {
        this.formattedMsg = MessagePatternUtil.applyCustomMessagePattern(string2, this.bcBean.getPattern());
        BarcodeDimension barcodeDimension = this.bcBean.calcDimensions(string);
        this.canvas.establishDimensions(barcodeDimension);
        this.x = this.getStartX();
    }

    protected double getTextY() {
        double d = 0.0;
        if (this.bcBean.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                d += this.bcBean.getHumanReadableHeight();
            } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                d += this.bcBean.getHeight();
                if (this.bcBean.hasQuietZone()) {
                    d += this.bcBean.getVerticalQuietZone();
                }
            }
        }
        return d;
    }

    public void endBarcode() {
        if (this.bcBean.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            double d = this.getTextY();
            DrawingUtil.drawText(this.canvas, this.bcBean, this.formattedMsg, this.getStartX(), this.x, d, this.textAlignment);
        }
    }

    public void startBarGroup(BarGroup barGroup, String string) {
    }

    public void endBarGroup() {
    }
}

