/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl;

import ai.org.krysalis.barcode4j.BarcodeDimension;
import ai.org.krysalis.barcode4j.BarcodeGenerator;
import ai.org.krysalis.barcode4j.HumanReadablePlacement;
import ai.org.krysalis.barcode4j.output.CanvasProvider;
import ai.org.krysalis.barcode4j.tools.UnitConv;

public abstract class AbstractBarcodeBean
implements BarcodeGenerator {
    protected double height = 15.0;
    protected double moduleWidth;
    protected HumanReadablePlacement msgPos = HumanReadablePlacement.HRP_BOTTOM;
    protected double fontSize = UnitConv.pt2mm(8.0);
    protected String fontName = "Helvetica";
    protected boolean doQuietZone = true;
    protected double quietZone;
    protected Double quietZoneVertical;
    protected String pattern;

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    protected boolean hasFontDescender() {
        return false;
    }

    public double getHumanReadableHeight() {
        if (this.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            double d = this.fontSize;
            if (this.hasFontDescender()) {
                return 1.3 * d;
            }
            return d;
        }
        return 0.0;
    }

    public double getBarHeight() {
        return this.height;
    }

    public double getHeight() {
        return this.getBarHeight() + this.getHumanReadableHeight();
    }

    public void setBarHeight(double d) {
        this.height = d;
    }

    public void setHeight(double d) {
        this.height = d - this.getHumanReadableHeight();
    }

    public double getModuleWidth() {
        return this.moduleWidth;
    }

    public void setModuleWidth(double d) {
        this.moduleWidth = d;
    }

    public abstract double getBarWidth(int var1);

    public boolean hasQuietZone() {
        return this.doQuietZone;
    }

    public void doQuietZone(boolean bl) {
        this.doQuietZone = bl;
    }

    public double getQuietZone() {
        return this.quietZone;
    }

    public double getVerticalQuietZone() {
        if (this.quietZoneVertical != null) {
            return this.quietZoneVertical;
        }
        return this.getQuietZone();
    }

    public void setQuietZone(double d) {
        this.quietZone = d;
    }

    public void setVerticalQuietZone(double d) {
        this.quietZoneVertical = new Double(d);
    }

    public HumanReadablePlacement getMsgPosition() {
        return this.msgPos;
    }

    public void setMsgPosition(HumanReadablePlacement humanReadablePlacement) {
        this.msgPos = humanReadablePlacement;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(double d) {
        this.fontSize = d;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public abstract void generateBarcode(CanvasProvider var1, String var2);

    public BarcodeDimension calcDimensions(String string) {
        throw new UnsupportedOperationException("NYI");
    }
}

