/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j;

import ai.org.krysalis.barcode4j.BarcodeClassResolver;
import ai.org.krysalis.barcode4j.BarcodeException;
import ai.org.krysalis.barcode4j.BarcodeGenerator;
import ai.org.krysalis.barcode4j.DefaultBarcodeClassResolver;
import ai.org.krysalis.barcode4j.output.svg.SVGCanvasProvider;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.w3c.dom.DocumentFragment;

public class BarcodeUtil {
    private static BarcodeUtil instance = null;
    private BarcodeClassResolver classResolver = new DefaultBarcodeClassResolver();

    protected BarcodeUtil() {
    }

    public static BarcodeUtil getInstance() {
        if (instance == null) {
            instance = new BarcodeUtil();
        }
        return instance;
    }

    public BarcodeClassResolver getClassResolver() {
        return this.classResolver;
    }

    public static BarcodeGenerator createBarcodeGenerator(Configuration configuration, BarcodeClassResolver barcodeClassResolver) throws BarcodeException, ConfigurationException {
        Class clazz = null;
        try {
            Object object;
            String string = configuration.getName();
            try {
                clazz = barcodeClassResolver.resolve(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
            Configuration configuration2 = null;
            if (clazz == null) {
                object = configuration.getChildren();
                if (((Configuration[])object).length == 0) {
                    throw new BarcodeException("Barcode configuration element expected");
                }
                for (int i = 0; i < ((Configuration[])object).length; ++i) {
                    configuration2 = object[i];
                    string = configuration2.getName();
                    try {
                        clazz = barcodeClassResolver.resolve(string);
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        clazz = null;
                        continue;
                    }
                }
            }
            if (clazz == null) {
                throw new BarcodeException("No barcode configuration element not found");
            }
            object = (BarcodeGenerator)clazz.newInstance();
            try {
                ContainerUtil.configure((Object)object, (Configuration)(configuration2 != null ? configuration2 : configuration));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ConfigurationException("Cannot configure barcode generator", (Throwable)illegalArgumentException);
            }
            try {
                ContainerUtil.initialize((Object)object);
            }
            catch (Exception exception) {
                throw new RuntimeException("Cannot initialize barcode generator. " + exception.getMessage());
            }
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Problem while instantiating a barcode generator: " + illegalAccessException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new BarcodeException("Error instantiating a barcode generator: " + clazz.getName());
        }
    }

    public BarcodeGenerator createBarcodeGenerator(Configuration configuration) throws ConfigurationException, BarcodeException {
        return BarcodeUtil.createBarcodeGenerator(configuration, this.classResolver);
    }

    public DocumentFragment generateSVGBarcode(Configuration configuration, String string) throws ConfigurationException, BarcodeException {
        BarcodeGenerator barcodeGenerator = this.createBarcodeGenerator(configuration);
        SVGCanvasProvider sVGCanvasProvider = new SVGCanvasProvider(false, 0);
        barcodeGenerator.generateBarcode(sVGCanvasProvider, string);
        return sVGCanvasProvider.getDOMFragment();
    }
}

