/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j;

import java.awt.geom.Rectangle2D;

public class BarcodeDimension {
    private double width;
    private double height;
    private double widthPlusQuiet;
    private double heightPlusQuiet;
    private double xOffset;
    private double yOffset;

    public BarcodeDimension(double d, double d2) {
        this.width = d;
        this.height = d2;
        this.widthPlusQuiet = this.width;
        this.heightPlusQuiet = this.height;
        this.xOffset = 0.0;
        this.yOffset = 0.0;
    }

    public BarcodeDimension(double d, double d2, double d3, double d4, double d5, double d6) {
        this.width = d;
        this.height = d2;
        this.widthPlusQuiet = d3;
        this.heightPlusQuiet = d4;
        this.xOffset = d5;
        this.yOffset = d6;
    }

    public double getHeight() {
        return this.height;
    }

    public double getHeight(int n) {
        if ((n = BarcodeDimension.normalizeOrientation(n)) % 180 != 0) {
            return this.getWidth();
        }
        return this.getHeight();
    }

    public double getHeightPlusQuiet() {
        return this.heightPlusQuiet;
    }

    public double getHeightPlusQuiet(int n) {
        if ((n = BarcodeDimension.normalizeOrientation(n)) % 180 != 0) {
            return this.getWidthPlusQuiet();
        }
        return this.getHeightPlusQuiet();
    }

    public double getWidth() {
        return this.width;
    }

    public static int normalizeOrientation(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case -270: 
            case 90: {
                return 90;
            }
            case -180: 
            case 180: {
                return 180;
            }
            case -90: 
            case 270: {
                return 270;
            }
        }
        throw new IllegalArgumentException("Orientation must be 0, 90, 180, 270, -90, -180 or -270");
    }

    public double getWidth(int n) {
        if ((n = BarcodeDimension.normalizeOrientation(n)) % 180 != 0) {
            return this.getHeight();
        }
        return this.getWidth();
    }

    public double getWidthPlusQuiet() {
        return this.widthPlusQuiet;
    }

    public double getWidthPlusQuiet(int n) {
        if ((n = BarcodeDimension.normalizeOrientation(n)) % 180 != 0) {
            return this.getHeightPlusQuiet();
        }
        return this.getWidthPlusQuiet();
    }

    public double getXOffset() {
        return this.xOffset;
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public Rectangle2D getBoundingRect() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.getWidthPlusQuiet(), this.getHeightPlusQuiet());
        return double_;
    }

    public Rectangle2D getContentRect() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.getXOffset(), this.getYOffset(), this.getWidth(), this.getHeight());
        return double_;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("[width=");
        stringBuffer.append(this.getWidth());
        stringBuffer.append("(");
        stringBuffer.append(this.getWidthPlusQuiet());
        stringBuffer.append("),height=");
        stringBuffer.append(this.getHeight());
        stringBuffer.append("(");
        stringBuffer.append(this.getHeightPlusQuiet());
        stringBuffer.append(")]");
        return stringBuffer.toString();
    }
}

