/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jsoup.select;

import ai.org.jsoup.helper.StringUtil;
import ai.org.jsoup.helper.Validate;
import ai.org.jsoup.parser.TokenQueue;
import ai.org.jsoup.select.CombiningEvaluator;
import ai.org.jsoup.select.Evaluator;
import ai.org.jsoup.select.Selector;
import ai.org.jsoup.select.StructuralEvaluator;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class QueryParser {
    private static final String[] combinators = new String[]{",", ">", "+", "~", " "};
    private TokenQueue tq;
    private String query;
    private List<Evaluator> evals = new ArrayList<Evaluator>();
    private static final Pattern NTH_AB = Pattern.compile("((\\+|-)?(\\d+)?)n(\\s*(\\+|-)?\\s*\\d+)?", 2);
    private static final Pattern NTH_B = Pattern.compile("(\\+|-)?(\\d+)");

    private QueryParser(String string) {
        this.query = string;
        this.tq = new TokenQueue(string);
    }

    public static Evaluator parse(String string) {
        QueryParser queryParser = new QueryParser(string);
        return queryParser.parse();
    }

    Evaluator parse() {
        this.tq.consumeWhitespace();
        if (this.tq.matchesAny(combinators)) {
            this.evals.add(new StructuralEvaluator.Root());
            this.combinator(this.tq.consume());
        } else {
            this.findElements();
        }
        while (!this.tq.isEmpty()) {
            boolean bl = this.tq.consumeWhitespace();
            if (this.tq.matchesAny(combinators)) {
                this.combinator(this.tq.consume());
                continue;
            }
            if (bl) {
                this.combinator(' ');
                continue;
            }
            this.findElements();
        }
        if (this.evals.size() == 1) {
            return this.evals.get(0);
        }
        return new CombiningEvaluator.And(this.evals);
    }

    private void combinator(char c) {
        Evaluator evaluator;
        Evaluator evaluator2;
        this.tq.consumeWhitespace();
        String string = this.consumeSubQuery();
        Evaluator evaluator3 = QueryParser.parse(string);
        boolean bl = false;
        if (this.evals.size() == 1) {
            evaluator2 = this.evals.get(0);
            evaluator = evaluator2;
            if (evaluator instanceof CombiningEvaluator.Or && c != ',') {
                evaluator2 = ((CombiningEvaluator.Or)evaluator2).rightMostEvaluator();
                bl = true;
            }
        } else {
            evaluator = evaluator2 = new CombiningEvaluator.And(this.evals);
        }
        this.evals.clear();
        if (c == '>') {
            evaluator2 = new CombiningEvaluator.And(evaluator3, new StructuralEvaluator.ImmediateParent(evaluator2));
        } else if (c == ' ') {
            evaluator2 = new CombiningEvaluator.And(evaluator3, new StructuralEvaluator.Parent(evaluator2));
        } else if (c == '+') {
            evaluator2 = new CombiningEvaluator.And(evaluator3, new StructuralEvaluator.ImmediatePreviousSibling(evaluator2));
        } else if (c == '~') {
            evaluator2 = new CombiningEvaluator.And(evaluator3, new StructuralEvaluator.PreviousSibling(evaluator2));
        } else if (c == ',') {
            CombiningEvaluator.Or or;
            if (evaluator2 instanceof CombiningEvaluator.Or) {
                or = (CombiningEvaluator.Or)evaluator2;
                or.add(evaluator3);
            } else {
                or = new CombiningEvaluator.Or();
                or.add(evaluator2);
                or.add(evaluator3);
            }
            evaluator2 = or;
        } else {
            throw new Selector.SelectorParseException("Unknown combinator: " + c, new Object[0]);
        }
        if (bl) {
            ((CombiningEvaluator.Or)evaluator).replaceRightMostEvaluator(evaluator2);
        } else {
            evaluator = evaluator2;
        }
        this.evals.add(evaluator);
    }

    private String consumeSubQuery() {
        StringBuilder stringBuilder = new StringBuilder();
        while (!this.tq.isEmpty()) {
            if (this.tq.matches("(")) {
                stringBuilder.append("(").append(this.tq.chompBalanced('(', ')')).append(")");
                continue;
            }
            if (this.tq.matches("[")) {
                stringBuilder.append("[").append(this.tq.chompBalanced('[', ']')).append("]");
                continue;
            }
            if (this.tq.matchesAny(combinators)) break;
            stringBuilder.append(this.tq.consume());
        }
        return stringBuilder.toString();
    }

    private void findElements() {
        if (this.tq.matchChomp("#")) {
            this.byId();
        } else if (this.tq.matchChomp(".")) {
            this.byClass();
        } else if (this.tq.matchesWord()) {
            this.byTag();
        } else if (this.tq.matches("[")) {
            this.byAttribute();
        } else if (this.tq.matchChomp("*")) {
            this.allElements();
        } else if (this.tq.matchChomp(":lt(")) {
            this.indexLessThan();
        } else if (this.tq.matchChomp(":gt(")) {
            this.indexGreaterThan();
        } else if (this.tq.matchChomp(":eq(")) {
            this.indexEquals();
        } else if (this.tq.matches(":has(")) {
            this.has();
        } else if (this.tq.matches(":contains(")) {
            this.contains(false);
        } else if (this.tq.matches(":containsOwn(")) {
            this.contains(true);
        } else if (this.tq.matches(":matches(")) {
            this.matches(false);
        } else if (this.tq.matches(":matchesOwn(")) {
            this.matches(true);
        } else if (this.tq.matches(":not(")) {
            this.not();
        } else if (this.tq.matchChomp(":nth-child(")) {
            this.cssNthChild(false, false);
        } else if (this.tq.matchChomp(":nth-last-child(")) {
            this.cssNthChild(true, false);
        } else if (this.tq.matchChomp(":nth-of-type(")) {
            this.cssNthChild(false, true);
        } else if (this.tq.matchChomp(":nth-last-of-type(")) {
            this.cssNthChild(true, true);
        } else if (this.tq.matchChomp(":first-child")) {
            this.evals.add(new Evaluator.IsFirstChild());
        } else if (this.tq.matchChomp(":last-child")) {
            this.evals.add(new Evaluator.IsLastChild());
        } else if (this.tq.matchChomp(":first-of-type")) {
            this.evals.add(new Evaluator.IsFirstOfType());
        } else if (this.tq.matchChomp(":last-of-type")) {
            this.evals.add(new Evaluator.IsLastOfType());
        } else if (this.tq.matchChomp(":only-child")) {
            this.evals.add(new Evaluator.IsOnlyChild());
        } else if (this.tq.matchChomp(":only-of-type")) {
            this.evals.add(new Evaluator.IsOnlyOfType());
        } else if (this.tq.matchChomp(":empty")) {
            this.evals.add(new Evaluator.IsEmpty());
        } else if (this.tq.matchChomp(":root")) {
            this.evals.add(new Evaluator.IsRoot());
        } else {
            throw new Selector.SelectorParseException("Could not parse query '%s': unexpected token at '%s'", this.query, this.tq.remainder());
        }
    }

    private void byId() {
        String string = this.tq.consumeCssIdentifier();
        Validate.notEmpty(string);
        this.evals.add(new Evaluator.Id(string));
    }

    private void byClass() {
        String string = this.tq.consumeCssIdentifier();
        Validate.notEmpty(string);
        this.evals.add(new Evaluator.Class(string.trim().toLowerCase()));
    }

    private void byTag() {
        String string = this.tq.consumeElementSelector();
        Validate.notEmpty(string);
        if (string.contains("|")) {
            string = string.replace("|", ":");
        }
        this.evals.add(new Evaluator.Tag(string.trim().toLowerCase()));
    }

    private void byAttribute() {
        TokenQueue tokenQueue = new TokenQueue(this.tq.chompBalanced('[', ']'));
        String string = tokenQueue.consumeToAny("=", "!=", "^=", "$=", "*=", "~=");
        Validate.notEmpty(string);
        tokenQueue.consumeWhitespace();
        if (tokenQueue.isEmpty()) {
            if (string.startsWith("^")) {
                this.evals.add(new Evaluator.AttributeStarting(string.substring(1)));
            } else {
                this.evals.add(new Evaluator.Attribute(string));
            }
        } else if (tokenQueue.matchChomp("=")) {
            this.evals.add(new Evaluator.AttributeWithValue(string, tokenQueue.remainder()));
        } else if (tokenQueue.matchChomp("!=")) {
            this.evals.add(new Evaluator.AttributeWithValueNot(string, tokenQueue.remainder()));
        } else if (tokenQueue.matchChomp("^=")) {
            this.evals.add(new Evaluator.AttributeWithValueStarting(string, tokenQueue.remainder()));
        } else if (tokenQueue.matchChomp("$=")) {
            this.evals.add(new Evaluator.AttributeWithValueEnding(string, tokenQueue.remainder()));
        } else if (tokenQueue.matchChomp("*=")) {
            this.evals.add(new Evaluator.AttributeWithValueContaining(string, tokenQueue.remainder()));
        } else if (tokenQueue.matchChomp("~=")) {
            this.evals.add(new Evaluator.AttributeWithValueMatching(string, Pattern.compile(tokenQueue.remainder())));
        } else {
            throw new Selector.SelectorParseException("Could not parse attribute query '%s': unexpected token at '%s'", this.query, tokenQueue.remainder());
        }
    }

    private void allElements() {
        this.evals.add(new Evaluator.AllElements());
    }

    private void indexLessThan() {
        this.evals.add(new Evaluator.IndexLessThan(this.consumeIndex()));
    }

    private void indexGreaterThan() {
        this.evals.add(new Evaluator.IndexGreaterThan(this.consumeIndex()));
    }

    private void indexEquals() {
        this.evals.add(new Evaluator.IndexEquals(this.consumeIndex()));
    }

    private void cssNthChild(boolean bl, boolean bl2) {
        int n;
        int n2;
        String string = this.tq.chompTo(")").trim().toLowerCase();
        Matcher matcher = NTH_AB.matcher(string);
        Matcher matcher2 = NTH_B.matcher(string);
        if ("odd".equals(string)) {
            n2 = 2;
            n = 1;
        } else if ("even".equals(string)) {
            n2 = 2;
            n = 0;
        } else if (matcher.matches()) {
            n2 = matcher.group(3) != null ? Integer.parseInt(matcher.group(1).replaceFirst("^\\+", "")) : 1;
            n = matcher.group(4) != null ? Integer.parseInt(matcher.group(4).replaceFirst("^\\+", "")) : 0;
        } else if (matcher2.matches()) {
            n2 = 0;
            n = Integer.parseInt(matcher2.group().replaceFirst("^\\+", ""));
        } else {
            throw new Selector.SelectorParseException("Could not parse nth-index '%s': unexpected format", string);
        }
        if (bl2) {
            if (bl) {
                this.evals.add(new Evaluator.IsNthLastOfType(n2, n));
            } else {
                this.evals.add(new Evaluator.IsNthOfType(n2, n));
            }
        } else if (bl) {
            this.evals.add(new Evaluator.IsNthLastChild(n2, n));
        } else {
            this.evals.add(new Evaluator.IsNthChild(n2, n));
        }
    }

    private int consumeIndex() {
        String string = this.tq.chompTo(")").trim();
        Validate.isTrue(StringUtil.isNumeric(string), "Index must be numeric");
        return Integer.parseInt(string);
    }

    private void has() {
        this.tq.consume(":has");
        String string = this.tq.chompBalanced('(', ')');
        Validate.notEmpty(string, ":has(el) subselect must not be empty");
        this.evals.add(new StructuralEvaluator.Has(QueryParser.parse(string)));
    }

    private void contains(boolean bl) {
        this.tq.consume(bl ? ":containsOwn" : ":contains");
        String string = TokenQueue.unescape(this.tq.chompBalanced('(', ')'));
        Validate.notEmpty(string, ":contains(text) query must not be empty");
        if (bl) {
            this.evals.add(new Evaluator.ContainsOwnText(string));
        } else {
            this.evals.add(new Evaluator.ContainsText(string));
        }
    }

    private void matches(boolean bl) {
        this.tq.consume(bl ? ":matchesOwn" : ":matches");
        String string = this.tq.chompBalanced('(', ')');
        Validate.notEmpty(string, ":matches(regex) query must not be empty");
        if (bl) {
            this.evals.add(new Evaluator.MatchesOwn(Pattern.compile(string)));
        } else {
            this.evals.add(new Evaluator.Matches(Pattern.compile(string)));
        }
    }

    private void not() {
        this.tq.consume(":not");
        String string = this.tq.chompBalanced('(', ')');
        Validate.notEmpty(string, ":not(selector) subselect must not be empty");
        this.evals.add(new StructuralEvaluator.Not(QueryParser.parse(string)));
    }
}

