/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jsoup.parser;

import ai.org.jsoup.parser.CharacterReader;
import ai.org.jsoup.parser.Token;
import ai.org.jsoup.parser.Tokeniser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum TokeniserState {
    Data{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            switch (characterReader.current()) {
                case '&': {
                    tokeniser.advanceTransition(CharacterReferenceInData);
                    break;
                }
                case '<': {
                    tokeniser.advanceTransition(TagOpen);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.emit(characterReader.consume());
                    break;
                }
                case '\uffff': {
                    tokeniser.emit(new Token.EOF());
                    break;
                }
                default: {
                    String string = characterReader.consumeToAny('&', '<', '\u0000');
                    tokeniser.emit(string);
                }
            }
        }
    }
    ,
    CharacterReferenceInData{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char[] cArray = tokeniser.consumeCharacterReference(null, false);
            if (cArray == null) {
                tokeniser.emit('&');
            } else {
                tokeniser.emit(cArray);
            }
            tokeniser.transition(Data);
        }
    }
    ,
    Rcdata{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            switch (characterReader.current()) {
                case '&': {
                    tokeniser.advanceTransition(CharacterReferenceInRcdata);
                    break;
                }
                case '<': {
                    tokeniser.advanceTransition(RcdataLessthanSign);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    characterReader.advance();
                    tokeniser.emit('\ufffd');
                    break;
                }
                case '\uffff': {
                    tokeniser.emit(new Token.EOF());
                    break;
                }
                default: {
                    String string = characterReader.consumeToAny('&', '<', '\u0000');
                    tokeniser.emit(string);
                }
            }
        }
    }
    ,
    CharacterReferenceInRcdata{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char[] cArray = tokeniser.consumeCharacterReference(null, false);
            if (cArray == null) {
                tokeniser.emit('&');
            } else {
                tokeniser.emit(cArray);
            }
            tokeniser.transition(Rcdata);
        }
    }
    ,
    Rawtext{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            switch (characterReader.current()) {
                case '<': {
                    tokeniser.advanceTransition(RawtextLessthanSign);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    characterReader.advance();
                    tokeniser.emit('\ufffd');
                    break;
                }
                case '\uffff': {
                    tokeniser.emit(new Token.EOF());
                    break;
                }
                default: {
                    String string = characterReader.consumeToAny('<', '\u0000');
                    tokeniser.emit(string);
                }
            }
        }
    }
    ,
    ScriptData{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            switch (characterReader.current()) {
                case '<': {
                    tokeniser.advanceTransition(ScriptDataLessthanSign);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    characterReader.advance();
                    tokeniser.emit('\ufffd');
                    break;
                }
                case '\uffff': {
                    tokeniser.emit(new Token.EOF());
                    break;
                }
                default: {
                    String string = characterReader.consumeToAny('<', '\u0000');
                    tokeniser.emit(string);
                }
            }
        }
    }
    ,
    PLAINTEXT{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            switch (characterReader.current()) {
                case '\u0000': {
                    tokeniser.error(this);
                    characterReader.advance();
                    tokeniser.emit('\ufffd');
                    break;
                }
                case '\uffff': {
                    tokeniser.emit(new Token.EOF());
                    break;
                }
                default: {
                    String string = characterReader.consumeTo('\u0000');
                    tokeniser.emit(string);
                }
            }
        }
    }
    ,
    TagOpen{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            switch (characterReader.current()) {
                case '!': {
                    tokeniser.advanceTransition(MarkupDeclarationOpen);
                    break;
                }
                case '/': {
                    tokeniser.advanceTransition(EndTagOpen);
                    break;
                }
                case '?': {
                    tokeniser.advanceTransition(BogusComment);
                    break;
                }
                default: {
                    if (characterReader.matchesLetter()) {
                        tokeniser.createTagPending(true);
                        tokeniser.transition(TagName);
                        break;
                    }
                    tokeniser.error(this);
                    tokeniser.emit('<');
                    tokeniser.transition(Data);
                }
            }
        }
    }
    ,
    EndTagOpen{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.isEmpty()) {
                tokeniser.eofError(this);
                tokeniser.emit("</");
                tokeniser.transition(Data);
            } else if (characterReader.matchesLetter()) {
                tokeniser.createTagPending(false);
                tokeniser.transition(TagName);
            } else if (characterReader.matches('>')) {
                tokeniser.error(this);
                tokeniser.advanceTransition(Data);
            } else {
                tokeniser.error(this);
                tokeniser.advanceTransition(BogusComment);
            }
        }
    }
    ,
    TagName{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            String string = characterReader.consumeToAny('\t', '\n', '\r', '\f', ' ', '/', '>', '\u0000').toLowerCase();
            tokeniser.tagPending.appendTagName(string);
            switch (characterReader.consume()) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    tokeniser.transition(BeforeAttributeName);
                    break;
                }
                case '/': {
                    tokeniser.transition(SelfClosingStartTag);
                    break;
                }
                case '>': {
                    tokeniser.emitTagPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\u0000': {
                    tokeniser.tagPending.appendTagName(replacementStr);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                }
            }
        }
    }
    ,
    RcdataLessthanSign{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matches('/')) {
                tokeniser.createTempBuffer();
                tokeniser.advanceTransition(RCDATAEndTagOpen);
            } else if (characterReader.matchesLetter() && !characterReader.containsIgnoreCase("</" + tokeniser.appropriateEndTagName())) {
                tokeniser.tagPending = new Token.EndTag(tokeniser.appropriateEndTagName());
                tokeniser.emitTagPending();
                characterReader.unconsume();
                tokeniser.transition(Data);
            } else {
                tokeniser.emit("<");
                tokeniser.transition(Rcdata);
            }
        }
    }
    ,
    RCDATAEndTagOpen{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matchesLetter()) {
                tokeniser.createTagPending(false);
                tokeniser.tagPending.appendTagName(Character.toLowerCase(characterReader.current()));
                tokeniser.dataBuffer.append(Character.toLowerCase(characterReader.current()));
                tokeniser.advanceTransition(RCDATAEndTagName);
            } else {
                tokeniser.emit("</");
                tokeniser.transition(Rcdata);
            }
        }
    }
    ,
    RCDATAEndTagName{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matchesLetter()) {
                String string = characterReader.consumeLetterSequence();
                tokeniser.tagPending.appendTagName(string.toLowerCase());
                tokeniser.dataBuffer.append(string);
                return;
            }
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (tokeniser.isAppropriateEndTagToken()) {
                        tokeniser.transition(BeforeAttributeName);
                        break;
                    }
                    this.anythingElse(tokeniser, characterReader);
                    break;
                }
                case '/': {
                    if (tokeniser.isAppropriateEndTagToken()) {
                        tokeniser.transition(SelfClosingStartTag);
                        break;
                    }
                    this.anythingElse(tokeniser, characterReader);
                    break;
                }
                case '>': {
                    if (tokeniser.isAppropriateEndTagToken()) {
                        tokeniser.emitTagPending();
                        tokeniser.transition(Data);
                        break;
                    }
                    this.anythingElse(tokeniser, characterReader);
                    break;
                }
                default: {
                    this.anythingElse(tokeniser, characterReader);
                }
            }
        }

        private void anythingElse(Tokeniser tokeniser, CharacterReader characterReader) {
            tokeniser.emit("</" + tokeniser.dataBuffer.toString());
            characterReader.unconsume();
            tokeniser.transition(Rcdata);
        }
    }
    ,
    RawtextLessthanSign{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matches('/')) {
                tokeniser.createTempBuffer();
                tokeniser.advanceTransition(RawtextEndTagOpen);
            } else {
                tokeniser.emit('<');
                tokeniser.transition(Rawtext);
            }
        }
    }
    ,
    RawtextEndTagOpen{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matchesLetter()) {
                tokeniser.createTagPending(false);
                tokeniser.transition(RawtextEndTagName);
            } else {
                tokeniser.emit("</");
                tokeniser.transition(Rawtext);
            }
        }
    }
    ,
    RawtextEndTagName{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matchesLetter()) {
                String string = characterReader.consumeLetterSequence();
                tokeniser.tagPending.appendTagName(string.toLowerCase());
                tokeniser.dataBuffer.append(string);
                return;
            }
            if (tokeniser.isAppropriateEndTagToken() && !characterReader.isEmpty()) {
                char c = characterReader.consume();
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        tokeniser.transition(BeforeAttributeName);
                        break;
                    }
                    case '/': {
                        tokeniser.transition(SelfClosingStartTag);
                        break;
                    }
                    case '>': {
                        tokeniser.emitTagPending();
                        tokeniser.transition(Data);
                        break;
                    }
                    default: {
                        tokeniser.dataBuffer.append(c);
                        this.anythingElse(tokeniser, characterReader);
                        break;
                    }
                }
            } else {
                this.anythingElse(tokeniser, characterReader);
            }
        }

        private void anythingElse(Tokeniser tokeniser, CharacterReader characterReader) {
            tokeniser.emit("</" + tokeniser.dataBuffer.toString());
            tokeniser.transition(Rawtext);
        }
    }
    ,
    ScriptDataLessthanSign{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            switch (characterReader.consume()) {
                case '/': {
                    tokeniser.createTempBuffer();
                    tokeniser.transition(ScriptDataEndTagOpen);
                    break;
                }
                case '!': {
                    tokeniser.emit("<!");
                    tokeniser.transition(ScriptDataEscapeStart);
                    break;
                }
                default: {
                    tokeniser.emit("<");
                    characterReader.unconsume();
                    tokeniser.transition(ScriptData);
                }
            }
        }
    }
    ,
    ScriptDataEndTagOpen{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matchesLetter()) {
                tokeniser.createTagPending(false);
                tokeniser.transition(ScriptDataEndTagName);
            } else {
                tokeniser.emit("</");
                tokeniser.transition(ScriptData);
            }
        }
    }
    ,
    ScriptDataEndTagName{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matchesLetter()) {
                String string = characterReader.consumeLetterSequence();
                tokeniser.tagPending.appendTagName(string.toLowerCase());
                tokeniser.dataBuffer.append(string);
                return;
            }
            if (tokeniser.isAppropriateEndTagToken() && !characterReader.isEmpty()) {
                char c = characterReader.consume();
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        tokeniser.transition(BeforeAttributeName);
                        break;
                    }
                    case '/': {
                        tokeniser.transition(SelfClosingStartTag);
                        break;
                    }
                    case '>': {
                        tokeniser.emitTagPending();
                        tokeniser.transition(Data);
                        break;
                    }
                    default: {
                        tokeniser.dataBuffer.append(c);
                        this.anythingElse(tokeniser, characterReader);
                        break;
                    }
                }
            } else {
                this.anythingElse(tokeniser, characterReader);
            }
        }

        private void anythingElse(Tokeniser tokeniser, CharacterReader characterReader) {
            tokeniser.emit("</" + tokeniser.dataBuffer.toString());
            tokeniser.transition(ScriptData);
        }
    }
    ,
    ScriptDataEscapeStart{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matches('-')) {
                tokeniser.emit('-');
                tokeniser.advanceTransition(ScriptDataEscapeStartDash);
            } else {
                tokeniser.transition(ScriptData);
            }
        }
    }
    ,
    ScriptDataEscapeStartDash{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matches('-')) {
                tokeniser.emit('-');
                tokeniser.advanceTransition(ScriptDataEscapedDashDash);
            } else {
                tokeniser.transition(ScriptData);
            }
        }
    }
    ,
    ScriptDataEscaped{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.isEmpty()) {
                tokeniser.eofError(this);
                tokeniser.transition(Data);
                return;
            }
            switch (characterReader.current()) {
                case '-': {
                    tokeniser.emit('-');
                    tokeniser.advanceTransition(ScriptDataEscapedDash);
                    break;
                }
                case '<': {
                    tokeniser.advanceTransition(ScriptDataEscapedLessthanSign);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    characterReader.advance();
                    tokeniser.emit('\ufffd');
                    break;
                }
                default: {
                    String string = characterReader.consumeToAny('-', '<', '\u0000');
                    tokeniser.emit(string);
                }
            }
        }
    }
    ,
    ScriptDataEscapedDash{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.isEmpty()) {
                tokeniser.eofError(this);
                tokeniser.transition(Data);
                return;
            }
            char c = characterReader.consume();
            switch (c) {
                case '-': {
                    tokeniser.emit(c);
                    tokeniser.transition(ScriptDataEscapedDashDash);
                    break;
                }
                case '<': {
                    tokeniser.transition(ScriptDataEscapedLessthanSign);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.emit('\ufffd');
                    tokeniser.transition(ScriptDataEscaped);
                    break;
                }
                default: {
                    tokeniser.emit(c);
                    tokeniser.transition(ScriptDataEscaped);
                }
            }
        }
    }
    ,
    ScriptDataEscapedDashDash{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.isEmpty()) {
                tokeniser.eofError(this);
                tokeniser.transition(Data);
                return;
            }
            char c = characterReader.consume();
            switch (c) {
                case '-': {
                    tokeniser.emit(c);
                    break;
                }
                case '<': {
                    tokeniser.transition(ScriptDataEscapedLessthanSign);
                    break;
                }
                case '>': {
                    tokeniser.emit(c);
                    tokeniser.transition(ScriptData);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.emit('\ufffd');
                    tokeniser.transition(ScriptDataEscaped);
                    break;
                }
                default: {
                    tokeniser.emit(c);
                    tokeniser.transition(ScriptDataEscaped);
                }
            }
        }
    }
    ,
    ScriptDataEscapedLessthanSign{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matchesLetter()) {
                tokeniser.createTempBuffer();
                tokeniser.dataBuffer.append(Character.toLowerCase(characterReader.current()));
                tokeniser.emit("<" + characterReader.current());
                tokeniser.advanceTransition(ScriptDataDoubleEscapeStart);
            } else if (characterReader.matches('/')) {
                tokeniser.createTempBuffer();
                tokeniser.advanceTransition(ScriptDataEscapedEndTagOpen);
            } else {
                tokeniser.emit('<');
                tokeniser.transition(ScriptDataEscaped);
            }
        }
    }
    ,
    ScriptDataEscapedEndTagOpen{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matchesLetter()) {
                tokeniser.createTagPending(false);
                tokeniser.tagPending.appendTagName(Character.toLowerCase(characterReader.current()));
                tokeniser.dataBuffer.append(characterReader.current());
                tokeniser.advanceTransition(ScriptDataEscapedEndTagName);
            } else {
                tokeniser.emit("</");
                tokeniser.transition(ScriptDataEscaped);
            }
        }
    }
    ,
    ScriptDataEscapedEndTagName{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matchesLetter()) {
                String string = characterReader.consumeLetterSequence();
                tokeniser.tagPending.appendTagName(string.toLowerCase());
                tokeniser.dataBuffer.append(string);
                return;
            }
            if (tokeniser.isAppropriateEndTagToken() && !characterReader.isEmpty()) {
                char c = characterReader.consume();
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        tokeniser.transition(BeforeAttributeName);
                        break;
                    }
                    case '/': {
                        tokeniser.transition(SelfClosingStartTag);
                        break;
                    }
                    case '>': {
                        tokeniser.emitTagPending();
                        tokeniser.transition(Data);
                        break;
                    }
                    default: {
                        tokeniser.dataBuffer.append(c);
                        this.anythingElse(tokeniser, characterReader);
                        break;
                    }
                }
            } else {
                this.anythingElse(tokeniser, characterReader);
            }
        }

        private void anythingElse(Tokeniser tokeniser, CharacterReader characterReader) {
            tokeniser.emit("</" + tokeniser.dataBuffer.toString());
            tokeniser.transition(ScriptDataEscaped);
        }
    }
    ,
    ScriptDataDoubleEscapeStart{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matchesLetter()) {
                String string = characterReader.consumeLetterSequence();
                tokeniser.dataBuffer.append(string.toLowerCase());
                tokeniser.emit(string);
                return;
            }
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '/': 
                case '>': {
                    if (tokeniser.dataBuffer.toString().equals("script")) {
                        tokeniser.transition(ScriptDataDoubleEscaped);
                    } else {
                        tokeniser.transition(ScriptDataEscaped);
                    }
                    tokeniser.emit(c);
                    break;
                }
                default: {
                    characterReader.unconsume();
                    tokeniser.transition(ScriptDataEscaped);
                }
            }
        }
    }
    ,
    ScriptDataDoubleEscaped{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.current();
            switch (c) {
                case '-': {
                    tokeniser.emit(c);
                    tokeniser.advanceTransition(ScriptDataDoubleEscapedDash);
                    break;
                }
                case '<': {
                    tokeniser.emit(c);
                    tokeniser.advanceTransition(ScriptDataDoubleEscapedLessthanSign);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    characterReader.advance();
                    tokeniser.emit('\ufffd');
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    String string = characterReader.consumeToAny('-', '<', '\u0000');
                    tokeniser.emit(string);
                }
            }
        }
    }
    ,
    ScriptDataDoubleEscapedDash{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '-': {
                    tokeniser.emit(c);
                    tokeniser.transition(ScriptDataDoubleEscapedDashDash);
                    break;
                }
                case '<': {
                    tokeniser.emit(c);
                    tokeniser.transition(ScriptDataDoubleEscapedLessthanSign);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.emit('\ufffd');
                    tokeniser.transition(ScriptDataDoubleEscaped);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.emit(c);
                    tokeniser.transition(ScriptDataDoubleEscaped);
                }
            }
        }
    }
    ,
    ScriptDataDoubleEscapedDashDash{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '-': {
                    tokeniser.emit(c);
                    break;
                }
                case '<': {
                    tokeniser.emit(c);
                    tokeniser.transition(ScriptDataDoubleEscapedLessthanSign);
                    break;
                }
                case '>': {
                    tokeniser.emit(c);
                    tokeniser.transition(ScriptData);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.emit('\ufffd');
                    tokeniser.transition(ScriptDataDoubleEscaped);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.emit(c);
                    tokeniser.transition(ScriptDataDoubleEscaped);
                }
            }
        }
    }
    ,
    ScriptDataDoubleEscapedLessthanSign{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matches('/')) {
                tokeniser.emit('/');
                tokeniser.createTempBuffer();
                tokeniser.advanceTransition(ScriptDataDoubleEscapeEnd);
            } else {
                tokeniser.transition(ScriptDataDoubleEscaped);
            }
        }
    }
    ,
    ScriptDataDoubleEscapeEnd{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matchesLetter()) {
                String string = characterReader.consumeLetterSequence();
                tokeniser.dataBuffer.append(string.toLowerCase());
                tokeniser.emit(string);
                return;
            }
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '/': 
                case '>': {
                    if (tokeniser.dataBuffer.toString().equals("script")) {
                        tokeniser.transition(ScriptDataEscaped);
                    } else {
                        tokeniser.transition(ScriptDataDoubleEscaped);
                    }
                    tokeniser.emit(c);
                    break;
                }
                default: {
                    characterReader.unconsume();
                    tokeniser.transition(ScriptDataDoubleEscaped);
                }
            }
        }
    }
    ,
    BeforeAttributeName{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '/': {
                    tokeniser.transition(SelfClosingStartTag);
                    break;
                }
                case '>': {
                    tokeniser.emitTagPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.tagPending.newAttribute();
                    characterReader.unconsume();
                    tokeniser.transition(AttributeName);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                case '\"': 
                case '\'': 
                case '<': 
                case '=': {
                    tokeniser.error(this);
                    tokeniser.tagPending.newAttribute();
                    tokeniser.tagPending.appendAttributeName(c);
                    tokeniser.transition(AttributeName);
                    break;
                }
                default: {
                    tokeniser.tagPending.newAttribute();
                    characterReader.unconsume();
                    tokeniser.transition(AttributeName);
                }
            }
        }
    }
    ,
    AttributeName{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            String string = characterReader.consumeToAny('\t', '\n', '\r', '\f', ' ', '/', '=', '>', '\u0000', '\"', '\'', '<');
            tokeniser.tagPending.appendAttributeName(string.toLowerCase());
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    tokeniser.transition(AfterAttributeName);
                    break;
                }
                case '/': {
                    tokeniser.transition(SelfClosingStartTag);
                    break;
                }
                case '=': {
                    tokeniser.transition(BeforeAttributeValue);
                    break;
                }
                case '>': {
                    tokeniser.emitTagPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.tagPending.appendAttributeName('\ufffd');
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                case '\"': 
                case '\'': 
                case '<': {
                    tokeniser.error(this);
                    tokeniser.tagPending.appendAttributeName(c);
                }
            }
        }
    }
    ,
    AfterAttributeName{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '/': {
                    tokeniser.transition(SelfClosingStartTag);
                    break;
                }
                case '=': {
                    tokeniser.transition(BeforeAttributeValue);
                    break;
                }
                case '>': {
                    tokeniser.emitTagPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.tagPending.appendAttributeName('\ufffd');
                    tokeniser.transition(AttributeName);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                case '\"': 
                case '\'': 
                case '<': {
                    tokeniser.error(this);
                    tokeniser.tagPending.newAttribute();
                    tokeniser.tagPending.appendAttributeName(c);
                    tokeniser.transition(AttributeName);
                    break;
                }
                default: {
                    tokeniser.tagPending.newAttribute();
                    characterReader.unconsume();
                    tokeniser.transition(AttributeName);
                }
            }
        }
    }
    ,
    BeforeAttributeValue{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\"': {
                    tokeniser.transition(AttributeValue_doubleQuoted);
                    break;
                }
                case '&': {
                    characterReader.unconsume();
                    tokeniser.transition(AttributeValue_unquoted);
                    break;
                }
                case '\'': {
                    tokeniser.transition(AttributeValue_singleQuoted);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.tagPending.appendAttributeValue('\ufffd');
                    tokeniser.transition(AttributeValue_unquoted);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.emitTagPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '<': 
                case '=': 
                case '`': {
                    tokeniser.error(this);
                    tokeniser.tagPending.appendAttributeValue(c);
                    tokeniser.transition(AttributeValue_unquoted);
                    break;
                }
                default: {
                    characterReader.unconsume();
                    tokeniser.transition(AttributeValue_unquoted);
                }
            }
        }
    }
    ,
    AttributeValue_doubleQuoted{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            String string = characterReader.consumeToAny('\"', '&', '\u0000');
            if (string.length() > 0) {
                tokeniser.tagPending.appendAttributeValue(string);
            }
            char c = characterReader.consume();
            switch (c) {
                case '\"': {
                    tokeniser.transition(AfterAttributeValue_quoted);
                    break;
                }
                case '&': {
                    char[] cArray = tokeniser.consumeCharacterReference(Character.valueOf('\"'), true);
                    if (cArray != null) {
                        tokeniser.tagPending.appendAttributeValue(cArray);
                        break;
                    }
                    tokeniser.tagPending.appendAttributeValue('&');
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.tagPending.appendAttributeValue('\ufffd');
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                }
            }
        }
    }
    ,
    AttributeValue_singleQuoted{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            String string = characterReader.consumeToAny('\'', '&', '\u0000');
            if (string.length() > 0) {
                tokeniser.tagPending.appendAttributeValue(string);
            }
            char c = characterReader.consume();
            switch (c) {
                case '\'': {
                    tokeniser.transition(AfterAttributeValue_quoted);
                    break;
                }
                case '&': {
                    char[] cArray = tokeniser.consumeCharacterReference(Character.valueOf('\''), true);
                    if (cArray != null) {
                        tokeniser.tagPending.appendAttributeValue(cArray);
                        break;
                    }
                    tokeniser.tagPending.appendAttributeValue('&');
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.tagPending.appendAttributeValue('\ufffd');
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                }
            }
        }
    }
    ,
    AttributeValue_unquoted{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            String string = characterReader.consumeToAny('\t', '\n', '\r', '\f', ' ', '&', '>', '\u0000', '\"', '\'', '<', '=', '`');
            if (string.length() > 0) {
                tokeniser.tagPending.appendAttributeValue(string);
            }
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    tokeniser.transition(BeforeAttributeName);
                    break;
                }
                case '&': {
                    char[] cArray = tokeniser.consumeCharacterReference(Character.valueOf('>'), true);
                    if (cArray != null) {
                        tokeniser.tagPending.appendAttributeValue(cArray);
                        break;
                    }
                    tokeniser.tagPending.appendAttributeValue('&');
                    break;
                }
                case '>': {
                    tokeniser.emitTagPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.tagPending.appendAttributeValue('\ufffd');
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                case '\"': 
                case '\'': 
                case '<': 
                case '=': 
                case '`': {
                    tokeniser.error(this);
                    tokeniser.tagPending.appendAttributeValue(c);
                }
            }
        }
    }
    ,
    AfterAttributeValue_quoted{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    tokeniser.transition(BeforeAttributeName);
                    break;
                }
                case '/': {
                    tokeniser.transition(SelfClosingStartTag);
                    break;
                }
                case '>': {
                    tokeniser.emitTagPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.error(this);
                    characterReader.unconsume();
                    tokeniser.transition(BeforeAttributeName);
                }
            }
        }
    }
    ,
    SelfClosingStartTag{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '>': {
                    tokeniser.tagPending.selfClosing = true;
                    tokeniser.emitTagPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.error(this);
                    tokeniser.transition(BeforeAttributeName);
                }
            }
        }
    }
    ,
    BogusComment{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            characterReader.unconsume();
            Token.Comment comment = new Token.Comment();
            comment.bogus = true;
            comment.data.append(characterReader.consumeTo('>'));
            tokeniser.emit(comment);
            tokeniser.advanceTransition(Data);
        }
    }
    ,
    MarkupDeclarationOpen{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matchConsume("--")) {
                tokeniser.createCommentPending();
                tokeniser.transition(CommentStart);
            } else if (characterReader.matchConsumeIgnoreCase("DOCTYPE")) {
                tokeniser.transition(Doctype);
            } else if (characterReader.matchConsume("[CDATA[")) {
                tokeniser.transition(CdataSection);
            } else {
                tokeniser.error(this);
                tokeniser.advanceTransition(BogusComment);
            }
        }
    }
    ,
    CommentStart{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '-': {
                    tokeniser.transition(CommentStartDash);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.commentPending.data.append('\ufffd');
                    tokeniser.transition(Comment);
                    break;
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.emitCommentPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.emitCommentPending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.commentPending.data.append(c);
                    tokeniser.transition(Comment);
                }
            }
        }
    }
    ,
    CommentStartDash{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '-': {
                    tokeniser.transition(CommentStartDash);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.commentPending.data.append('\ufffd');
                    tokeniser.transition(Comment);
                    break;
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.emitCommentPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.emitCommentPending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.commentPending.data.append(c);
                    tokeniser.transition(Comment);
                }
            }
        }
    }
    ,
    Comment{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.current();
            switch (c) {
                case '-': {
                    tokeniser.advanceTransition(CommentEndDash);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    characterReader.advance();
                    tokeniser.commentPending.data.append('\ufffd');
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.emitCommentPending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.commentPending.data.append(characterReader.consumeToAny('-', '\u0000'));
                }
            }
        }
    }
    ,
    CommentEndDash{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '-': {
                    tokeniser.transition(CommentEnd);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.commentPending.data.append('-').append('\ufffd');
                    tokeniser.transition(Comment);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.emitCommentPending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.commentPending.data.append('-').append(c);
                    tokeniser.transition(Comment);
                }
            }
        }
    }
    ,
    CommentEnd{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '>': {
                    tokeniser.emitCommentPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.commentPending.data.append("--").append('\ufffd');
                    tokeniser.transition(Comment);
                    break;
                }
                case '!': {
                    tokeniser.error(this);
                    tokeniser.transition(CommentEndBang);
                    break;
                }
                case '-': {
                    tokeniser.error(this);
                    tokeniser.commentPending.data.append('-');
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.emitCommentPending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.error(this);
                    tokeniser.commentPending.data.append("--").append(c);
                    tokeniser.transition(Comment);
                }
            }
        }
    }
    ,
    CommentEndBang{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '-': {
                    tokeniser.commentPending.data.append("--!");
                    tokeniser.transition(CommentEndDash);
                    break;
                }
                case '>': {
                    tokeniser.emitCommentPending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.commentPending.data.append("--!").append('\ufffd');
                    tokeniser.transition(Comment);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.emitCommentPending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.commentPending.data.append("--!").append(c);
                    tokeniser.transition(Comment);
                }
            }
        }
    }
    ,
    Doctype{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    tokeniser.transition(BeforeDoctypeName);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.createDoctypePending();
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.error(this);
                    tokeniser.transition(BeforeDoctypeName);
                }
            }
        }
    }
    ,
    BeforeDoctypeName{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matchesLetter()) {
                tokeniser.createDoctypePending();
                tokeniser.transition(DoctypeName);
                return;
            }
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.name.append('\ufffd');
                    tokeniser.transition(DoctypeName);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.createDoctypePending();
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.createDoctypePending();
                    tokeniser.doctypePending.name.append(c);
                    tokeniser.transition(DoctypeName);
                }
            }
        }
    }
    ,
    DoctypeName{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.matchesLetter()) {
                String string = characterReader.consumeLetterSequence();
                tokeniser.doctypePending.name.append(string.toLowerCase());
                return;
            }
            char c = characterReader.consume();
            switch (c) {
                case '>': {
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    tokeniser.transition(AfterDoctypeName);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.name.append('\ufffd');
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.doctypePending.name.append(c);
                }
            }
        }
    }
    ,
    AfterDoctypeName{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            if (characterReader.isEmpty()) {
                tokeniser.eofError(this);
                tokeniser.doctypePending.forceQuirks = true;
                tokeniser.emitDoctypePending();
                tokeniser.transition(Data);
                return;
            }
            if (characterReader.matchesAny('\t', '\n', '\r', '\f', ' ')) {
                characterReader.advance();
            } else if (characterReader.matches('>')) {
                tokeniser.emitDoctypePending();
                tokeniser.advanceTransition(Data);
            } else if (characterReader.matchConsumeIgnoreCase("PUBLIC")) {
                tokeniser.transition(AfterDoctypePublicKeyword);
            } else if (characterReader.matchConsumeIgnoreCase("SYSTEM")) {
                tokeniser.transition(AfterDoctypeSystemKeyword);
            } else {
                tokeniser.error(this);
                tokeniser.doctypePending.forceQuirks = true;
                tokeniser.advanceTransition(BogusDoctype);
            }
        }
    }
    ,
    AfterDoctypePublicKeyword{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    tokeniser.transition(BeforeDoctypePublicIdentifier);
                    break;
                }
                case '\"': {
                    tokeniser.error(this);
                    tokeniser.transition(DoctypePublicIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    tokeniser.error(this);
                    tokeniser.transition(DoctypePublicIdentifier_singleQuoted);
                    break;
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.transition(BogusDoctype);
                }
            }
        }
    }
    ,
    BeforeDoctypePublicIdentifier{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\"': {
                    tokeniser.transition(DoctypePublicIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    tokeniser.transition(DoctypePublicIdentifier_singleQuoted);
                    break;
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.transition(BogusDoctype);
                }
            }
        }
    }
    ,
    DoctypePublicIdentifier_doubleQuoted{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\"': {
                    tokeniser.transition(AfterDoctypePublicIdentifier);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.publicIdentifier.append('\ufffd');
                    break;
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.doctypePending.publicIdentifier.append(c);
                }
            }
        }
    }
    ,
    DoctypePublicIdentifier_singleQuoted{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\'': {
                    tokeniser.transition(AfterDoctypePublicIdentifier);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.publicIdentifier.append('\ufffd');
                    break;
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.doctypePending.publicIdentifier.append(c);
                }
            }
        }
    }
    ,
    AfterDoctypePublicIdentifier{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    tokeniser.transition(BetweenDoctypePublicAndSystemIdentifiers);
                    break;
                }
                case '>': {
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\"': {
                    tokeniser.error(this);
                    tokeniser.transition(DoctypeSystemIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    tokeniser.error(this);
                    tokeniser.transition(DoctypeSystemIdentifier_singleQuoted);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.transition(BogusDoctype);
                }
            }
        }
    }
    ,
    BetweenDoctypePublicAndSystemIdentifiers{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '>': {
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\"': {
                    tokeniser.error(this);
                    tokeniser.transition(DoctypeSystemIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    tokeniser.error(this);
                    tokeniser.transition(DoctypeSystemIdentifier_singleQuoted);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.transition(BogusDoctype);
                }
            }
        }
    }
    ,
    AfterDoctypeSystemKeyword{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    tokeniser.transition(BeforeDoctypeSystemIdentifier);
                    break;
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\"': {
                    tokeniser.error(this);
                    tokeniser.transition(DoctypeSystemIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    tokeniser.error(this);
                    tokeniser.transition(DoctypeSystemIdentifier_singleQuoted);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                }
            }
        }
    }
    ,
    BeforeDoctypeSystemIdentifier{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\"': {
                    tokeniser.transition(DoctypeSystemIdentifier_doubleQuoted);
                    break;
                }
                case '\'': {
                    tokeniser.transition(DoctypeSystemIdentifier_singleQuoted);
                    break;
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.transition(BogusDoctype);
                }
            }
        }
    }
    ,
    DoctypeSystemIdentifier_doubleQuoted{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\"': {
                    tokeniser.transition(AfterDoctypeSystemIdentifier);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.systemIdentifier.append('\ufffd');
                    break;
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.doctypePending.systemIdentifier.append(c);
                }
            }
        }
    }
    ,
    DoctypeSystemIdentifier_singleQuoted{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\'': {
                    tokeniser.transition(AfterDoctypeSystemIdentifier);
                    break;
                }
                case '\u0000': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.systemIdentifier.append('\ufffd');
                    break;
                }
                case '>': {
                    tokeniser.error(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.doctypePending.systemIdentifier.append(c);
                }
            }
        }
    }
    ,
    AfterDoctypeSystemIdentifier{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '>': {
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.eofError(this);
                    tokeniser.doctypePending.forceQuirks = true;
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                default: {
                    tokeniser.error(this);
                    tokeniser.transition(BogusDoctype);
                }
            }
        }
    }
    ,
    BogusDoctype{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            char c = characterReader.consume();
            switch (c) {
                case '>': {
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
                case '\uffff': {
                    tokeniser.emitDoctypePending();
                    tokeniser.transition(Data);
                    break;
                }
            }
        }
    }
    ,
    CdataSection{

        void read(Tokeniser tokeniser, CharacterReader characterReader) {
            String string = characterReader.consumeTo("]]>");
            tokeniser.emit(string);
            characterReader.matchConsume("]]>");
            tokeniser.transition(Data);
        }
    };

    private static final char nullChar = '\u0000';
    private static final char replacementChar = '\ufffd';
    private static final String replacementStr;
    private static final char eof = '\uffff';

    abstract void read(Tokeniser var1, CharacterReader var2);

    static {
        replacementStr = String.valueOf('\ufffd');
    }
}

