/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jsoup.parser;

import ai.org.jsoup.helper.Validate;
import ai.org.jsoup.nodes.Entities;
import ai.org.jsoup.parser.CharacterReader;
import ai.org.jsoup.parser.ParseError;
import ai.org.jsoup.parser.ParseErrorList;
import ai.org.jsoup.parser.Token;
import ai.org.jsoup.parser.TokeniserState;

class Tokeniser {
    static final char replacementChar = '\ufffd';
    private CharacterReader reader;
    private ParseErrorList errors;
    private TokeniserState state = TokeniserState.Data;
    private Token emitPending;
    private boolean isEmitPending = false;
    private StringBuilder charBuffer = new StringBuilder();
    StringBuilder dataBuffer;
    Token.Tag tagPending;
    Token.Doctype doctypePending;
    Token.Comment commentPending;
    private Token.StartTag lastStartTag;
    private boolean selfClosingFlagAcknowledged = true;

    Tokeniser(CharacterReader characterReader, ParseErrorList parseErrorList) {
        this.reader = characterReader;
        this.errors = parseErrorList;
    }

    Token read() {
        if (!this.selfClosingFlagAcknowledged) {
            this.error("Self closing flag not acknowledged");
            this.selfClosingFlagAcknowledged = true;
        }
        while (!this.isEmitPending) {
            this.state.read(this, this.reader);
        }
        if (this.charBuffer.length() > 0) {
            String string = this.charBuffer.toString();
            this.charBuffer.delete(0, this.charBuffer.length());
            return new Token.Character(string);
        }
        this.isEmitPending = false;
        return this.emitPending;
    }

    void emit(Token token) {
        Validate.isFalse(this.isEmitPending, "There is an unread token pending!");
        this.emitPending = token;
        this.isEmitPending = true;
        if (token.type == Token.TokenType.StartTag) {
            Token.StartTag startTag;
            this.lastStartTag = startTag = (Token.StartTag)token;
            if (startTag.selfClosing) {
                this.selfClosingFlagAcknowledged = false;
            }
        } else if (token.type == Token.TokenType.EndTag) {
            Token.EndTag endTag = (Token.EndTag)token;
            if (endTag.attributes != null) {
                this.error("Attributes incorrectly present on end tag");
            }
        }
    }

    void emit(String string) {
        this.charBuffer.append(string);
    }

    void emit(char[] cArray) {
        this.charBuffer.append(cArray);
    }

    void emit(char c) {
        this.charBuffer.append(c);
    }

    TokeniserState getState() {
        return this.state;
    }

    void transition(TokeniserState tokeniserState) {
        this.state = tokeniserState;
    }

    void advanceTransition(TokeniserState tokeniserState) {
        this.reader.advance();
        this.state = tokeniserState;
    }

    void acknowledgeSelfClosingFlag() {
        this.selfClosingFlagAcknowledged = true;
    }

    char[] consumeCharacterReference(Character c, boolean bl) {
        boolean bl2;
        if (this.reader.isEmpty()) {
            return null;
        }
        if (c != null && c.charValue() == this.reader.current()) {
            return null;
        }
        if (this.reader.matchesAny('\t', '\n', '\r', '\f', ' ', '<', '&')) {
            return null;
        }
        this.reader.mark();
        if (this.reader.matchConsume("#")) {
            String string;
            boolean bl3 = this.reader.matchConsumeIgnoreCase("X");
            String string2 = string = bl3 ? this.reader.consumeHexSequence() : this.reader.consumeDigitSequence();
            if (string.length() == 0) {
                this.characterReferenceError("numeric reference with no numerals");
                this.reader.rewindToMark();
                return null;
            }
            if (!this.reader.matchConsume(";")) {
                this.characterReferenceError("missing semicolon");
            }
            int n = -1;
            try {
                int n2 = bl3 ? 16 : 10;
                n = Integer.valueOf(string, n2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n == -1 || n >= 55296 && n <= 57343 || n > 0x10FFFF) {
                this.characterReferenceError("character outside of valid range");
                return new char[]{'\ufffd'};
            }
            return Character.toChars(n);
        }
        String string = this.reader.consumeLetterThenDigitSequence();
        boolean bl4 = this.reader.matches(';');
        boolean bl5 = bl2 = Entities.isBaseNamedEntity(string) || Entities.isNamedEntity(string) && bl4;
        if (!bl2) {
            this.reader.rewindToMark();
            if (bl4) {
                this.characterReferenceError(String.format("invalid named referenece '%s'", string));
            }
            return null;
        }
        if (bl && (this.reader.matchesLetter() || this.reader.matchesDigit() || this.reader.matchesAny('=', '-', '_'))) {
            this.reader.rewindToMark();
            return null;
        }
        if (!this.reader.matchConsume(";")) {
            this.characterReferenceError("missing semicolon");
        }
        return new char[]{Entities.getCharacterByName(string).charValue()};
    }

    Token.Tag createTagPending(boolean bl) {
        this.tagPending = bl ? new Token.StartTag() : new Token.EndTag();
        return this.tagPending;
    }

    void emitTagPending() {
        this.tagPending.finaliseTag();
        this.emit(this.tagPending);
    }

    void createCommentPending() {
        this.commentPending = new Token.Comment();
    }

    void emitCommentPending() {
        this.emit(this.commentPending);
    }

    void createDoctypePending() {
        this.doctypePending = new Token.Doctype();
    }

    void emitDoctypePending() {
        this.emit(this.doctypePending);
    }

    void createTempBuffer() {
        this.dataBuffer = new StringBuilder();
    }

    boolean isAppropriateEndTagToken() {
        if (this.lastStartTag == null) {
            return false;
        }
        return this.tagPending.tagName.equals(this.lastStartTag.tagName);
    }

    String appropriateEndTagName() {
        return this.lastStartTag.tagName;
    }

    void error(TokeniserState tokeniserState) {
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader.pos(), "Unexpected character '%s' in input state [%s]", new Object[]{Character.valueOf(this.reader.current()), tokeniserState}));
        }
    }

    void eofError(TokeniserState tokeniserState) {
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader.pos(), "Unexpectedly reached end of file (EOF) in input state [%s]", new Object[]{tokeniserState}));
        }
    }

    private void characterReferenceError(String string) {
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader.pos(), "Invalid character reference: %s", string));
        }
    }

    private void error(String string) {
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader.pos(), string));
        }
    }

    boolean currentNodeInHtmlNS() {
        return true;
    }

    String unescapeEntities(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        while (!this.reader.isEmpty()) {
            stringBuilder.append(this.reader.consumeTo('&'));
            if (!this.reader.matches('&')) continue;
            this.reader.consume();
            char[] cArray = this.consumeCharacterReference(null, bl);
            if (cArray == null || cArray.length == 0) {
                stringBuilder.append('&');
                continue;
            }
            stringBuilder.append(cArray);
        }
        return stringBuilder.toString();
    }
}

