/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jsoup.parser;

import ai.org.jsoup.helper.DescendableLinkedList;
import ai.org.jsoup.helper.StringUtil;
import ai.org.jsoup.nodes.Attribute;
import ai.org.jsoup.nodes.Attributes;
import ai.org.jsoup.nodes.Document;
import ai.org.jsoup.nodes.DocumentType;
import ai.org.jsoup.nodes.Element;
import ai.org.jsoup.nodes.Node;
import ai.org.jsoup.parser.HtmlTreeBuilder;
import ai.org.jsoup.parser.Tag;
import ai.org.jsoup.parser.Token;
import ai.org.jsoup.parser.TokeniserState;
import ai.org.jsoup.parser.TreeBuilder;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum HtmlTreeBuilderState {
    Initial{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                return true;
            }
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
            } else if (token.isDoctype()) {
                Token.Doctype doctype = token.asDoctype();
                DocumentType documentType = new DocumentType(doctype.getName(), doctype.getPublicIdentifier(), doctype.getSystemIdentifier(), htmlTreeBuilder.getBaseUri());
                htmlTreeBuilder.getDocument().appendChild(documentType);
                if (doctype.isForceQuirks()) {
                    htmlTreeBuilder.getDocument().quirksMode(Document.QuirksMode.quirks);
                }
                htmlTreeBuilder.transition(BeforeHtml);
            } else {
                htmlTreeBuilder.transition(BeforeHtml);
                return htmlTreeBuilder.process(token);
            }
            return true;
        }
    }
    ,
    BeforeHtml{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isDoctype()) {
                htmlTreeBuilder.error(this);
                return false;
            }
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
            } else {
                if (HtmlTreeBuilderState.isWhitespace(token)) {
                    return true;
                }
                if (token.isStartTag() && token.asStartTag().name().equals("html")) {
                    htmlTreeBuilder.insert(token.asStartTag());
                    htmlTreeBuilder.transition(BeforeHead);
                } else {
                    if (token.isEndTag() && StringUtil.in(token.asEndTag().name(), "head", "body", "html", "br")) {
                        return this.anythingElse(token, htmlTreeBuilder);
                    }
                    if (token.isEndTag()) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
            }
            return true;
        }

        private boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            htmlTreeBuilder.insert("html");
            htmlTreeBuilder.transition(BeforeHead);
            return htmlTreeBuilder.process(token);
        }
    }
    ,
    BeforeHead{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                return true;
            }
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
            } else {
                if (token.isDoctype()) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                if (token.isStartTag() && token.asStartTag().name().equals("html")) {
                    return InBody.process(token, htmlTreeBuilder);
                }
                if (token.isStartTag() && token.asStartTag().name().equals("head")) {
                    Element element = htmlTreeBuilder.insert(token.asStartTag());
                    htmlTreeBuilder.setHeadElement(element);
                    htmlTreeBuilder.transition(InHead);
                } else {
                    if (token.isEndTag() && StringUtil.in(token.asEndTag().name(), "head", "body", "html", "br")) {
                        htmlTreeBuilder.process(new Token.StartTag("head"));
                        return htmlTreeBuilder.process(token);
                    }
                    if (token.isEndTag()) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    htmlTreeBuilder.process(new Token.StartTag("head"));
                    return htmlTreeBuilder.process(token);
                }
            }
            return true;
        }
    }
    ,
    InHead{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                htmlTreeBuilder.insert(token.asCharacter());
                return true;
            }
            switch (token.type) {
                case Comment: {
                    htmlTreeBuilder.insert(token.asComment());
                    break;
                }
                case Doctype: {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                case StartTag: {
                    Token.StartTag startTag = token.asStartTag();
                    String string = startTag.name();
                    if (string.equals("html")) {
                        return InBody.process(token, htmlTreeBuilder);
                    }
                    if (StringUtil.in(string, "base", "basefont", "bgsound", "command", "link")) {
                        Element element = htmlTreeBuilder.insertEmpty(startTag);
                        if (!string.equals("base") || !element.hasAttr("href")) break;
                        htmlTreeBuilder.maybeSetBaseUri(element);
                        break;
                    }
                    if (string.equals("meta")) {
                        Element element = htmlTreeBuilder.insertEmpty(startTag);
                        break;
                    }
                    if (string.equals("title")) {
                        HtmlTreeBuilderState.handleRcData(startTag, htmlTreeBuilder);
                        break;
                    }
                    if (StringUtil.in(string, "noframes", "style")) {
                        HtmlTreeBuilderState.handleRawtext(startTag, htmlTreeBuilder);
                        break;
                    }
                    if (string.equals("noscript")) {
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.transition(InHeadNoscript);
                        break;
                    }
                    if (string.equals("script")) {
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.tokeniser.transition(TokeniserState.ScriptData);
                        htmlTreeBuilder.markInsertionMode();
                        htmlTreeBuilder.transition(Text);
                        break;
                    }
                    if (string.equals("head")) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                case EndTag: {
                    Token.EndTag endTag = token.asEndTag();
                    String string = endTag.name();
                    if (string.equals("head")) {
                        htmlTreeBuilder.pop();
                        htmlTreeBuilder.transition(AfterHead);
                        break;
                    }
                    if (StringUtil.in(string, "body", "html", "br")) {
                        return this.anythingElse(token, htmlTreeBuilder);
                    }
                    htmlTreeBuilder.error(this);
                    return false;
                }
                default: {
                    return this.anythingElse(token, htmlTreeBuilder);
                }
            }
            return true;
        }

        private boolean anythingElse(Token token, TreeBuilder treeBuilder) {
            treeBuilder.process(new Token.EndTag("head"));
            return treeBuilder.process(token);
        }
    }
    ,
    InHeadNoscript{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isDoctype()) {
                htmlTreeBuilder.error(this);
            } else {
                if (token.isStartTag() && token.asStartTag().name().equals("html")) {
                    return htmlTreeBuilder.process(token, InBody);
                }
                if (token.isEndTag() && token.asEndTag().name().equals("noscript")) {
                    htmlTreeBuilder.pop();
                    htmlTreeBuilder.transition(InHead);
                } else {
                    if (HtmlTreeBuilderState.isWhitespace(token) || token.isComment() || token.isStartTag() && StringUtil.in(token.asStartTag().name(), "basefont", "bgsound", "link", "meta", "noframes", "style")) {
                        return htmlTreeBuilder.process(token, InHead);
                    }
                    if (token.isEndTag() && token.asEndTag().name().equals("br")) {
                        return this.anythingElse(token, htmlTreeBuilder);
                    }
                    if (token.isStartTag() && StringUtil.in(token.asStartTag().name(), "head", "noscript") || token.isEndTag()) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
            }
            return true;
        }

        private boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            htmlTreeBuilder.error(this);
            htmlTreeBuilder.process(new Token.EndTag("noscript"));
            return htmlTreeBuilder.process(token);
        }
    }
    ,
    AfterHead{

        /*
         * Enabled aggressive block sorting
         */
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                htmlTreeBuilder.insert(token.asCharacter());
                return true;
            }
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
                return true;
            }
            if (token.isDoctype()) {
                htmlTreeBuilder.error(this);
                return true;
            }
            if (token.isStartTag()) {
                Token.StartTag startTag = token.asStartTag();
                String string = startTag.name();
                if (string.equals("html")) {
                    return htmlTreeBuilder.process(token, InBody);
                }
                if (string.equals("body")) {
                    htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.framesetOk(false);
                    htmlTreeBuilder.transition(InBody);
                    return true;
                }
                if (string.equals("frameset")) {
                    htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.transition(InFrameset);
                    return true;
                }
                if (StringUtil.in(string, "base", "basefont", "bgsound", "link", "meta", "noframes", "script", "style", "title")) {
                    htmlTreeBuilder.error(this);
                    Element element = htmlTreeBuilder.getHeadElement();
                    htmlTreeBuilder.push(element);
                    htmlTreeBuilder.process(token, InHead);
                    htmlTreeBuilder.removeFromStack(element);
                    return true;
                }
                if (string.equals("head")) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                this.anythingElse(token, htmlTreeBuilder);
                return true;
            }
            if (!token.isEndTag()) {
                this.anythingElse(token, htmlTreeBuilder);
                return true;
            }
            if (StringUtil.in(token.asEndTag().name(), "body", "html")) {
                this.anythingElse(token, htmlTreeBuilder);
                return true;
            }
            htmlTreeBuilder.error(this);
            return false;
        }

        private boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            htmlTreeBuilder.process(new Token.StartTag("body"));
            htmlTreeBuilder.framesetOk(true);
            return htmlTreeBuilder.process(token);
        }
    }
    ,
    InBody{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            switch (token.type) {
                case Character: {
                    Token.Character character = token.asCharacter();
                    if (character.getData().equals(nullString)) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    if (HtmlTreeBuilderState.isWhitespace(character)) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        htmlTreeBuilder.insert(character);
                        break;
                    }
                    htmlTreeBuilder.reconstructFormattingElements();
                    htmlTreeBuilder.insert(character);
                    htmlTreeBuilder.framesetOk(false);
                    break;
                }
                case Comment: {
                    htmlTreeBuilder.insert(token.asComment());
                    break;
                }
                case Doctype: {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                case StartTag: {
                    Token.StartTag startTag = token.asStartTag();
                    String string = startTag.name();
                    if (string.equals("html")) {
                        htmlTreeBuilder.error(this);
                        Element element = (Element)htmlTreeBuilder.getStack().getFirst();
                        for (Attribute attribute : startTag.getAttributes()) {
                            if (element.hasAttr(attribute.getKey())) continue;
                            element.attributes().put(attribute);
                        }
                        break;
                    }
                    if (StringUtil.in(string, "base", "basefont", "bgsound", "command", "link", "meta", "noframes", "script", "style", "title")) {
                        return htmlTreeBuilder.process(token, InHead);
                    }
                    if (string.equals("body")) {
                        htmlTreeBuilder.error(this);
                        DescendableLinkedList<Element> descendableLinkedList = htmlTreeBuilder.getStack();
                        if (descendableLinkedList.size() == 1 || descendableLinkedList.size() > 2 && !((Element)descendableLinkedList.get(1)).nodeName().equals("body")) {
                            return false;
                        }
                        htmlTreeBuilder.framesetOk(false);
                        Element element = (Element)descendableLinkedList.get(1);
                        for (Attribute attribute : startTag.getAttributes()) {
                            if (element.hasAttr(attribute.getKey())) continue;
                            element.attributes().put(attribute);
                        }
                        break;
                    }
                    if (string.equals("frameset")) {
                        htmlTreeBuilder.error(this);
                        DescendableLinkedList<Element> descendableLinkedList = htmlTreeBuilder.getStack();
                        if (descendableLinkedList.size() == 1 || descendableLinkedList.size() > 2 && !((Element)descendableLinkedList.get(1)).nodeName().equals("body")) {
                            return false;
                        }
                        if (!htmlTreeBuilder.framesetOk()) {
                            return false;
                        }
                        Element element = (Element)descendableLinkedList.get(1);
                        if (element.parent() != null) {
                            element.remove();
                        }
                        while (descendableLinkedList.size() > 1) {
                            descendableLinkedList.removeLast();
                        }
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.transition(InFrameset);
                        break;
                    }
                    if (StringUtil.in(string, "address", "article", "aside", "blockquote", "center", "details", "dir", "div", "dl", "fieldset", "figcaption", "figure", "footer", "header", "hgroup", "menu", "nav", "ol", "p", "section", "summary", "ul")) {
                        if (htmlTreeBuilder.inButtonScope("p")) {
                            htmlTreeBuilder.process(new Token.EndTag("p"));
                        }
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (StringUtil.in(string, "h1", "h2", "h3", "h4", "h5", "h6")) {
                        if (htmlTreeBuilder.inButtonScope("p")) {
                            htmlTreeBuilder.process(new Token.EndTag("p"));
                        }
                        if (StringUtil.in(htmlTreeBuilder.currentElement().nodeName(), "h1", "h2", "h3", "h4", "h5", "h6")) {
                            htmlTreeBuilder.error(this);
                            htmlTreeBuilder.pop();
                        }
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (StringUtil.in(string, "pre", "listing")) {
                        if (htmlTreeBuilder.inButtonScope("p")) {
                            htmlTreeBuilder.process(new Token.EndTag("p"));
                        }
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.framesetOk(false);
                        break;
                    }
                    if (string.equals("form")) {
                        if (htmlTreeBuilder.getFormElement() != null) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        if (htmlTreeBuilder.inButtonScope("p")) {
                            htmlTreeBuilder.process(new Token.EndTag("p"));
                        }
                        Element element = htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.setFormElement(element);
                        break;
                    }
                    if (string.equals("li")) {
                        htmlTreeBuilder.framesetOk(false);
                        DescendableLinkedList<Element> descendableLinkedList = htmlTreeBuilder.getStack();
                        for (int i = descendableLinkedList.size() - 1; i > 0; --i) {
                            Element element = (Element)descendableLinkedList.get(i);
                            if (element.nodeName().equals("li")) {
                                htmlTreeBuilder.process(new Token.EndTag("li"));
                                break;
                            }
                            if (htmlTreeBuilder.isSpecial(element) && !StringUtil.in(element.nodeName(), "address", "div", "p")) break;
                        }
                        if (htmlTreeBuilder.inButtonScope("p")) {
                            htmlTreeBuilder.process(new Token.EndTag("p"));
                        }
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (StringUtil.in(string, "dd", "dt")) {
                        htmlTreeBuilder.framesetOk(false);
                        DescendableLinkedList<Element> descendableLinkedList = htmlTreeBuilder.getStack();
                        for (int i = descendableLinkedList.size() - 1; i > 0; --i) {
                            Element element = (Element)descendableLinkedList.get(i);
                            if (StringUtil.in(element.nodeName(), "dd", "dt")) {
                                htmlTreeBuilder.process(new Token.EndTag(element.nodeName()));
                                break;
                            }
                            if (htmlTreeBuilder.isSpecial(element) && !StringUtil.in(element.nodeName(), "address", "div", "p")) break;
                        }
                        if (htmlTreeBuilder.inButtonScope("p")) {
                            htmlTreeBuilder.process(new Token.EndTag("p"));
                        }
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (string.equals("plaintext")) {
                        if (htmlTreeBuilder.inButtonScope("p")) {
                            htmlTreeBuilder.process(new Token.EndTag("p"));
                        }
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.tokeniser.transition(TokeniserState.PLAINTEXT);
                        break;
                    }
                    if (string.equals("button")) {
                        if (htmlTreeBuilder.inButtonScope("button")) {
                            htmlTreeBuilder.error(this);
                            htmlTreeBuilder.process(new Token.EndTag("button"));
                            htmlTreeBuilder.process(startTag);
                            break;
                        }
                        htmlTreeBuilder.reconstructFormattingElements();
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.framesetOk(false);
                        break;
                    }
                    if (string.equals("a")) {
                        Element element;
                        if (htmlTreeBuilder.getActiveFormattingElement("a") != null) {
                            htmlTreeBuilder.error(this);
                            htmlTreeBuilder.process(new Token.EndTag("a"));
                            element = htmlTreeBuilder.getFromStack("a");
                            if (element != null) {
                                htmlTreeBuilder.removeFromActiveFormattingElements(element);
                                htmlTreeBuilder.removeFromStack(element);
                            }
                        }
                        htmlTreeBuilder.reconstructFormattingElements();
                        element = htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.pushActiveFormattingElements(element);
                        break;
                    }
                    if (StringUtil.in(string, "b", "big", "code", "em", "font", "i", "s", "small", "strike", "strong", "tt", "u")) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        Element element = htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.pushActiveFormattingElements(element);
                        break;
                    }
                    if (string.equals("nobr")) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        if (htmlTreeBuilder.inScope("nobr")) {
                            htmlTreeBuilder.error(this);
                            htmlTreeBuilder.process(new Token.EndTag("nobr"));
                            htmlTreeBuilder.reconstructFormattingElements();
                        }
                        Element element = htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.pushActiveFormattingElements(element);
                        break;
                    }
                    if (StringUtil.in(string, "applet", "marquee", "object")) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.insertMarkerToFormattingElements();
                        htmlTreeBuilder.framesetOk(false);
                        break;
                    }
                    if (string.equals("table")) {
                        if (htmlTreeBuilder.getDocument().quirksMode() != Document.QuirksMode.quirks && htmlTreeBuilder.inButtonScope("p")) {
                            htmlTreeBuilder.process(new Token.EndTag("p"));
                        }
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.framesetOk(false);
                        htmlTreeBuilder.transition(InTable);
                        break;
                    }
                    if (StringUtil.in(string, "area", "br", "embed", "img", "keygen", "wbr")) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        htmlTreeBuilder.insertEmpty(startTag);
                        htmlTreeBuilder.framesetOk(false);
                        break;
                    }
                    if (string.equals("input")) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        Element element = htmlTreeBuilder.insertEmpty(startTag);
                        if (element.attr("type").equalsIgnoreCase("hidden")) break;
                        htmlTreeBuilder.framesetOk(false);
                        break;
                    }
                    if (StringUtil.in(string, "param", "source", "track")) {
                        htmlTreeBuilder.insertEmpty(startTag);
                        break;
                    }
                    if (string.equals("hr")) {
                        if (htmlTreeBuilder.inButtonScope("p")) {
                            htmlTreeBuilder.process(new Token.EndTag("p"));
                        }
                        htmlTreeBuilder.insertEmpty(startTag);
                        htmlTreeBuilder.framesetOk(false);
                        break;
                    }
                    if (string.equals("image")) {
                        startTag.name("img");
                        return htmlTreeBuilder.process(startTag);
                    }
                    if (string.equals("isindex")) {
                        Object object;
                        htmlTreeBuilder.error(this);
                        if (htmlTreeBuilder.getFormElement() != null) {
                            return false;
                        }
                        htmlTreeBuilder.tokeniser.acknowledgeSelfClosingFlag();
                        htmlTreeBuilder.process(new Token.StartTag("form"));
                        if (startTag.attributes.hasKey("action")) {
                            object = htmlTreeBuilder.getFormElement();
                            ((Element)object).attr("action", startTag.attributes.get("action"));
                        }
                        htmlTreeBuilder.process(new Token.StartTag("hr"));
                        htmlTreeBuilder.process(new Token.StartTag("label"));
                        object = startTag.attributes.hasKey("prompt") ? startTag.attributes.get("prompt") : "This is a searchable index. Enter search keywords: ";
                        htmlTreeBuilder.process(new Token.Character((String)object));
                        Attributes attributes = new Attributes();
                        for (Attribute attribute : startTag.attributes) {
                            if (StringUtil.in(attribute.getKey(), "name", "action", "prompt")) continue;
                            attributes.put(attribute);
                        }
                        attributes.put("name", "isindex");
                        htmlTreeBuilder.process(new Token.StartTag("input", attributes));
                        htmlTreeBuilder.process(new Token.EndTag("label"));
                        htmlTreeBuilder.process(new Token.StartTag("hr"));
                        htmlTreeBuilder.process(new Token.EndTag("form"));
                        break;
                    }
                    if (string.equals("textarea")) {
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.tokeniser.transition(TokeniserState.Rcdata);
                        htmlTreeBuilder.markInsertionMode();
                        htmlTreeBuilder.framesetOk(false);
                        htmlTreeBuilder.transition(Text);
                        break;
                    }
                    if (string.equals("xmp")) {
                        if (htmlTreeBuilder.inButtonScope("p")) {
                            htmlTreeBuilder.process(new Token.EndTag("p"));
                        }
                        htmlTreeBuilder.reconstructFormattingElements();
                        htmlTreeBuilder.framesetOk(false);
                        HtmlTreeBuilderState.handleRawtext(startTag, htmlTreeBuilder);
                        break;
                    }
                    if (string.equals("iframe")) {
                        htmlTreeBuilder.framesetOk(false);
                        HtmlTreeBuilderState.handleRawtext(startTag, htmlTreeBuilder);
                        break;
                    }
                    if (string.equals("noembed")) {
                        HtmlTreeBuilderState.handleRawtext(startTag, htmlTreeBuilder);
                        break;
                    }
                    if (string.equals("select")) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.framesetOk(false);
                        HtmlTreeBuilderState htmlTreeBuilderState = htmlTreeBuilder.state();
                        if (htmlTreeBuilderState.equals((Object)InTable) || htmlTreeBuilderState.equals((Object)InCaption) || htmlTreeBuilderState.equals((Object)InTableBody) || htmlTreeBuilderState.equals((Object)InRow) || htmlTreeBuilderState.equals((Object)InCell)) {
                            htmlTreeBuilder.transition(InSelectInTable);
                            break;
                        }
                        htmlTreeBuilder.transition(InSelect);
                        break;
                    }
                    if (StringUtil.in("optgroup", "option")) {
                        if (htmlTreeBuilder.currentElement().nodeName().equals("option")) {
                            htmlTreeBuilder.process(new Token.EndTag("option"));
                        }
                        htmlTreeBuilder.reconstructFormattingElements();
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (StringUtil.in("rp", "rt")) {
                        if (!htmlTreeBuilder.inScope("ruby")) break;
                        htmlTreeBuilder.generateImpliedEndTags();
                        if (!htmlTreeBuilder.currentElement().nodeName().equals("ruby")) {
                            htmlTreeBuilder.error(this);
                            htmlTreeBuilder.popStackToBefore("ruby");
                        }
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (string.equals("math")) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.tokeniser.acknowledgeSelfClosingFlag();
                        break;
                    }
                    if (string.equals("svg")) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.tokeniser.acknowledgeSelfClosingFlag();
                        break;
                    }
                    if (StringUtil.in(string, "caption", "col", "colgroup", "frame", "head", "tbody", "td", "tfoot", "th", "thead", "tr")) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    htmlTreeBuilder.reconstructFormattingElements();
                    htmlTreeBuilder.insert(startTag);
                    break;
                }
                case EndTag: {
                    Token.EndTag endTag = token.asEndTag();
                    String string = endTag.name();
                    if (string.equals("body")) {
                        if (!htmlTreeBuilder.inScope("body")) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.transition(AfterBody);
                        break;
                    }
                    if (string.equals("html")) {
                        boolean bl = htmlTreeBuilder.process(new Token.EndTag("body"));
                        if (!bl) break;
                        return htmlTreeBuilder.process(endTag);
                    }
                    if (StringUtil.in(string, "address", "article", "aside", "blockquote", "button", "center", "details", "dir", "div", "dl", "fieldset", "figcaption", "figure", "footer", "header", "hgroup", "listing", "menu", "nav", "ol", "pre", "section", "summary", "ul")) {
                        if (!htmlTreeBuilder.inScope(string)) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.generateImpliedEndTags();
                        if (!htmlTreeBuilder.currentElement().nodeName().equals(string)) {
                            htmlTreeBuilder.error(this);
                        }
                        htmlTreeBuilder.popStackToClose(string);
                        break;
                    }
                    if (string.equals("form")) {
                        Element element = htmlTreeBuilder.getFormElement();
                        htmlTreeBuilder.setFormElement(null);
                        if (element == null || !htmlTreeBuilder.inScope(string)) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.generateImpliedEndTags();
                        if (!htmlTreeBuilder.currentElement().nodeName().equals(string)) {
                            htmlTreeBuilder.error(this);
                        }
                        htmlTreeBuilder.removeFromStack(element);
                        break;
                    }
                    if (string.equals("p")) {
                        if (!htmlTreeBuilder.inButtonScope(string)) {
                            htmlTreeBuilder.error(this);
                            htmlTreeBuilder.process(new Token.StartTag(string));
                            return htmlTreeBuilder.process(endTag);
                        }
                        htmlTreeBuilder.generateImpliedEndTags(string);
                        if (!htmlTreeBuilder.currentElement().nodeName().equals(string)) {
                            htmlTreeBuilder.error(this);
                        }
                        htmlTreeBuilder.popStackToClose(string);
                        break;
                    }
                    if (string.equals("li")) {
                        if (!htmlTreeBuilder.inListItemScope(string)) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.generateImpliedEndTags(string);
                        if (!htmlTreeBuilder.currentElement().nodeName().equals(string)) {
                            htmlTreeBuilder.error(this);
                        }
                        htmlTreeBuilder.popStackToClose(string);
                        break;
                    }
                    if (StringUtil.in(string, "dd", "dt")) {
                        if (!htmlTreeBuilder.inScope(string)) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.generateImpliedEndTags(string);
                        if (!htmlTreeBuilder.currentElement().nodeName().equals(string)) {
                            htmlTreeBuilder.error(this);
                        }
                        htmlTreeBuilder.popStackToClose(string);
                        break;
                    }
                    if (StringUtil.in(string, "h1", "h2", "h3", "h4", "h5", "h6")) {
                        if (!htmlTreeBuilder.inScope(new String[]{"h1", "h2", "h3", "h4", "h5", "h6"})) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.generateImpliedEndTags(string);
                        if (!htmlTreeBuilder.currentElement().nodeName().equals(string)) {
                            htmlTreeBuilder.error(this);
                        }
                        htmlTreeBuilder.popStackToClose("h1", "h2", "h3", "h4", "h5", "h6");
                        break;
                    }
                    if (string.equals("sarcasm")) {
                        return this.anyOtherEndTag(token, htmlTreeBuilder);
                    }
                    if (StringUtil.in(string, "a", "b", "big", "code", "em", "font", "i", "nobr", "s", "small", "strike", "strong", "tt", "u")) {
                        for (int i = 0; i < 8; ++i) {
                            Node[] nodeArray;
                            Element element;
                            Element element2 = htmlTreeBuilder.getActiveFormattingElement(string);
                            if (element2 == null) {
                                return this.anyOtherEndTag(token, htmlTreeBuilder);
                            }
                            if (!htmlTreeBuilder.onStack(element2)) {
                                htmlTreeBuilder.error(this);
                                htmlTreeBuilder.removeFromActiveFormattingElements(element2);
                                return true;
                            }
                            if (!htmlTreeBuilder.inScope(element2.nodeName())) {
                                htmlTreeBuilder.error(this);
                                return false;
                            }
                            if (htmlTreeBuilder.currentElement() != element2) {
                                htmlTreeBuilder.error(this);
                            }
                            Element element3 = null;
                            Element element4 = null;
                            boolean bl = false;
                            DescendableLinkedList<Element> descendableLinkedList = htmlTreeBuilder.getStack();
                            for (int j = 0; j < descendableLinkedList.size() && j < 64; ++j) {
                                element = (Element)descendableLinkedList.get(j);
                                if (element == element2) {
                                    element4 = (Element)descendableLinkedList.get(j - 1);
                                    bl = true;
                                    continue;
                                }
                                if (!bl || !htmlTreeBuilder.isSpecial(element)) continue;
                                element3 = element;
                                break;
                            }
                            if (element3 == null) {
                                htmlTreeBuilder.popStackToClose(element2.nodeName());
                                htmlTreeBuilder.removeFromActiveFormattingElements(element2);
                                return true;
                            }
                            Element element5 = element3;
                            element = element3;
                            for (int j = 0; j < 3; ++j) {
                                if (htmlTreeBuilder.onStack(element5)) {
                                    element5 = htmlTreeBuilder.aboveOnStack(element5);
                                }
                                if (!htmlTreeBuilder.isInActiveFormattingElements(element5)) {
                                    htmlTreeBuilder.removeFromStack(element5);
                                    continue;
                                }
                                if (element5 == element2) break;
                                nodeArray = new Element(Tag.valueOf(element5.nodeName()), htmlTreeBuilder.getBaseUri());
                                htmlTreeBuilder.replaceActiveFormattingElement(element5, (Element)nodeArray);
                                htmlTreeBuilder.replaceOnStack(element5, (Element)nodeArray);
                                element5 = nodeArray;
                                if (element == element3) {
                                    // empty if block
                                }
                                if (element.parent() != null) {
                                    element.remove();
                                }
                                element5.appendChild(element);
                                element = element5;
                            }
                            if (StringUtil.in(element4.nodeName(), "table", "tbody", "tfoot", "thead", "tr")) {
                                if (element.parent() != null) {
                                    element.remove();
                                }
                                htmlTreeBuilder.insertInFosterParent(element);
                            } else {
                                if (element.parent() != null) {
                                    element.remove();
                                }
                                element4.appendChild(element);
                            }
                            Element element6 = new Element(Tag.valueOf(string), htmlTreeBuilder.getBaseUri());
                            for (Node node : nodeArray = element3.childNodes().toArray(new Node[element3.childNodeSize()])) {
                                element6.appendChild(node);
                            }
                            element3.appendChild(element6);
                            htmlTreeBuilder.removeFromActiveFormattingElements(element2);
                            htmlTreeBuilder.removeFromStack(element2);
                            htmlTreeBuilder.insertOnStackAfter(element3, element6);
                        }
                        break;
                    }
                    if (StringUtil.in(string, "applet", "marquee", "object")) {
                        if (htmlTreeBuilder.inScope("name")) break;
                        if (!htmlTreeBuilder.inScope(string)) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.generateImpliedEndTags();
                        if (!htmlTreeBuilder.currentElement().nodeName().equals(string)) {
                            htmlTreeBuilder.error(this);
                        }
                        htmlTreeBuilder.popStackToClose(string);
                        htmlTreeBuilder.clearFormattingElementsToLastMarker();
                        break;
                    }
                    if (string.equals("br")) {
                        htmlTreeBuilder.error(this);
                        htmlTreeBuilder.process(new Token.StartTag("br"));
                        return false;
                    }
                    return this.anyOtherEndTag(token, htmlTreeBuilder);
                }
            }
            return true;
        }

        boolean anyOtherEndTag(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            String string = token.asEndTag().name();
            DescendableLinkedList<Element> descendableLinkedList = htmlTreeBuilder.getStack();
            Iterator<Element> iterator = descendableLinkedList.descendingIterator();
            while (iterator.hasNext()) {
                Element element = iterator.next();
                if (element.nodeName().equals(string)) {
                    htmlTreeBuilder.generateImpliedEndTags(string);
                    if (!string.equals(htmlTreeBuilder.currentElement().nodeName())) {
                        htmlTreeBuilder.error(this);
                    }
                    htmlTreeBuilder.popStackToClose(string);
                    break;
                }
                if (!htmlTreeBuilder.isSpecial(element)) continue;
                htmlTreeBuilder.error(this);
                return false;
            }
            return true;
        }
    }
    ,
    Text{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isCharacter()) {
                htmlTreeBuilder.insert(token.asCharacter());
            } else {
                if (token.isEOF()) {
                    htmlTreeBuilder.error(this);
                    htmlTreeBuilder.pop();
                    htmlTreeBuilder.transition(htmlTreeBuilder.originalState());
                    return htmlTreeBuilder.process(token);
                }
                if (token.isEndTag()) {
                    htmlTreeBuilder.pop();
                    htmlTreeBuilder.transition(htmlTreeBuilder.originalState());
                }
            }
            return true;
        }
    }
    ,
    InTable{

        /*
         * Enabled aggressive block sorting
         */
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isCharacter()) {
                htmlTreeBuilder.newPendingTableCharacters();
                htmlTreeBuilder.markInsertionMode();
                htmlTreeBuilder.transition(InTableText);
                return htmlTreeBuilder.process(token);
            }
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
                return true;
            }
            if (token.isDoctype()) {
                htmlTreeBuilder.error(this);
                return false;
            }
            if (token.isStartTag()) {
                Token.StartTag startTag = token.asStartTag();
                String string = startTag.name();
                if (string.equals("caption")) {
                    htmlTreeBuilder.clearStackToTableContext();
                    htmlTreeBuilder.insertMarkerToFormattingElements();
                    htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.transition(InCaption);
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                if (string.equals("colgroup")) {
                    htmlTreeBuilder.clearStackToTableContext();
                    htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.transition(InColumnGroup);
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                if (string.equals("col")) {
                    htmlTreeBuilder.process(new Token.StartTag("colgroup"));
                    return htmlTreeBuilder.process(token);
                }
                if (StringUtil.in(string, "tbody", "tfoot", "thead")) {
                    htmlTreeBuilder.clearStackToTableContext();
                    htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.transition(InTableBody);
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                if (StringUtil.in(string, "td", "th", "tr")) {
                    htmlTreeBuilder.process(new Token.StartTag("tbody"));
                    return htmlTreeBuilder.process(token);
                }
                if (string.equals("table")) {
                    htmlTreeBuilder.error(this);
                    boolean bl = htmlTreeBuilder.process(new Token.EndTag("table"));
                    if (!bl) return this.anythingElse(token, htmlTreeBuilder);
                    return htmlTreeBuilder.process(token);
                }
                if (StringUtil.in(string, "style", "script")) {
                    return htmlTreeBuilder.process(token, InHead);
                }
                if (string.equals("input")) {
                    if (!startTag.attributes.get("type").equalsIgnoreCase("hidden")) {
                        return this.anythingElse(token, htmlTreeBuilder);
                    }
                    htmlTreeBuilder.insertEmpty(startTag);
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                if (!string.equals("form")) return this.anythingElse(token, htmlTreeBuilder);
                htmlTreeBuilder.error(this);
                if (htmlTreeBuilder.getFormElement() != null) {
                    return false;
                }
                Element element = htmlTreeBuilder.insertEmpty(startTag);
                htmlTreeBuilder.setFormElement(element);
                return this.anythingElse(token, htmlTreeBuilder);
            }
            if (!token.isEndTag()) {
                if (!token.isEOF()) return this.anythingElse(token, htmlTreeBuilder);
                if (!htmlTreeBuilder.currentElement().nodeName().equals("html")) return true;
                htmlTreeBuilder.error(this);
                return true;
            }
            Token.EndTag endTag = token.asEndTag();
            String string = endTag.name();
            if (!string.equals("table")) {
                if (!StringUtil.in(string, "body", "caption", "col", "colgroup", "html", "tbody", "td", "tfoot", "th", "thead", "tr")) return this.anythingElse(token, htmlTreeBuilder);
                htmlTreeBuilder.error(this);
                return false;
            }
            if (!htmlTreeBuilder.inTableScope(string)) {
                htmlTreeBuilder.error(this);
                return false;
            }
            htmlTreeBuilder.popStackToClose("table");
            htmlTreeBuilder.resetInsertionMode();
            return this.anythingElse(token, htmlTreeBuilder);
        }

        boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            htmlTreeBuilder.error(this);
            boolean bl = true;
            if (StringUtil.in(htmlTreeBuilder.currentElement().nodeName(), "table", "tbody", "tfoot", "thead", "tr")) {
                htmlTreeBuilder.setFosterInserts(true);
                bl = htmlTreeBuilder.process(token, InBody);
                htmlTreeBuilder.setFosterInserts(false);
            } else {
                bl = htmlTreeBuilder.process(token, InBody);
            }
            return bl;
        }
    }
    ,
    InTableText{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            switch (token.type) {
                case Character: {
                    Token.Character character = token.asCharacter();
                    if (character.getData().equals(nullString)) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    htmlTreeBuilder.getPendingTableCharacters().add(character);
                    break;
                }
                default: {
                    if (htmlTreeBuilder.getPendingTableCharacters().size() > 0) {
                        for (Token.Character character : htmlTreeBuilder.getPendingTableCharacters()) {
                            if (!HtmlTreeBuilderState.isWhitespace(character)) {
                                htmlTreeBuilder.error(this);
                                if (StringUtil.in(htmlTreeBuilder.currentElement().nodeName(), "table", "tbody", "tfoot", "thead", "tr")) {
                                    htmlTreeBuilder.setFosterInserts(true);
                                    htmlTreeBuilder.process(character, InBody);
                                    htmlTreeBuilder.setFosterInserts(false);
                                    continue;
                                }
                                htmlTreeBuilder.process(character, InBody);
                                continue;
                            }
                            htmlTreeBuilder.insert(character);
                        }
                        htmlTreeBuilder.newPendingTableCharacters();
                    }
                    htmlTreeBuilder.transition(htmlTreeBuilder.originalState());
                    return htmlTreeBuilder.process(token);
                }
            }
            return true;
        }
    }
    ,
    InCaption{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isEndTag() && token.asEndTag().name().equals("caption")) {
                Token.EndTag endTag = token.asEndTag();
                String string = endTag.name();
                if (!htmlTreeBuilder.inTableScope(string)) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                htmlTreeBuilder.generateImpliedEndTags();
                if (!htmlTreeBuilder.currentElement().nodeName().equals("caption")) {
                    htmlTreeBuilder.error(this);
                }
                htmlTreeBuilder.popStackToClose("caption");
                htmlTreeBuilder.clearFormattingElementsToLastMarker();
                htmlTreeBuilder.transition(InTable);
            } else if (token.isStartTag() && StringUtil.in(token.asStartTag().name(), "caption", "col", "colgroup", "tbody", "td", "tfoot", "th", "thead", "tr") || token.isEndTag() && token.asEndTag().name().equals("table")) {
                htmlTreeBuilder.error(this);
                boolean bl = htmlTreeBuilder.process(new Token.EndTag("caption"));
                if (bl) {
                    return htmlTreeBuilder.process(token);
                }
            } else {
                if (token.isEndTag() && StringUtil.in(token.asEndTag().name(), "body", "col", "colgroup", "html", "tbody", "td", "tfoot", "th", "thead", "tr")) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                return htmlTreeBuilder.process(token, InBody);
            }
            return true;
        }
    }
    ,
    InColumnGroup{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                htmlTreeBuilder.insert(token.asCharacter());
                return true;
            }
            switch (token.type) {
                case Comment: {
                    htmlTreeBuilder.insert(token.asComment());
                    break;
                }
                case Doctype: {
                    htmlTreeBuilder.error(this);
                    break;
                }
                case StartTag: {
                    Token.StartTag startTag = token.asStartTag();
                    String string = startTag.name();
                    if (string.equals("html")) {
                        return htmlTreeBuilder.process(token, InBody);
                    }
                    if (string.equals("col")) {
                        htmlTreeBuilder.insertEmpty(startTag);
                        break;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                case EndTag: {
                    Token.EndTag endTag = token.asEndTag();
                    String string = endTag.name();
                    if (string.equals("colgroup")) {
                        if (htmlTreeBuilder.currentElement().nodeName().equals("html")) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.pop();
                        htmlTreeBuilder.transition(InTable);
                        break;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                case EOF: {
                    if (htmlTreeBuilder.currentElement().nodeName().equals("html")) {
                        return true;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                default: {
                    return this.anythingElse(token, htmlTreeBuilder);
                }
            }
            return true;
        }

        private boolean anythingElse(Token token, TreeBuilder treeBuilder) {
            boolean bl = treeBuilder.process(new Token.EndTag("colgroup"));
            if (bl) {
                return treeBuilder.process(token);
            }
            return true;
        }
    }
    ,
    InTableBody{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            switch (token.type) {
                case StartTag: {
                    Token.StartTag startTag = token.asStartTag();
                    String string = startTag.name();
                    if (string.equals("tr")) {
                        htmlTreeBuilder.clearStackToTableBodyContext();
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.transition(InRow);
                        break;
                    }
                    if (StringUtil.in(string, "th", "td")) {
                        htmlTreeBuilder.error(this);
                        htmlTreeBuilder.process(new Token.StartTag("tr"));
                        return htmlTreeBuilder.process(startTag);
                    }
                    if (StringUtil.in(string, "caption", "col", "colgroup", "tbody", "tfoot", "thead")) {
                        return this.exitTableBody(token, htmlTreeBuilder);
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                case EndTag: {
                    Token.EndTag endTag = token.asEndTag();
                    String string = endTag.name();
                    if (StringUtil.in(string, "tbody", "tfoot", "thead")) {
                        if (!htmlTreeBuilder.inTableScope(string)) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.clearStackToTableBodyContext();
                        htmlTreeBuilder.pop();
                        htmlTreeBuilder.transition(InTable);
                        break;
                    }
                    if (string.equals("table")) {
                        return this.exitTableBody(token, htmlTreeBuilder);
                    }
                    if (StringUtil.in(string, "body", "caption", "col", "colgroup", "html", "td", "th", "tr")) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                default: {
                    return this.anythingElse(token, htmlTreeBuilder);
                }
            }
            return true;
        }

        private boolean exitTableBody(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (!(htmlTreeBuilder.inTableScope("tbody") || htmlTreeBuilder.inTableScope("thead") || htmlTreeBuilder.inScope("tfoot"))) {
                htmlTreeBuilder.error(this);
                return false;
            }
            htmlTreeBuilder.clearStackToTableBodyContext();
            htmlTreeBuilder.process(new Token.EndTag(htmlTreeBuilder.currentElement().nodeName()));
            return htmlTreeBuilder.process(token);
        }

        private boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            return htmlTreeBuilder.process(token, InTable);
        }
    }
    ,
    InRow{

        /*
         * Enabled aggressive block sorting
         */
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isStartTag()) {
                Token.StartTag startTag = token.asStartTag();
                String string = startTag.name();
                if (StringUtil.in(string, "th", "td")) {
                    htmlTreeBuilder.clearStackToTableRowContext();
                    htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.transition(InCell);
                    htmlTreeBuilder.insertMarkerToFormattingElements();
                    return true;
                }
                if (!StringUtil.in(string, "caption", "col", "colgroup", "tbody", "tfoot", "thead", "tr")) return this.anythingElse(token, htmlTreeBuilder);
                return this.handleMissingTr(token, htmlTreeBuilder);
            }
            if (!token.isEndTag()) return this.anythingElse(token, htmlTreeBuilder);
            Token.EndTag endTag = token.asEndTag();
            String string = endTag.name();
            if (string.equals("tr")) {
                if (!htmlTreeBuilder.inTableScope(string)) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                htmlTreeBuilder.clearStackToTableRowContext();
                htmlTreeBuilder.pop();
                htmlTreeBuilder.transition(InTableBody);
                return true;
            }
            if (string.equals("table")) {
                return this.handleMissingTr(token, htmlTreeBuilder);
            }
            if (!StringUtil.in(string, "tbody", "tfoot", "thead")) {
                if (!StringUtil.in(string, "body", "caption", "col", "colgroup", "html", "td", "th")) return this.anythingElse(token, htmlTreeBuilder);
                htmlTreeBuilder.error(this);
                return false;
            }
            if (!htmlTreeBuilder.inTableScope(string)) {
                htmlTreeBuilder.error(this);
                return false;
            }
            htmlTreeBuilder.process(new Token.EndTag("tr"));
            return htmlTreeBuilder.process(token);
        }

        private boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            return htmlTreeBuilder.process(token, InTable);
        }

        private boolean handleMissingTr(Token token, TreeBuilder treeBuilder) {
            boolean bl = treeBuilder.process(new Token.EndTag("tr"));
            if (bl) {
                return treeBuilder.process(token);
            }
            return false;
        }
    }
    ,
    InCell{

        /*
         * Enabled aggressive block sorting
         */
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isEndTag()) {
                Token.EndTag endTag = token.asEndTag();
                String string = endTag.name();
                if (StringUtil.in(string, "td", "th")) {
                    if (!htmlTreeBuilder.inTableScope(string)) {
                        htmlTreeBuilder.error(this);
                        htmlTreeBuilder.transition(InRow);
                        return false;
                    }
                    htmlTreeBuilder.generateImpliedEndTags();
                    if (!htmlTreeBuilder.currentElement().nodeName().equals(string)) {
                        htmlTreeBuilder.error(this);
                    }
                    htmlTreeBuilder.popStackToClose(string);
                    htmlTreeBuilder.clearFormattingElementsToLastMarker();
                    htmlTreeBuilder.transition(InRow);
                    return true;
                }
                if (StringUtil.in(string, "body", "caption", "col", "colgroup", "html")) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                if (!StringUtil.in(string, "table", "tbody", "tfoot", "thead", "tr")) return this.anythingElse(token, htmlTreeBuilder);
                if (!htmlTreeBuilder.inTableScope(string)) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                this.closeCell(htmlTreeBuilder);
                return htmlTreeBuilder.process(token);
            }
            if (!token.isStartTag()) return this.anythingElse(token, htmlTreeBuilder);
            if (!StringUtil.in(token.asStartTag().name(), "caption", "col", "colgroup", "tbody", "td", "tfoot", "th", "thead", "tr")) return this.anythingElse(token, htmlTreeBuilder);
            if (!htmlTreeBuilder.inTableScope("td") && !htmlTreeBuilder.inTableScope("th")) {
                htmlTreeBuilder.error(this);
                return false;
            }
            this.closeCell(htmlTreeBuilder);
            return htmlTreeBuilder.process(token);
        }

        private boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            return htmlTreeBuilder.process(token, InBody);
        }

        private void closeCell(HtmlTreeBuilder htmlTreeBuilder) {
            if (htmlTreeBuilder.inTableScope("td")) {
                htmlTreeBuilder.process(new Token.EndTag("td"));
            } else {
                htmlTreeBuilder.process(new Token.EndTag("th"));
            }
        }
    }
    ,
    InSelect{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            switch (token.type) {
                case Character: {
                    Token.Character character = token.asCharacter();
                    if (character.getData().equals(nullString)) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    htmlTreeBuilder.insert(character);
                    break;
                }
                case Comment: {
                    htmlTreeBuilder.insert(token.asComment());
                    break;
                }
                case Doctype: {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                case StartTag: {
                    Token.StartTag startTag = token.asStartTag();
                    String string = startTag.name();
                    if (string.equals("html")) {
                        return htmlTreeBuilder.process(startTag, InBody);
                    }
                    if (string.equals("option")) {
                        htmlTreeBuilder.process(new Token.EndTag("option"));
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (string.equals("optgroup")) {
                        if (htmlTreeBuilder.currentElement().nodeName().equals("option")) {
                            htmlTreeBuilder.process(new Token.EndTag("option"));
                        } else if (htmlTreeBuilder.currentElement().nodeName().equals("optgroup")) {
                            htmlTreeBuilder.process(new Token.EndTag("optgroup"));
                        }
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (string.equals("select")) {
                        htmlTreeBuilder.error(this);
                        return htmlTreeBuilder.process(new Token.EndTag("select"));
                    }
                    if (StringUtil.in(string, "input", "keygen", "textarea")) {
                        htmlTreeBuilder.error(this);
                        if (!htmlTreeBuilder.inSelectScope("select")) {
                            return false;
                        }
                        htmlTreeBuilder.process(new Token.EndTag("select"));
                        return htmlTreeBuilder.process(startTag);
                    }
                    if (string.equals("script")) {
                        return htmlTreeBuilder.process(token, InHead);
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                case EndTag: {
                    Token.EndTag endTag = token.asEndTag();
                    String string = endTag.name();
                    if (string.equals("optgroup")) {
                        if (htmlTreeBuilder.currentElement().nodeName().equals("option") && htmlTreeBuilder.aboveOnStack(htmlTreeBuilder.currentElement()) != null && htmlTreeBuilder.aboveOnStack(htmlTreeBuilder.currentElement()).nodeName().equals("optgroup")) {
                            htmlTreeBuilder.process(new Token.EndTag("option"));
                        }
                        if (htmlTreeBuilder.currentElement().nodeName().equals("optgroup")) {
                            htmlTreeBuilder.pop();
                            break;
                        }
                        htmlTreeBuilder.error(this);
                        break;
                    }
                    if (string.equals("option")) {
                        if (htmlTreeBuilder.currentElement().nodeName().equals("option")) {
                            htmlTreeBuilder.pop();
                            break;
                        }
                        htmlTreeBuilder.error(this);
                        break;
                    }
                    if (string.equals("select")) {
                        if (!htmlTreeBuilder.inSelectScope(string)) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.popStackToClose(string);
                        htmlTreeBuilder.resetInsertionMode();
                        break;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                case EOF: {
                    if (htmlTreeBuilder.currentElement().nodeName().equals("html")) break;
                    htmlTreeBuilder.error(this);
                    break;
                }
                default: {
                    return this.anythingElse(token, htmlTreeBuilder);
                }
            }
            return true;
        }

        private boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            htmlTreeBuilder.error(this);
            return false;
        }
    }
    ,
    InSelectInTable{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isStartTag() && StringUtil.in(token.asStartTag().name(), "caption", "table", "tbody", "tfoot", "thead", "tr", "td", "th")) {
                htmlTreeBuilder.error(this);
                htmlTreeBuilder.process(new Token.EndTag("select"));
                return htmlTreeBuilder.process(token);
            }
            if (token.isEndTag() && StringUtil.in(token.asEndTag().name(), "caption", "table", "tbody", "tfoot", "thead", "tr", "td", "th")) {
                htmlTreeBuilder.error(this);
                if (htmlTreeBuilder.inTableScope(token.asEndTag().name())) {
                    htmlTreeBuilder.process(new Token.EndTag("select"));
                    return htmlTreeBuilder.process(token);
                }
                return false;
            }
            return htmlTreeBuilder.process(token, InSelect);
        }
    }
    ,
    AfterBody{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                return htmlTreeBuilder.process(token, InBody);
            }
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
            } else {
                if (token.isDoctype()) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                if (token.isStartTag() && token.asStartTag().name().equals("html")) {
                    return htmlTreeBuilder.process(token, InBody);
                }
                if (token.isEndTag() && token.asEndTag().name().equals("html")) {
                    if (htmlTreeBuilder.isFragmentParsing()) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    htmlTreeBuilder.transition(AfterAfterBody);
                } else if (!token.isEOF()) {
                    htmlTreeBuilder.error(this);
                    htmlTreeBuilder.transition(InBody);
                    return htmlTreeBuilder.process(token);
                }
            }
            return true;
        }
    }
    ,
    InFrameset{

        /*
         * Enabled aggressive block sorting
         */
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                htmlTreeBuilder.insert(token.asCharacter());
                return true;
            }
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
                return true;
            }
            if (token.isDoctype()) {
                htmlTreeBuilder.error(this);
                return false;
            }
            if (token.isStartTag()) {
                Token.StartTag startTag = token.asStartTag();
                String string = startTag.name();
                if (string.equals("html")) {
                    return htmlTreeBuilder.process(startTag, InBody);
                }
                if (string.equals("frameset")) {
                    htmlTreeBuilder.insert(startTag);
                    return true;
                }
                if (string.equals("frame")) {
                    htmlTreeBuilder.insertEmpty(startTag);
                    return true;
                }
                if (string.equals("noframes")) {
                    return htmlTreeBuilder.process(startTag, InHead);
                }
                htmlTreeBuilder.error(this);
                return false;
            }
            if (token.isEndTag() && token.asEndTag().name().equals("frameset")) {
                if (htmlTreeBuilder.currentElement().nodeName().equals("html")) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                htmlTreeBuilder.pop();
                if (htmlTreeBuilder.isFragmentParsing()) return true;
                if (htmlTreeBuilder.currentElement().nodeName().equals("frameset")) return true;
                htmlTreeBuilder.transition(AfterFrameset);
                return true;
            }
            if (token.isEOF()) {
                if (htmlTreeBuilder.currentElement().nodeName().equals("html")) return true;
                htmlTreeBuilder.error(this);
                return true;
            }
            htmlTreeBuilder.error(this);
            return false;
        }
    }
    ,
    AfterFrameset{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                htmlTreeBuilder.insert(token.asCharacter());
            } else if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
            } else {
                if (token.isDoctype()) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                if (token.isStartTag() && token.asStartTag().name().equals("html")) {
                    return htmlTreeBuilder.process(token, InBody);
                }
                if (token.isEndTag() && token.asEndTag().name().equals("html")) {
                    htmlTreeBuilder.transition(AfterAfterFrameset);
                } else {
                    if (token.isStartTag() && token.asStartTag().name().equals("noframes")) {
                        return htmlTreeBuilder.process(token, InHead);
                    }
                    if (!token.isEOF()) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                }
            }
            return true;
        }
    }
    ,
    AfterAfterBody{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
            } else {
                if (token.isDoctype() || HtmlTreeBuilderState.isWhitespace(token) || token.isStartTag() && token.asStartTag().name().equals("html")) {
                    return htmlTreeBuilder.process(token, InBody);
                }
                if (!token.isEOF()) {
                    htmlTreeBuilder.error(this);
                    htmlTreeBuilder.transition(InBody);
                    return htmlTreeBuilder.process(token);
                }
            }
            return true;
        }
    }
    ,
    AfterAfterFrameset{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
            } else {
                if (token.isDoctype() || HtmlTreeBuilderState.isWhitespace(token) || token.isStartTag() && token.asStartTag().name().equals("html")) {
                    return htmlTreeBuilder.process(token, InBody);
                }
                if (!token.isEOF()) {
                    if (token.isStartTag() && token.asStartTag().name().equals("noframes")) {
                        return htmlTreeBuilder.process(token, InHead);
                    }
                    htmlTreeBuilder.error(this);
                    return false;
                }
            }
            return true;
        }
    }
    ,
    ForeignContent{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            return true;
        }
    };

    private static String nullString;

    abstract boolean process(Token var1, HtmlTreeBuilder var2);

    private static boolean isWhitespace(Token token) {
        if (token.isCharacter()) {
            String string = token.asCharacter().getData();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (StringUtil.isWhitespace(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static void handleRcData(Token.StartTag startTag, HtmlTreeBuilder htmlTreeBuilder) {
        htmlTreeBuilder.insert(startTag);
        htmlTreeBuilder.tokeniser.transition(TokeniserState.Rcdata);
        htmlTreeBuilder.markInsertionMode();
        htmlTreeBuilder.transition(Text);
    }

    private static void handleRawtext(Token.StartTag startTag, HtmlTreeBuilder htmlTreeBuilder) {
        htmlTreeBuilder.insert(startTag);
        htmlTreeBuilder.tokeniser.transition(TokeniserState.Rawtext);
        htmlTreeBuilder.markInsertionMode();
        htmlTreeBuilder.transition(Text);
    }

    static {
        nullString = String.valueOf('\u0000');
    }
}

