/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jsoup.parser;

import ai.org.jsoup.helper.DescendableLinkedList;
import ai.org.jsoup.helper.StringUtil;
import ai.org.jsoup.helper.Validate;
import ai.org.jsoup.nodes.Comment;
import ai.org.jsoup.nodes.DataNode;
import ai.org.jsoup.nodes.Document;
import ai.org.jsoup.nodes.Element;
import ai.org.jsoup.nodes.Node;
import ai.org.jsoup.nodes.TextNode;
import ai.org.jsoup.parser.HtmlTreeBuilderState;
import ai.org.jsoup.parser.ParseError;
import ai.org.jsoup.parser.ParseErrorList;
import ai.org.jsoup.parser.Tag;
import ai.org.jsoup.parser.Token;
import ai.org.jsoup.parser.TokeniserState;
import ai.org.jsoup.parser.TreeBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlTreeBuilder
extends TreeBuilder {
    private HtmlTreeBuilderState state;
    private HtmlTreeBuilderState originalState;
    private boolean baseUriSetFromDoc = false;
    private Element headElement;
    private Element formElement;
    private Element contextElement;
    private DescendableLinkedList<Element> formattingElements = new DescendableLinkedList();
    private List<Token.Character> pendingTableCharacters = new ArrayList<Token.Character>();
    private boolean framesetOk = true;
    private boolean fosterInserts = false;
    private boolean fragmentParsing = false;

    HtmlTreeBuilder() {
    }

    @Override
    Document parse(String string, String string2, ParseErrorList parseErrorList) {
        this.state = HtmlTreeBuilderState.Initial;
        return super.parse(string, string2, parseErrorList);
    }

    List<Node> parseFragment(String string, Element element, String string2, ParseErrorList parseErrorList) {
        this.state = HtmlTreeBuilderState.Initial;
        this.initialiseParse(string, string2, parseErrorList);
        this.contextElement = element;
        this.fragmentParsing = true;
        Node node = null;
        if (element != null) {
            if (element.ownerDocument() != null) {
                this.doc.quirksMode(element.ownerDocument().quirksMode());
            }
            String string3 = element.tagName();
            if (StringUtil.in(string3, "title", "textarea")) {
                this.tokeniser.transition(TokeniserState.Rcdata);
            } else if (StringUtil.in(string3, "iframe", "noembed", "noframes", "style", "xmp")) {
                this.tokeniser.transition(TokeniserState.Rawtext);
            } else if (string3.equals("script")) {
                this.tokeniser.transition(TokeniserState.ScriptData);
            } else if (string3.equals("noscript")) {
                this.tokeniser.transition(TokeniserState.Data);
            } else if (string3.equals("plaintext")) {
                this.tokeniser.transition(TokeniserState.Data);
            } else {
                this.tokeniser.transition(TokeniserState.Data);
            }
            node = new Element(Tag.valueOf("html"), string2);
            this.doc.appendChild(node);
            this.stack.push(node);
            this.resetInsertionMode();
        }
        this.runParser();
        if (element != null) {
            return node.childNodes();
        }
        return this.doc.childNodes();
    }

    @Override
    protected boolean process(Token token) {
        this.currentToken = token;
        return this.state.process(token, this);
    }

    boolean process(Token token, HtmlTreeBuilderState htmlTreeBuilderState) {
        this.currentToken = token;
        return htmlTreeBuilderState.process(token, this);
    }

    void transition(HtmlTreeBuilderState htmlTreeBuilderState) {
        this.state = htmlTreeBuilderState;
    }

    HtmlTreeBuilderState state() {
        return this.state;
    }

    void markInsertionMode() {
        this.originalState = this.state;
    }

    HtmlTreeBuilderState originalState() {
        return this.originalState;
    }

    void framesetOk(boolean bl) {
        this.framesetOk = bl;
    }

    boolean framesetOk() {
        return this.framesetOk;
    }

    Document getDocument() {
        return this.doc;
    }

    String getBaseUri() {
        return this.baseUri;
    }

    void maybeSetBaseUri(Element element) {
        if (this.baseUriSetFromDoc) {
            return;
        }
        String string = element.absUrl("href");
        if (string.length() != 0) {
            this.baseUri = string;
            this.baseUriSetFromDoc = true;
            this.doc.setBaseUri(string);
        }
    }

    boolean isFragmentParsing() {
        return this.fragmentParsing;
    }

    void error(HtmlTreeBuilderState htmlTreeBuilderState) {
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader.pos(), "Unexpected token [%s] when in state [%s]", new Object[]{this.currentToken.tokenType(), htmlTreeBuilderState}));
        }
    }

    Element insert(Token.StartTag startTag) {
        if (startTag.isSelfClosing()) {
            Element element = this.insertEmpty(startTag);
            this.stack.add(element);
            this.tokeniser.emit(new Token.EndTag(element.tagName()));
            return element;
        }
        Element element = new Element(Tag.valueOf(startTag.name()), this.baseUri, startTag.attributes);
        this.insert(element);
        return element;
    }

    Element insert(String string) {
        Element element = new Element(Tag.valueOf(string), this.baseUri);
        this.insert(element);
        return element;
    }

    void insert(Element element) {
        this.insertNode(element);
        this.stack.add(element);
    }

    Element insertEmpty(Token.StartTag startTag) {
        Tag tag = Tag.valueOf(startTag.name());
        Element element = new Element(tag, this.baseUri, startTag.attributes);
        this.insertNode(element);
        if (startTag.isSelfClosing()) {
            if (tag.isKnownTag()) {
                if (tag.isSelfClosing()) {
                    this.tokeniser.acknowledgeSelfClosingFlag();
                }
            } else {
                tag.setSelfClosing();
                this.tokeniser.acknowledgeSelfClosingFlag();
            }
        }
        return element;
    }

    void insert(Token.Comment comment) {
        Comment comment2 = new Comment(comment.getData(), this.baseUri);
        this.insertNode(comment2);
    }

    void insert(Token.Character character) {
        Node node = StringUtil.in(this.currentElement().tagName(), "script", "style") ? new DataNode(character.getData(), this.baseUri) : new TextNode(character.getData(), this.baseUri);
        this.currentElement().appendChild(node);
    }

    private void insertNode(Node node) {
        if (this.stack.size() == 0) {
            this.doc.appendChild(node);
        } else if (this.isFosterInserts()) {
            this.insertInFosterParent(node);
        } else {
            this.currentElement().appendChild(node);
        }
    }

    Element pop() {
        if (((Element)this.stack.peekLast()).nodeName().equals("td") && !this.state.name().equals("InCell")) {
            Validate.isFalse(true, "pop td not in cell");
        }
        if (((Element)this.stack.peekLast()).nodeName().equals("html")) {
            Validate.isFalse(true, "popping html!");
        }
        return (Element)this.stack.pollLast();
    }

    void push(Element element) {
        this.stack.add(element);
    }

    DescendableLinkedList<Element> getStack() {
        return this.stack;
    }

    boolean onStack(Element element) {
        return this.isElementInQueue(this.stack, element);
    }

    private boolean isElementInQueue(DescendableLinkedList<Element> descendableLinkedList, Element element) {
        Iterator<Element> iterator = descendableLinkedList.descendingIterator();
        while (iterator.hasNext()) {
            Element element2 = iterator.next();
            if (element2 != element) continue;
            return true;
        }
        return false;
    }

    Element getFromStack(String string) {
        Iterator iterator = this.stack.descendingIterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!element.nodeName().equals(string)) continue;
            return element;
        }
        return null;
    }

    boolean removeFromStack(Element element) {
        Iterator iterator = this.stack.descendingIterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            if (element2 != element) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    void popStackToClose(String string) {
        Iterator iterator = this.stack.descendingIterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (element.nodeName().equals(string)) {
                iterator.remove();
                break;
            }
            iterator.remove();
        }
    }

    void popStackToClose(String ... stringArray) {
        Iterator iterator = this.stack.descendingIterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (StringUtil.in(element.nodeName(), stringArray)) {
                iterator.remove();
                break;
            }
            iterator.remove();
        }
    }

    void popStackToBefore(String string) {
        Element element;
        Iterator iterator = this.stack.descendingIterator();
        while (iterator.hasNext() && !(element = (Element)iterator.next()).nodeName().equals(string)) {
            iterator.remove();
        }
    }

    void clearStackToTableContext() {
        this.clearStackToContext("table");
    }

    void clearStackToTableBodyContext() {
        this.clearStackToContext("tbody", "tfoot", "thead");
    }

    void clearStackToTableRowContext() {
        this.clearStackToContext("tr");
    }

    private void clearStackToContext(String ... stringArray) {
        Element element;
        Iterator iterator = this.stack.descendingIterator();
        while (iterator.hasNext() && !StringUtil.in((element = (Element)iterator.next()).nodeName(), stringArray) && !element.nodeName().equals("html")) {
            iterator.remove();
        }
    }

    Element aboveOnStack(Element element) {
        assert (this.onStack(element));
        Iterator iterator = this.stack.descendingIterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            if (element2 != element) continue;
            return (Element)iterator.next();
        }
        return null;
    }

    void insertOnStackAfter(Element element, Element element2) {
        int n = this.stack.lastIndexOf(element);
        Validate.isTrue(n != -1);
        this.stack.add(n + 1, element2);
    }

    void replaceOnStack(Element element, Element element2) {
        this.replaceInQueue(this.stack, element, element2);
    }

    private void replaceInQueue(LinkedList<Element> linkedList, Element element, Element element2) {
        int n = linkedList.lastIndexOf(element);
        Validate.isTrue(n != -1);
        linkedList.remove(n);
        linkedList.add(n, element2);
    }

    void resetInsertionMode() {
        boolean bl = false;
        Iterator iterator = this.stack.descendingIterator();
        while (iterator.hasNext()) {
            String string;
            Element element = (Element)iterator.next();
            if (!iterator.hasNext()) {
                bl = true;
                element = this.contextElement;
            }
            if ("select".equals(string = element.nodeName())) {
                this.transition(HtmlTreeBuilderState.InSelect);
                break;
            }
            if ("td".equals(string) || "td".equals(string) && !bl) {
                this.transition(HtmlTreeBuilderState.InCell);
                break;
            }
            if ("tr".equals(string)) {
                this.transition(HtmlTreeBuilderState.InRow);
                break;
            }
            if ("tbody".equals(string) || "thead".equals(string) || "tfoot".equals(string)) {
                this.transition(HtmlTreeBuilderState.InTableBody);
                break;
            }
            if ("caption".equals(string)) {
                this.transition(HtmlTreeBuilderState.InCaption);
                break;
            }
            if ("colgroup".equals(string)) {
                this.transition(HtmlTreeBuilderState.InColumnGroup);
                break;
            }
            if ("table".equals(string)) {
                this.transition(HtmlTreeBuilderState.InTable);
                break;
            }
            if ("head".equals(string)) {
                this.transition(HtmlTreeBuilderState.InBody);
                break;
            }
            if ("body".equals(string)) {
                this.transition(HtmlTreeBuilderState.InBody);
                break;
            }
            if ("frameset".equals(string)) {
                this.transition(HtmlTreeBuilderState.InFrameset);
                break;
            }
            if ("html".equals(string)) {
                this.transition(HtmlTreeBuilderState.BeforeHead);
                break;
            }
            if (!bl) continue;
            this.transition(HtmlTreeBuilderState.InBody);
            break;
        }
    }

    private boolean inSpecificScope(String string, String[] stringArray, String[] stringArray2) {
        return this.inSpecificScope(new String[]{string}, stringArray, stringArray2);
    }

    private boolean inSpecificScope(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        Iterator iterator = this.stack.descendingIterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String string = element.nodeName();
            if (StringUtil.in(string, stringArray)) {
                return true;
            }
            if (StringUtil.in(string, stringArray2)) {
                return false;
            }
            if (stringArray3 == null || !StringUtil.in(string, stringArray3)) continue;
            return false;
        }
        Validate.fail("Should not be reachable");
        return false;
    }

    boolean inScope(String[] stringArray) {
        return this.inSpecificScope(stringArray, new String[]{"applet", "caption", "html", "table", "td", "th", "marquee", "object"}, null);
    }

    boolean inScope(String string) {
        return this.inScope(string, null);
    }

    boolean inScope(String string, String[] stringArray) {
        return this.inSpecificScope(string, new String[]{"applet", "caption", "html", "table", "td", "th", "marquee", "object"}, stringArray);
    }

    boolean inListItemScope(String string) {
        return this.inScope(string, new String[]{"ol", "ul"});
    }

    boolean inButtonScope(String string) {
        return this.inScope(string, new String[]{"button"});
    }

    boolean inTableScope(String string) {
        return this.inSpecificScope(string, new String[]{"html", "table"}, null);
    }

    boolean inSelectScope(String string) {
        Iterator iterator = this.stack.descendingIterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String string2 = element.nodeName();
            if (string2.equals(string)) {
                return true;
            }
            if (StringUtil.in(string2, "optgroup", "option")) continue;
            return false;
        }
        Validate.fail("Should not be reachable");
        return false;
    }

    void setHeadElement(Element element) {
        this.headElement = element;
    }

    Element getHeadElement() {
        return this.headElement;
    }

    boolean isFosterInserts() {
        return this.fosterInserts;
    }

    void setFosterInserts(boolean bl) {
        this.fosterInserts = bl;
    }

    Element getFormElement() {
        return this.formElement;
    }

    void setFormElement(Element element) {
        this.formElement = element;
    }

    void newPendingTableCharacters() {
        this.pendingTableCharacters = new ArrayList<Token.Character>();
    }

    List<Token.Character> getPendingTableCharacters() {
        return this.pendingTableCharacters;
    }

    void setPendingTableCharacters(List<Token.Character> list) {
        this.pendingTableCharacters = list;
    }

    void generateImpliedEndTags(String string) {
        while (string != null && !this.currentElement().nodeName().equals(string) && StringUtil.in(this.currentElement().nodeName(), "dd", "dt", "li", "option", "optgroup", "p", "rp", "rt")) {
            this.pop();
        }
    }

    void generateImpliedEndTags() {
        this.generateImpliedEndTags(null);
    }

    boolean isSpecial(Element element) {
        String string = element.nodeName();
        return StringUtil.in(string, "address", "applet", "area", "article", "aside", "base", "basefont", "bgsound", "blockquote", "body", "br", "button", "caption", "center", "col", "colgroup", "command", "dd", "details", "dir", "div", "dl", "dt", "embed", "fieldset", "figcaption", "figure", "footer", "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "iframe", "img", "input", "isindex", "li", "link", "listing", "marquee", "menu", "meta", "nav", "noembed", "noframes", "noscript", "object", "ol", "p", "param", "plaintext", "pre", "script", "section", "select", "style", "summary", "table", "tbody", "td", "textarea", "tfoot", "th", "thead", "title", "tr", "ul", "wbr", "xmp");
    }

    void pushActiveFormattingElements(Element element) {
        Element element2;
        int n = 0;
        Iterator<Element> iterator = this.formattingElements.descendingIterator();
        while (iterator.hasNext() && (element2 = iterator.next()) != null) {
            if (this.isSameFormattingElement(element, element2)) {
                ++n;
            }
            if (n != 3) continue;
            iterator.remove();
            break;
        }
        this.formattingElements.add(element);
    }

    private boolean isSameFormattingElement(Element element, Element element2) {
        return element.nodeName().equals(element2.nodeName()) && element.attributes().equals(element2.attributes());
    }

    void reconstructFormattingElements() {
        int n = this.formattingElements.size();
        if (n == 0 || this.formattingElements.getLast() == null || this.onStack((Element)this.formattingElements.getLast())) {
            return;
        }
        Element element = (Element)this.formattingElements.getLast();
        int n2 = n - 1;
        boolean bl = false;
        do {
            if (n2 != 0) continue;
            bl = true;
            break;
        } while ((element = (Element)this.formattingElements.get(--n2)) != null && !this.onStack(element));
        do {
            if (!bl) {
                element = (Element)this.formattingElements.get(++n2);
            }
            Validate.notNull(element);
            bl = false;
            Element element2 = this.insert(element.nodeName());
            element2.attributes().addAll(element.attributes());
            this.formattingElements.add(n2, element2);
            this.formattingElements.remove(n2 + 1);
        } while (n2 != n - 1);
    }

    void clearFormattingElementsToLastMarker() {
        while (!this.formattingElements.isEmpty()) {
            Element element = this.formattingElements.peekLast();
            this.formattingElements.removeLast();
            if (element != null) continue;
            break;
        }
    }

    void removeFromActiveFormattingElements(Element element) {
        Iterator<Element> iterator = this.formattingElements.descendingIterator();
        while (iterator.hasNext()) {
            Element element2 = iterator.next();
            if (element2 != element) continue;
            iterator.remove();
            break;
        }
    }

    boolean isInActiveFormattingElements(Element element) {
        return this.isElementInQueue(this.formattingElements, element);
    }

    Element getActiveFormattingElement(String string) {
        Element element;
        Iterator<Element> iterator = this.formattingElements.descendingIterator();
        while (iterator.hasNext() && (element = iterator.next()) != null) {
            if (!element.nodeName().equals(string)) continue;
            return element;
        }
        return null;
    }

    void replaceActiveFormattingElement(Element element, Element element2) {
        this.replaceInQueue(this.formattingElements, element, element2);
    }

    void insertMarkerToFormattingElements() {
        this.formattingElements.add(null);
    }

    void insertInFosterParent(Node node) {
        Element element = null;
        Element element2 = this.getFromStack("table");
        boolean bl = false;
        if (element2 != null) {
            if (element2.parent() != null) {
                element = element2.parent();
                bl = true;
            } else {
                element = this.aboveOnStack(element2);
            }
        } else {
            element = (Element)this.stack.get(0);
        }
        if (bl) {
            Validate.notNull(element2);
            element2.before(node);
        } else {
            element.appendChild(node);
        }
    }

    public String toString() {
        return "TreeBuilder{currentToken=" + this.currentToken + ", state=" + (Object)((Object)this.state) + ", currentElement=" + this.currentElement() + '}';
    }
}

