/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jsoup.nodes;

import ai.org.jsoup.helper.StringUtil;
import ai.org.jsoup.helper.Validate;
import ai.org.jsoup.nodes.Attributes;
import ai.org.jsoup.nodes.Document;
import ai.org.jsoup.nodes.Element;
import ai.org.jsoup.nodes.Entities;
import ai.org.jsoup.nodes.Node;

public class TextNode
extends Node {
    private static final String TEXT_KEY = "text";
    String text;

    public TextNode(String string, String string2) {
        this.baseUri = string2;
        this.text = string;
    }

    public String nodeName() {
        return "#text";
    }

    public String text() {
        return TextNode.normaliseWhitespace(this.getWholeText());
    }

    public TextNode text(String string) {
        this.text = string;
        if (this.attributes != null) {
            this.attributes.put(TEXT_KEY, string);
        }
        return this;
    }

    public String getWholeText() {
        return this.attributes == null ? this.text : this.attributes.get(TEXT_KEY);
    }

    public boolean isBlank() {
        return StringUtil.isBlank(this.getWholeText());
    }

    public TextNode splitText(int n) {
        Validate.isTrue(n >= 0, "Split offset must be not be negative");
        Validate.isTrue(n < this.text.length(), "Split offset must not be greater than current text length");
        String string = this.getWholeText().substring(0, n);
        String string2 = this.getWholeText().substring(n);
        this.text(string);
        TextNode textNode = new TextNode(string2, this.baseUri());
        if (this.parent() != null) {
            this.parent().addChildren(this.siblingIndex() + 1, textNode);
        }
        return textNode;
    }

    void outerHtmlHead(StringBuilder stringBuilder, int n, Document.OutputSettings outputSettings) {
        String string = Entities.escape(this.getWholeText(), outputSettings);
        if (outputSettings.prettyPrint() && this.parent() instanceof Element && !Element.preserveWhitespace((Element)this.parent())) {
            string = TextNode.normaliseWhitespace(string);
        }
        if (outputSettings.prettyPrint() && (this.siblingIndex() == 0 && this.parentNode instanceof Element && ((Element)this.parentNode).tag().formatAsBlock() && !this.isBlank() || outputSettings.outline() && this.siblingNodes().size() > 0 && !this.isBlank())) {
            this.indent(stringBuilder, n, outputSettings);
        }
        stringBuilder.append(string);
    }

    void outerHtmlTail(StringBuilder stringBuilder, int n, Document.OutputSettings outputSettings) {
    }

    public String toString() {
        return this.outerHtml();
    }

    public static TextNode createFromEncoded(String string, String string2) {
        String string3 = Entities.unescape(string);
        return new TextNode(string3, string2);
    }

    static String normaliseWhitespace(String string) {
        string = StringUtil.normaliseWhitespace(string);
        return string;
    }

    static String stripLeadingWhitespace(String string) {
        return string.replaceFirst("^\\s+", "");
    }

    static boolean lastCharIsWhitespace(StringBuilder stringBuilder) {
        return stringBuilder.length() != 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ' ';
    }

    private void ensureAttributes() {
        if (this.attributes == null) {
            this.attributes = new Attributes();
            this.attributes.put(TEXT_KEY, this.text);
        }
    }

    public String attr(String string) {
        this.ensureAttributes();
        return super.attr(string);
    }

    public Attributes attributes() {
        this.ensureAttributes();
        return super.attributes();
    }

    public Node attr(String string, String string2) {
        this.ensureAttributes();
        return super.attr(string, string2);
    }

    public boolean hasAttr(String string) {
        this.ensureAttributes();
        return super.hasAttr(string);
    }

    public Node removeAttr(String string) {
        this.ensureAttributes();
        return super.removeAttr(string);
    }

    public String absUrl(String string) {
        this.ensureAttributes();
        return super.absUrl(string);
    }
}

