/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jsoup.nodes;

import ai.org.jsoup.helper.StringUtil;
import ai.org.jsoup.helper.Validate;
import ai.org.jsoup.nodes.Element;
import ai.org.jsoup.nodes.Entities;
import ai.org.jsoup.nodes.Node;
import ai.org.jsoup.nodes.TextNode;
import ai.org.jsoup.parser.Tag;
import ai.org.jsoup.select.Elements;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;

public class Document
extends Element {
    private OutputSettings outputSettings = new OutputSettings();
    private QuirksMode quirksMode = QuirksMode.noQuirks;

    public Document(String string) {
        super(Tag.valueOf("#root"), string);
    }

    public static Document createShell(String string) {
        Validate.notNull(string);
        Document document = new Document(string);
        Element element = document.appendElement("html");
        element.appendElement("head");
        element.appendElement("body");
        return document;
    }

    public Element head() {
        return this.findFirstElementByTagName("head", this);
    }

    public Element body() {
        return this.findFirstElementByTagName("body", this);
    }

    public String title() {
        Element element = this.getElementsByTag("title").first();
        return element != null ? StringUtil.normaliseWhitespace(element.text()).trim() : "";
    }

    public void title(String string) {
        Validate.notNull(string);
        Element element = this.getElementsByTag("title").first();
        if (element == null) {
            this.head().appendElement("title").text(string);
        } else {
            element.text(string);
        }
    }

    public Element createElement(String string) {
        return new Element(Tag.valueOf(string), this.baseUri());
    }

    public Document normalise() {
        Element element = this.findFirstElementByTagName("html", this);
        if (element == null) {
            element = this.appendElement("html");
        }
        if (this.head() == null) {
            element.prependElement("head");
        }
        if (this.body() == null) {
            element.appendElement("body");
        }
        this.normaliseTextNodes(this.head());
        this.normaliseTextNodes(element);
        this.normaliseTextNodes(this);
        this.normaliseStructure("head", element);
        this.normaliseStructure("body", element);
        return this;
    }

    private void normaliseTextNodes(Element element) {
        ArrayList<TextNode> arrayList = new ArrayList<TextNode>();
        for (Node node : element.childNodes) {
            TextNode textNode;
            if (!(node instanceof TextNode) || (textNode = (TextNode)node).isBlank()) continue;
            arrayList.add(textNode);
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Node node;
            node = (Node)arrayList.get(i);
            element.removeChild(node);
            this.body().prependChild(new TextNode(" ", ""));
            this.body().prependChild(node);
        }
    }

    private void normaliseStructure(String string, Element element) {
        Elements elements = this.getElementsByTag(string);
        Element element2 = elements.first();
        if (elements.size() > 1) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (int i = 1; i < elements.size(); ++i) {
                Node node = elements.get(i);
                for (Node node2 : node.childNodes) {
                    arrayList.add(node2);
                }
                node.remove();
            }
            for (Node node : arrayList) {
                element2.appendChild(node);
            }
        }
        if (!element2.parent().equals(element)) {
            element.appendChild(element2);
        }
    }

    private Element findFirstElementByTagName(String string, Node node) {
        if (node.nodeName().equals(string)) {
            return (Element)node;
        }
        for (Node node2 : node.childNodes) {
            Element element = this.findFirstElementByTagName(string, node2);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    public String outerHtml() {
        return super.html();
    }

    public Element text(String string) {
        this.body().text(string);
        return this;
    }

    public String nodeName() {
        return "#document";
    }

    public Document clone() {
        Document document = (Document)super.clone();
        document.outputSettings = this.outputSettings.clone();
        return document;
    }

    public OutputSettings outputSettings() {
        return this.outputSettings;
    }

    public Document outputSettings(OutputSettings outputSettings) {
        Validate.notNull(outputSettings);
        this.outputSettings = outputSettings;
        return this;
    }

    public QuirksMode quirksMode() {
        return this.quirksMode;
    }

    public Document quirksMode(QuirksMode quirksMode) {
        this.quirksMode = quirksMode;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QuirksMode {
        noQuirks,
        quirks,
        limitedQuirks;

    }

    public static class OutputSettings
    implements Cloneable {
        private Entities.EscapeMode escapeMode = Entities.EscapeMode.base;
        private Charset charset = Charset.forName("UTF-8");
        private CharsetEncoder charsetEncoder = this.charset.newEncoder();
        private boolean prettyPrint = true;
        private boolean outline = false;
        private int indentAmount = 1;

        public Entities.EscapeMode escapeMode() {
            return this.escapeMode;
        }

        public OutputSettings escapeMode(Entities.EscapeMode escapeMode) {
            this.escapeMode = escapeMode;
            return this;
        }

        public Charset charset() {
            return this.charset;
        }

        public OutputSettings charset(Charset charset) {
            this.charset = charset;
            this.charsetEncoder = charset.newEncoder();
            return this;
        }

        public OutputSettings charset(String string) {
            this.charset(Charset.forName(string));
            return this;
        }

        CharsetEncoder encoder() {
            return this.charsetEncoder;
        }

        public boolean prettyPrint() {
            return this.prettyPrint;
        }

        public OutputSettings prettyPrint(boolean bl) {
            this.prettyPrint = bl;
            return this;
        }

        public boolean outline() {
            return this.outline;
        }

        public OutputSettings outline(boolean bl) {
            this.outline = bl;
            return this;
        }

        public int indentAmount() {
            return this.indentAmount;
        }

        public OutputSettings indentAmount(int n) {
            Validate.isTrue(n >= 0);
            this.indentAmount = n;
            return this;
        }

        public OutputSettings clone() {
            OutputSettings outputSettings;
            try {
                outputSettings = (OutputSettings)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
            outputSettings.charset(this.charset.name());
            outputSettings.escapeMode = Entities.EscapeMode.valueOf(this.escapeMode.name());
            return outputSettings;
        }
    }
}

