/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jsoup.helper;

import java.util.Collection;
import java.util.Iterator;

public final class StringUtil {
    private static final String[] padding = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          "};

    public static String join(Collection collection, String string) {
        return StringUtil.join(collection.iterator(), string);
    }

    public static String join(Iterator iterator, String string) {
        if (!iterator.hasNext()) {
            return "";
        }
        String string2 = iterator.next().toString();
        if (!iterator.hasNext()) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(64).append(string2);
        while (iterator.hasNext()) {
            stringBuilder.append(string);
            stringBuilder.append(iterator.next());
        }
        return stringBuilder.toString();
    }

    public static String padding(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (n < padding.length) {
            return padding[n];
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 32;
        }
        return String.valueOf(cArray);
    }

    public static boolean isBlank(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (StringUtil.isWhitespace(string.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(string.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(int n) {
        return n == 32 || n == 9 || n == 10 || n == 12 || n == 13;
    }

    public static String normaliseWhitespace(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl = false;
        boolean bl2 = false;
        int n2 = string.length();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (StringUtil.isWhitespace(n)) {
                if (bl) {
                    bl2 = true;
                    continue;
                }
                if (n != 32) {
                    bl2 = true;
                }
                stringBuilder.append(' ');
                bl = true;
                continue;
            }
            stringBuilder.appendCodePoint(n);
            bl = false;
        }
        return bl2 ? stringBuilder.toString() : string;
    }

    public static boolean in(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }
}

