/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jsoup.examples;

import ai.org.jsoup.Jsoup;
import ai.org.jsoup.helper.StringUtil;
import ai.org.jsoup.helper.Validate;
import ai.org.jsoup.nodes.Document;
import ai.org.jsoup.nodes.Element;
import ai.org.jsoup.nodes.Node;
import ai.org.jsoup.nodes.TextNode;
import ai.org.jsoup.select.NodeTraversor;
import ai.org.jsoup.select.NodeVisitor;
import java.io.IOException;

public class HtmlToPlainText {
    public static void main(String ... stringArray) throws IOException {
        Validate.isTrue(stringArray.length == 1, "usage: supply url to fetch");
        String string = stringArray[0];
        Document document = Jsoup.connect(string).get();
        HtmlToPlainText htmlToPlainText = new HtmlToPlainText();
        String string2 = htmlToPlainText.getPlainText(document);
        System.out.println(string2);
    }

    public String getPlainText(Element element) {
        FormattingVisitor formattingVisitor = new FormattingVisitor();
        NodeTraversor nodeTraversor = new NodeTraversor(formattingVisitor);
        nodeTraversor.traverse(element);
        return formattingVisitor.toString();
    }

    private class FormattingVisitor
    implements NodeVisitor {
        private static final int maxWidth = 80;
        private int width = 0;
        private StringBuilder accum = new StringBuilder();

        private FormattingVisitor() {
        }

        public void head(Node node, int n) {
            String string = node.nodeName();
            if (node instanceof TextNode) {
                this.append(((TextNode)node).text());
            } else if (string.equals("li")) {
                this.append("\n * ");
            }
        }

        public void tail(Node node, int n) {
            String string = node.nodeName();
            if (string.equals("br")) {
                this.append("\n");
            } else if (StringUtil.in(string, "p", "h1", "h2", "h3", "h4", "h5")) {
                this.append("\n\n");
            } else if (string.equals("a")) {
                this.append(String.format(" <%s>", node.absUrl("href")));
            }
        }

        private void append(String string) {
            if (string.startsWith("\n")) {
                this.width = 0;
            }
            if (string.equals(" ") && (this.accum.length() == 0 || StringUtil.in(this.accum.substring(this.accum.length() - 1), " ", "\n"))) {
                return;
            }
            if (string.length() + this.width > 80) {
                String[] stringArray = string.split("\\s+");
                for (int i = 0; i < stringArray.length; ++i) {
                    boolean bl;
                    String string2 = stringArray[i];
                    boolean bl2 = bl = i == stringArray.length - 1;
                    if (!bl) {
                        string2 = string2 + " ";
                    }
                    if (string2.length() + this.width > 80) {
                        this.accum.append("\n").append(string2);
                        this.width = string2.length();
                        continue;
                    }
                    this.accum.append(string2);
                    this.width += string2.length();
                }
            } else {
                this.accum.append(string);
                this.width += string.length();
            }
        }

        public String toString() {
            return this.accum.toString();
        }
    }
}

