/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.xml.writer;

import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.xml.util.ManualMappingDefinition;
import ai.org.jfree.xml.util.MultiplexMappingDefinition;
import ai.org.jfree.xml.util.MultiplexMappingEntry;
import ai.org.jfree.xml.util.ObjectFactory;
import ai.org.jfree.xml.util.SimpleObjectFactory;
import ai.org.jfree.xml.writer.XMLWriter;
import ai.org.jfree.xml.writer.XMLWriterException;
import ai.org.jfree.xml.writer.XmlWriteHandler;
import ai.org.jfree.xml.writer.coretypes.BasicStrokeWriteHandler;
import ai.org.jfree.xml.writer.coretypes.ColorWriteHandler;
import ai.org.jfree.xml.writer.coretypes.FontWriteHandler;
import ai.org.jfree.xml.writer.coretypes.GenericWriteHandler;
import ai.org.jfree.xml.writer.coretypes.GradientPaintWriteHandler;
import ai.org.jfree.xml.writer.coretypes.InsetsWriteHandler;
import ai.org.jfree.xml.writer.coretypes.ListWriteHandler;
import ai.org.jfree.xml.writer.coretypes.Point2DWriteHandler;
import ai.org.jfree.xml.writer.coretypes.Rectangle2DWriteHandler;
import ai.org.jfree.xml.writer.coretypes.RenderingHintsWriteHandler;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

public abstract class RootXmlWriteHandler {
    private SimpleObjectFactory classToHandlerMapping = new SimpleObjectFactory();

    public RootXmlWriteHandler() {
        MultiplexMappingEntry[] multiplexMappingEntryArray = new MultiplexMappingEntry[]{new MultiplexMappingEntry("color", Color.class.getName()), new MultiplexMappingEntry("gradientPaint", GradientPaint.class.getName())};
        this.addMultiplexMapping(Paint.class, "type", multiplexMappingEntryArray);
        this.addManualMapping(GradientPaint.class, GradientPaintWriteHandler.class);
        this.addManualMapping(Color.class, ColorWriteHandler.class);
        MultiplexMappingEntry[] multiplexMappingEntryArray2 = new MultiplexMappingEntry[]{new MultiplexMappingEntry("float", Point2D.Float.class.getName()), new MultiplexMappingEntry("double", Point2D.Double.class.getName())};
        this.addMultiplexMapping(Point2D.class, "type", multiplexMappingEntryArray2);
        this.addManualMapping(Point2D.Float.class, Point2DWriteHandler.class);
        this.addManualMapping(Point2D.Double.class, Point2DWriteHandler.class);
        MultiplexMappingEntry[] multiplexMappingEntryArray3 = new MultiplexMappingEntry[]{new MultiplexMappingEntry("basic", BasicStroke.class.getName())};
        this.addMultiplexMapping(Stroke.class, "type", multiplexMappingEntryArray3);
        this.addManualMapping(BasicStroke.class, BasicStrokeWriteHandler.class);
        MultiplexMappingEntry[] multiplexMappingEntryArray4 = new MultiplexMappingEntry[]{new MultiplexMappingEntry("float", Rectangle2D.Float.class.getName()), new MultiplexMappingEntry("double", Rectangle2D.Double.class.getName())};
        this.addMultiplexMapping(Rectangle2D.class, "type", multiplexMappingEntryArray4);
        this.addManualMapping(Rectangle2D.Float.class, Rectangle2DWriteHandler.class);
        this.addManualMapping(Rectangle2D.Double.class, Rectangle2DWriteHandler.class);
        MultiplexMappingEntry[] multiplexMappingEntryArray5 = new MultiplexMappingEntry[]{new MultiplexMappingEntry("array-list", ArrayList.class.getName()), new MultiplexMappingEntry("linked-list", LinkedList.class.getName()), new MultiplexMappingEntry("vector", Vector.class.getName()), new MultiplexMappingEntry("stack", Stack.class.getName())};
        this.addMultiplexMapping(List.class, "type", multiplexMappingEntryArray5);
        this.addManualMapping(LinkedList.class, ListWriteHandler.class);
        this.addManualMapping(Vector.class, ListWriteHandler.class);
        this.addManualMapping(ArrayList.class, ListWriteHandler.class);
        this.addManualMapping(Stack.class, ListWriteHandler.class);
        this.addManualMapping(RenderingHints.class, RenderingHintsWriteHandler.class);
        this.addManualMapping(Insets.class, InsetsWriteHandler.class);
        this.addManualMapping(Font.class, FontWriteHandler.class);
    }

    protected abstract ObjectFactory getFactoryLoader();

    protected void addManualMapping(Class clazz, Class clazz2) {
        if (clazz2 == null) {
            throw new NullPointerException("handler must not be null.");
        }
        if (clazz == null) {
            throw new NullPointerException("classToWrite must not be null.");
        }
        if (!XmlWriteHandler.class.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException("The given handler is no XmlWriteHandler.");
        }
        this.classToHandlerMapping.addManualMapping(new ManualMappingDefinition(clazz, null, clazz2.getName()));
    }

    protected void addMultiplexMapping(Class clazz, String string, MultiplexMappingEntry[] multiplexMappingEntryArray) {
        this.classToHandlerMapping.addMultiplexMapping(new MultiplexMappingDefinition(clazz, string, multiplexMappingEntryArray));
    }

    protected XmlWriteHandler getMapping(Class clazz) throws XMLWriterException {
        if (clazz == null) {
            throw new NullPointerException("ClassToWrite is null.");
        }
        ManualMappingDefinition manualMappingDefinition = this.classToHandlerMapping.getManualMappingDefinition(clazz);
        if (manualMappingDefinition == null) {
            manualMappingDefinition = this.getFactoryLoader().getManualMappingDefinition(clazz);
        }
        if (manualMappingDefinition != null) {
            return this.loadHandlerClass(manualMappingDefinition.getWriteHandler());
        }
        if (this.classToHandlerMapping.isGenericHandler(clazz)) {
            return new GenericWriteHandler(this.classToHandlerMapping.getFactoryForClass(clazz));
        }
        if (this.getFactoryLoader().isGenericHandler(clazz)) {
            return new GenericWriteHandler(this.getFactoryLoader().getFactoryForClass(clazz));
        }
        throw new XMLWriterException("Unable to handle " + clazz);
    }

    public void write(String string, Object object, Class clazz, XMLWriter xMLWriter) throws IOException, XMLWriterException {
        if (object == null) {
            return;
        }
        if (string == null) {
            throw new NullPointerException("RootXmlWriteHandler.write(..) : tagName is null");
        }
        if (xMLWriter == null) {
            throw new NullPointerException("RootXmlWriteHandler.write(..) : writer is null");
        }
        if (!clazz.isInstance(object)) {
            throw new ClassCastException("Object is no instance of " + clazz);
        }
        Class<?> clazz2 = object.getClass();
        XmlWriteHandler xmlWriteHandler = this.getMapping(clazz2);
        xmlWriteHandler.setRootHandler(this);
        String string2 = null;
        String string3 = null;
        MultiplexMappingDefinition multiplexMappingDefinition = this.getFactoryLoader().getMultiplexDefinition(clazz);
        if (multiplexMappingDefinition == null) {
            multiplexMappingDefinition = this.classToHandlerMapping.getMultiplexDefinition(clazz);
        }
        if (multiplexMappingDefinition != null) {
            MultiplexMappingEntry multiplexMappingEntry = multiplexMappingDefinition.getEntryForClass(clazz2.getName());
            if (multiplexMappingEntry != null) {
                string2 = multiplexMappingDefinition.getAttributeName();
                string3 = multiplexMappingEntry.getAttributeValue();
            } else {
                throw new XMLWriterException("Unable to find child mapping for multiplexer " + clazz + " to child " + clazz2);
            }
        }
        xmlWriteHandler.write(string, object, xMLWriter, string2, string3);
        xMLWriter.allowLineBreak();
    }

    protected XmlWriteHandler loadHandlerClass(String string) throws XMLWriterException {
        if (string == null) {
            throw new XMLWriterException("LoadHanderClass: Class name not defined");
        }
        try {
            Class<?> clazz = ObjectUtilities.getClassLoader(this.getClass()).loadClass(string);
            return (XmlWriteHandler)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new XMLWriterException("LoadHanderClass: Unable to instantiate " + string, exception);
        }
    }
}

