/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.xml.generator.model;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;

public class PrintBeanInfo {
    private PrintBeanInfo() {
    }

    public static void print(Class clazz) {
        try {
            System.out.println("Class: " + clazz.getName());
            System.out.println("========================================================================");
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz, clazz.getSuperclass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                System.out.println("Property: " + propertyDescriptorArray[i].getDisplayName());
                System.out.println("---------------------------------------------------------------------");
                System.out.println(" ( " + propertyDescriptorArray[i].getShortDescription() + ")");
                if (propertyDescriptorArray[i] instanceof IndexedPropertyDescriptor) {
                    IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptorArray[i];
                    System.out.println("  - idx-type   : " + indexedPropertyDescriptor.getIndexedPropertyType());
                    System.out.println("  - idx-read   : " + indexedPropertyDescriptor.getIndexedReadMethod());
                    System.out.println("  - idx-write  : " + indexedPropertyDescriptor.getIndexedWriteMethod());
                } else {
                    System.out.println("  - type       : " + propertyDescriptorArray[i].getPropertyType());
                    System.out.println("  - read       : " + propertyDescriptorArray[i].getReadMethod());
                    System.out.println("  - write      : " + propertyDescriptorArray[i].getWriteMethod());
                }
                System.out.println("  - bound      : " + propertyDescriptorArray[i].isBound());
                System.out.println("  - constrained: " + propertyDescriptorArray[i].isConstrained());
            }
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        for (int i = 0; i < stringArray.length; ++i) {
            PrintBeanInfo.print(Class.forName(stringArray[i]));
        }
    }
}

