/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.xml.generator;

import ai.org.jfree.util.Log;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PrintStreamLogTarget;
import ai.org.jfree.xml.generator.DefaultModelReader;
import ai.org.jfree.xml.generator.JavaSourceCollector;
import ai.org.jfree.xml.generator.ModelBuilder;
import ai.org.jfree.xml.generator.ModelWriter;
import ai.org.jfree.xml.generator.SplittingModelWriter;
import ai.org.jfree.xml.generator.model.DescriptionModel;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;

public final class DescriptionGenerator {
    private static Properties loadProperties(URL uRL) {
        Properties properties = new Properties();
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            properties.load(bufferedInputStream);
            ((InputStream)bufferedInputStream).close();
        }
        catch (Exception exception) {
            System.err.println("Unable to load properties from " + uRL);
        }
        return properties;
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        String string;
        Serializable serializable;
        Log.getInstance().addTarget(new PrintStreamLogTarget());
        URL uRL = ObjectUtilities.getResourceRelative("generator.properties", DescriptionGenerator.class);
        if (stringArray.length > 0) {
            serializable = new File(stringArray[0]);
            uRL = ((File)serializable).toURL();
        }
        if ((string = ((Properties)(serializable = DescriptionGenerator.loadProperties(uRL))).getProperty("attributedefinition")) != null) {
            object = DescriptionGenerator.loadProperties(new URL(uRL, string));
            ModelBuilder.getInstance().addAttributeHandlers((Properties)object);
        }
        object = ((Properties)serializable).getProperty("sourcedirectory", ".");
        String string2 = ((Properties)serializable).getProperty("targetfile", "model.xml");
        DescriptionModel descriptionModel = null;
        try {
            descriptionModel = new DefaultModelReader().load(string2);
        }
        catch (Exception exception) {
            Log.debug("Unable to load default model. Ignoring...");
        }
        descriptionModel = DescriptionGenerator.generate((String)object, (Properties)serializable, descriptionModel);
        descriptionModel.prune();
        DescriptionGenerator.writeMultiFile(string2, descriptionModel);
        System.exit(0);
    }

    public static DescriptionModel generate(String string, Properties properties, DescriptionModel descriptionModel) {
        JavaSourceCollector javaSourceCollector = new JavaSourceCollector(new File(string));
        for (String string2 : properties.keySet()) {
            if (string2.startsWith("ignore.baseclass.")) {
                javaSourceCollector.addIgnoredBaseClass(properties.getProperty(string2));
                continue;
            }
            if (!string2.startsWith("ignore.package.")) continue;
            javaSourceCollector.addIgnoredPackage(properties.getProperty(string2));
        }
        javaSourceCollector.collectFiles();
        return ModelBuilder.getInstance().buildModel(javaSourceCollector, descriptionModel);
    }

    public static void writeSingleFile(String string, DescriptionModel descriptionModel) throws IOException {
        Log.debug("Writing ...");
        ModelWriter modelWriter = new ModelWriter();
        modelWriter.setModel(descriptionModel);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        modelWriter.write(bufferedWriter);
        ((Writer)bufferedWriter).close();
    }

    public static void writeMultiFile(String string, DescriptionModel descriptionModel) throws IOException {
        Log.debug("Writing multiple files ...");
        SplittingModelWriter splittingModelWriter = new SplittingModelWriter();
        splittingModelWriter.setModel(descriptionModel);
        splittingModelWriter.write(string);
    }
}

