/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.xml.factory.objects;

import ai.org.jfree.util.Log;
import ai.org.jfree.xml.factory.objects.AbstractObjectDescription;
import ai.org.jfree.xml.factory.objects.ObjectFactoryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class CollectionObjectDescription
extends AbstractObjectDescription {
    public CollectionObjectDescription(Class clazz) {
        super(clazz);
        if (!Collection.class.isAssignableFrom(clazz)) {
            throw new ClassCastException("The given class is no Collection instance");
        }
    }

    private int parseParameterName(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public Class getParameterDefinition(String string) {
        if (string.equals("size")) {
            return Integer.TYPE;
        }
        int n = this.parseParameterName(string);
        if (n < 0) {
            return null;
        }
        return Object.class;
    }

    public Iterator getParameterNames() {
        Integer n = (Integer)this.getParameter("size");
        if (n == null) {
            return this.getDefinedParameterNames();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("size");
        for (int i = 0; i < n; ++i) {
            arrayList.add(String.valueOf(i));
        }
        return arrayList.iterator();
    }

    public Object createObject() {
        try {
            Object object;
            Collection collection = (Collection)this.getObjectClass().newInstance();
            int n = 0;
            while (this.getParameterDefinition(String.valueOf(n)) != null && (object = this.getParameter(String.valueOf(n))) != null) {
                collection.add(object);
                ++n;
            }
            return collection;
        }
        catch (Exception exception) {
            Log.warn("Unable to instantiate Object", exception);
            return null;
        }
    }

    public void setParameterFromObject(Object object) throws ObjectFactoryException {
        if (object == null) {
            throw new NullPointerException("Given object is null");
        }
        Class clazz = this.getObjectClass();
        if (!clazz.isInstance(object)) {
            throw new ObjectFactoryException("Object is no instance of " + clazz + "(is " + object.getClass() + ")");
        }
        Collection collection = (Collection)object;
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.setParameter(String.valueOf(n), e);
            ++n;
        }
    }
}

