/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.util.junit;

import ai.org.jfree.util.ShapeUtilities;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ShapeUtilitiesTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(ShapeUtilitiesTests.class);
    }

    public ShapeUtilitiesTests(String string) {
        super(string);
    }

    public void testEqualLine2Ds() {
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal((Line2D)null, (Line2D)null));
        Line2D line2D = new Line2D.Float(1.0f, 2.0f, 3.0f, 4.0f);
        Line2D.Float float_ = new Line2D.Float(1.0f, 2.0f, 3.0f, 4.0f);
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(line2D, float_));
        line2D = new Line2D.Float(4.0f, 3.0f, 2.0f, 1.0f);
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(line2D, float_));
        float_ = new Line2D.Float(4.0f, 3.0f, 2.0f, 1.0f);
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(line2D, float_));
        line2D = new Line2D.Double(4.0, 3.0, 2.0, 1.0);
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(line2D, float_));
    }

    public void testEqualShapes() {
        Shape shape = null;
        Shape shape2 = null;
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(shape, shape2));
        shape = new Line2D.Double(1.0, 2.0, 3.0, 4.0);
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(shape, shape2));
        shape2 = new Line2D.Double(1.0, 2.0, 3.0, 4.0);
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(shape, shape2));
        ShapeUtilitiesTests.assertFalse((boolean)shape.equals(shape2));
        shape = new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0);
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(shape, shape2));
        shape2 = new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0);
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(shape, shape2));
        ShapeUtilitiesTests.assertTrue((boolean)shape.equals(shape2));
        shape = new Ellipse2D.Double(1.0, 2.0, 3.0, 4.0);
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(shape, shape2));
        shape2 = new Ellipse2D.Double(1.0, 2.0, 3.0, 4.0);
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(shape, shape2));
        shape = new Arc2D.Double(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 2);
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(shape, shape2));
        shape2 = new Arc2D.Double(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 2);
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(shape, shape2));
        Polygon polygon = new Polygon(new int[]{0, 1, 0}, new int[]{1, 0, 1}, 3);
        Polygon polygon2 = new Polygon(new int[]{1, 1, 0}, new int[]{1, 0, 1}, 3);
        shape = polygon;
        shape2 = polygon2;
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(shape, shape2));
        polygon2 = new Polygon(new int[]{0, 1, 0}, new int[]{1, 0, 1}, 3);
        shape2 = polygon2;
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(shape, shape2));
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(1.0f, 2.0f);
        generalPath.lineTo(3.0f, 4.0f);
        generalPath.curveTo(5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f);
        generalPath.quadTo(1.0f, 2.0f, 3.0f, 4.0f);
        generalPath.closePath();
        shape = generalPath;
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(shape, shape2));
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(1.0f, 2.0f);
        generalPath2.lineTo(3.0f, 4.0f);
        generalPath2.curveTo(5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f);
        generalPath2.quadTo(1.0f, 2.0f, 3.0f, 4.0f);
        generalPath2.closePath();
        shape2 = generalPath2;
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(shape, shape2));
        ShapeUtilitiesTests.assertFalse((boolean)shape.equals(shape2));
    }

    public void testIntersects() {
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, 100.0f, 100.0f);
        Rectangle2D.Float float_2 = new Rectangle2D.Float(0.0f, 0.0f, 100.0f, 100.0f);
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.intersects(float_, float_2));
        ((Rectangle2D)float_).setRect(100.0, 0.0, 100.0, 0.0);
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.intersects(float_, float_2));
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.intersects(float_2, float_));
        ((Rectangle2D)float_).setRect(0.0, 0.0, 0.0, 0.0);
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.intersects(float_, float_2));
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.intersects(float_2, float_));
        ((Rectangle2D)float_).setRect(50.0, 50.0, 10.0, 0.0);
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.intersects(float_, float_2));
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.intersects(float_2, float_));
    }

    public void testEqualGeneralPaths() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(1.0f, 2.0f);
        generalPath.lineTo(3.0f, 4.0f);
        generalPath.curveTo(5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f);
        generalPath.quadTo(1.0f, 2.0f, 3.0f, 4.0f);
        generalPath.closePath();
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(1.0f, 2.0f);
        generalPath2.lineTo(3.0f, 4.0f);
        generalPath2.curveTo(5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f);
        generalPath2.quadTo(1.0f, 2.0f, 3.0f, 4.0f);
        generalPath2.closePath();
        ShapeUtilitiesTests.assertTrue((boolean)ShapeUtilities.equal(generalPath, generalPath2));
        generalPath2 = new GeneralPath();
        generalPath2.moveTo(11.0f, 22.0f);
        generalPath2.lineTo(3.0f, 4.0f);
        generalPath2.curveTo(5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f);
        generalPath2.quadTo(1.0f, 2.0f, 3.0f, 4.0f);
        generalPath2.closePath();
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(generalPath, generalPath2));
        generalPath2 = new GeneralPath();
        generalPath2.moveTo(1.0f, 2.0f);
        generalPath2.lineTo(33.0f, 44.0f);
        generalPath2.curveTo(5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f);
        generalPath2.quadTo(1.0f, 2.0f, 3.0f, 4.0f);
        generalPath2.closePath();
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(generalPath, generalPath2));
        generalPath2 = new GeneralPath();
        generalPath2.moveTo(1.0f, 2.0f);
        generalPath2.lineTo(3.0f, 4.0f);
        generalPath2.curveTo(55.0f, 66.0f, 77.0f, 88.0f, 99.0f, 100.0f);
        generalPath2.quadTo(1.0f, 2.0f, 3.0f, 4.0f);
        generalPath2.closePath();
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(generalPath, generalPath2));
        generalPath2 = new GeneralPath();
        generalPath2.moveTo(1.0f, 2.0f);
        generalPath2.lineTo(3.0f, 4.0f);
        generalPath2.curveTo(5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f);
        generalPath2.quadTo(11.0f, 22.0f, 33.0f, 44.0f);
        generalPath2.closePath();
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(generalPath, generalPath2));
        generalPath2 = new GeneralPath();
        generalPath2.moveTo(1.0f, 2.0f);
        generalPath2.lineTo(3.0f, 4.0f);
        generalPath2.curveTo(5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f);
        generalPath2.quadTo(1.0f, 2.0f, 3.0f, 4.0f);
        generalPath2.lineTo(3.0f, 4.0f);
        generalPath2.closePath();
        ShapeUtilitiesTests.assertFalse((boolean)ShapeUtilities.equal(generalPath, generalPath2));
    }
}

