/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.util.junit;

import ai.org.jfree.util.ObjectList;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ObjectListTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(ObjectListTests.class);
    }

    public ObjectListTests(String string) {
        super(string);
    }

    public void testEquals() {
        ObjectList objectList = new ObjectList();
        objectList.set(0, Color.blue);
        objectList.set(1, Color.red);
        ObjectList objectList2 = new ObjectList();
        objectList2.set(0, Color.blue);
        objectList2.set(1, Color.red);
        ObjectListTests.assertTrue((boolean)objectList.equals(objectList2));
        ObjectListTests.assertTrue((boolean)objectList2.equals(objectList2));
    }

    public void testEquals2() {
        ObjectList objectList = new ObjectList(20);
        objectList.set(0, Color.blue);
        objectList.set(1, Color.red);
        ObjectList objectList2 = new ObjectList();
        objectList2.set(0, Color.blue);
        objectList2.set(1, Color.red);
        ObjectListTests.assertTrue((boolean)objectList.equals(objectList2));
        ObjectListTests.assertTrue((boolean)objectList2.equals(objectList2));
    }

    public void testCloning() {
        ObjectList objectList = new ObjectList();
        objectList.set(0, Color.blue);
        objectList.set(1, Color.red);
        ObjectList objectList2 = null;
        try {
            objectList2 = (ObjectList)objectList.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("ObjectListTests.testCloning: failed to clone.");
        }
        ObjectListTests.assertTrue((objectList != objectList2 ? 1 : 0) != 0);
        ObjectListTests.assertTrue((objectList.getClass() == objectList2.getClass() ? 1 : 0) != 0);
        ObjectListTests.assertTrue((boolean)objectList.equals(objectList2));
        objectList2.set(0, Color.green);
        ObjectListTests.assertFalse((boolean)objectList.equals(objectList2));
    }

    public void testSerialization() {
        ObjectList objectList = new ObjectList();
        objectList.set(0, Color.red);
        objectList.set(1, Color.blue);
        objectList.set(2, null);
        ObjectList objectList2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(objectList);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            objectList2 = (ObjectList)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        ObjectListTests.assertEquals((Object)objectList, objectList2);
    }

    public void testExpand() {
        ObjectList objectList = new ObjectList();
        objectList.set(10, Color.blue);
        Color color = (Color)objectList.get(10);
        ObjectListTests.assertTrue((boolean)color.equals(Color.blue));
    }
}

