/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.util;

import ai.org.jfree.ui.RectangleAnchor;
import ai.org.jfree.util.ObjectUtilities;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

public class ShapeUtilities {
    private static final float SQRT2 = (float)Math.pow(2.0, 0.5);

    private ShapeUtilities() {
    }

    public static Shape clone(Shape shape) {
        if (shape instanceof Cloneable) {
            try {
                return (Shape)ObjectUtilities.clone(shape);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        Shape shape2 = null;
        return shape2;
    }

    public static boolean equal(Shape shape, Shape shape2) {
        if (shape instanceof Line2D && shape2 instanceof Line2D) {
            return ShapeUtilities.equal((Line2D)shape, (Line2D)shape2);
        }
        if (shape instanceof Ellipse2D && shape2 instanceof Ellipse2D) {
            return ShapeUtilities.equal((Ellipse2D)shape, (Ellipse2D)shape2);
        }
        if (shape instanceof Arc2D && shape2 instanceof Arc2D) {
            return ShapeUtilities.equal((Arc2D)shape, (Arc2D)shape2);
        }
        if (shape instanceof Polygon && shape2 instanceof Polygon) {
            return ShapeUtilities.equal((Polygon)shape, (Polygon)shape2);
        }
        if (shape instanceof GeneralPath && shape2 instanceof GeneralPath) {
            return ShapeUtilities.equal((GeneralPath)shape, (GeneralPath)shape2);
        }
        return ObjectUtilities.equal(shape, shape2);
    }

    public static boolean equal(Line2D line2D, Line2D line2D2) {
        if (line2D == null) {
            return line2D2 == null;
        }
        if (line2D2 == null) {
            return false;
        }
        if (!line2D.getP1().equals(line2D2.getP1())) {
            return false;
        }
        return line2D.getP2().equals(line2D2.getP2());
    }

    public static boolean equal(Ellipse2D ellipse2D, Ellipse2D ellipse2D2) {
        if (ellipse2D == null) {
            return ellipse2D2 == null;
        }
        if (ellipse2D2 == null) {
            return false;
        }
        return ellipse2D.getFrame().equals(ellipse2D2.getFrame());
    }

    public static boolean equal(Arc2D arc2D, Arc2D arc2D2) {
        if (arc2D == null) {
            return arc2D2 == null;
        }
        if (arc2D2 == null) {
            return false;
        }
        if (!arc2D.getFrame().equals(arc2D2.getFrame())) {
            return false;
        }
        if (arc2D.getAngleStart() != arc2D2.getAngleStart()) {
            return false;
        }
        if (arc2D.getAngleExtent() != arc2D2.getAngleExtent()) {
            return false;
        }
        return arc2D.getArcType() == arc2D2.getArcType();
    }

    public static boolean equal(Polygon polygon, Polygon polygon2) {
        if (polygon == null) {
            return polygon2 == null;
        }
        if (polygon2 == null) {
            return false;
        }
        if (polygon.npoints != polygon2.npoints) {
            return false;
        }
        if (!Arrays.equals(polygon.xpoints, polygon2.xpoints)) {
            return false;
        }
        return Arrays.equals(polygon.ypoints, polygon2.ypoints);
    }

    public static boolean equal(GeneralPath generalPath, GeneralPath generalPath2) {
        boolean bl;
        if (generalPath == null) {
            return generalPath2 == null;
        }
        if (generalPath2 == null) {
            return false;
        }
        if (generalPath.getWindingRule() != generalPath2.getWindingRule()) {
            return false;
        }
        PathIterator pathIterator = generalPath.getPathIterator(null);
        PathIterator pathIterator2 = generalPath2.getPathIterator(null);
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        boolean bl2 = bl = pathIterator.isDone() && pathIterator2.isDone();
        while (!bl) {
            int n;
            if (pathIterator.isDone() != pathIterator2.isDone()) {
                return false;
            }
            int n2 = pathIterator.currentSegment(dArray);
            if (n2 != (n = pathIterator2.currentSegment(dArray2))) {
                return false;
            }
            if (!Arrays.equals(dArray, dArray2)) {
                return false;
            }
            pathIterator.next();
            pathIterator2.next();
            bl = pathIterator.isDone() && pathIterator2.isDone();
        }
        return true;
    }

    public static Shape createTranslatedShape(Shape shape, double d, double d2) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d, d2);
        return affineTransform.createTransformedShape(shape);
    }

    public static Shape createTranslatedShape(Shape shape, RectangleAnchor rectangleAnchor, double d, double d2) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        if (rectangleAnchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        Point2D point2D = RectangleAnchor.coordinates(shape.getBounds2D(), rectangleAnchor);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d - point2D.getX(), d2 - point2D.getY());
        return affineTransform.createTransformedShape(shape);
    }

    public static Shape rotateShape(Shape shape, double d, float f, float f2) {
        if (shape == null) {
            return null;
        }
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d, f, f2);
        Shape shape2 = affineTransform.createTransformedShape(shape);
        return shape2;
    }

    public static void drawRotatedShape(Graphics2D graphics2D, Shape shape, double d, float f, float f2) {
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = AffineTransform.getRotateInstance(d, f, f2);
        graphics2D.transform(affineTransform2);
        graphics2D.draw(shape);
        graphics2D.setTransform(affineTransform);
    }

    public static Shape createDiagonalCross(float f, float f2) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-f - f2, -f + f2);
        generalPath.lineTo(-f + f2, -f - f2);
        generalPath.lineTo(0.0f, -f2 * SQRT2);
        generalPath.lineTo(f - f2, -f - f2);
        generalPath.lineTo(f + f2, -f + f2);
        generalPath.lineTo(f2 * SQRT2, 0.0f);
        generalPath.lineTo(f + f2, f - f2);
        generalPath.lineTo(f - f2, f + f2);
        generalPath.lineTo(0.0f, f2 * SQRT2);
        generalPath.lineTo(-f + f2, f + f2);
        generalPath.lineTo(-f - f2, f - f2);
        generalPath.lineTo(-f2 * SQRT2, 0.0f);
        generalPath.closePath();
        return generalPath;
    }

    public static Shape createRegularCross(float f, float f2) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-f, f2);
        generalPath.lineTo(-f2, f2);
        generalPath.lineTo(-f2, f);
        generalPath.lineTo(f2, f);
        generalPath.lineTo(f2, f2);
        generalPath.lineTo(f, f2);
        generalPath.lineTo(f, -f2);
        generalPath.lineTo(f2, -f2);
        generalPath.lineTo(f2, -f);
        generalPath.lineTo(-f2, -f);
        generalPath.lineTo(-f2, -f2);
        generalPath.lineTo(-f, -f2);
        generalPath.closePath();
        return generalPath;
    }

    public static Shape createDiamond(float f) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, -f);
        generalPath.lineTo(f, 0.0f);
        generalPath.lineTo(0.0f, f);
        generalPath.lineTo(-f, 0.0f);
        generalPath.closePath();
        return generalPath;
    }

    public static Shape createUpTriangle(float f) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, -f);
        generalPath.lineTo(f, f);
        generalPath.lineTo(-f, f);
        generalPath.closePath();
        return generalPath;
    }

    public static Shape createDownTriangle(float f) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, f);
        generalPath.lineTo(f, -f);
        generalPath.lineTo(-f, -f);
        generalPath.closePath();
        return generalPath;
    }

    public static Shape createLineRegion(Line2D line2D, float f) {
        GeneralPath generalPath = new GeneralPath();
        float f2 = (float)line2D.getX1();
        float f3 = (float)line2D.getX2();
        float f4 = (float)line2D.getY1();
        float f5 = (float)line2D.getY2();
        if ((double)(f3 - f2) != 0.0) {
            double d = Math.atan((f5 - f4) / (f3 - f2));
            float f6 = (float)Math.sin(d) * f;
            float f7 = (float)Math.cos(d) * f;
            generalPath.moveTo(f2 - f6, f4 + f7);
            generalPath.lineTo(f2 + f6, f4 - f7);
            generalPath.lineTo(f3 + f6, f5 - f7);
            generalPath.lineTo(f3 - f6, f5 + f7);
            generalPath.closePath();
        } else {
            generalPath.moveTo(f2 - f / 2.0f, f4);
            generalPath.lineTo(f2 + f / 2.0f, f4);
            generalPath.lineTo(f3 + f / 2.0f, f5);
            generalPath.lineTo(f3 - f / 2.0f, f5);
            generalPath.closePath();
        }
        return generalPath;
    }

    public static Point2D getPointInRectangle(double d, double d2, Rectangle2D rectangle2D) {
        d = Math.max(rectangle2D.getMinX(), Math.min(d, rectangle2D.getMaxX()));
        d2 = Math.max(rectangle2D.getMinY(), Math.min(d2, rectangle2D.getMaxY()));
        return new Point2D.Double(d, d2);
    }

    public static boolean contains(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D2.getX();
        double d4 = rectangle2D2.getY();
        double d5 = rectangle2D2.getWidth();
        double d6 = rectangle2D2.getHeight();
        return d3 >= d && d4 >= d2 && d3 + d5 <= d + rectangle2D.getWidth() && d4 + d6 <= d2 + rectangle2D.getHeight();
    }

    public static boolean intersects(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D2.getX();
        double d4 = rectangle2D2.getWidth();
        double d5 = rectangle2D2.getY();
        double d6 = rectangle2D2.getHeight();
        return d3 + d4 >= d && d5 + d6 >= d2 && d3 <= d + rectangle2D.getWidth() && d5 <= d2 + rectangle2D.getHeight();
    }
}

