/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.util;

import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.util.AbstractObjectList;
import ai.org.jfree.util.PaintUtilities;
import java.awt.Paint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class PaintList
extends AbstractObjectList {
    public Paint getPaint(int n) {
        return (Paint)this.get(n);
    }

    public void setPaint(int n, Paint paint) {
        this.set(n, paint);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof PaintList) {
            PaintList paintList = (PaintList)object;
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                if (PaintUtilities.equal(this.getPaint(i), paintList.getPaint(i))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.size();
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            Paint paint = this.getPaint(i);
            if (paint != null) {
                objectOutputStream.writeInt(i);
                SerialUtilities.writePaint(paint, objectOutputStream);
                continue;
            }
            objectOutputStream.writeInt(-1);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = objectInputStream.readInt();
            if (n2 == -1) continue;
            this.setPaint(n2, SerialUtilities.readPaint(objectInputStream));
        }
    }
}

