/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.ui.tabbedui;

import ai.org.jfree.ui.tabbedui.RootEditor;
import ai.org.jfree.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractTabbedUI
extends JComponent {
    public static final String JMENUBAR_PROPERTY = "jMenuBar";
    public static final String GLOBAL_MENU_PROPERTY = "globalMenu";
    private ArrayList rootEditors;
    private JTabbedPane tabbedPane;
    private int selectedRootEditor = -1;
    private JComponent currentToolbar;
    private JPanel toolbarContainer = new JPanel();
    private Action closeAction;
    private JMenuBar jMenuBar;
    private boolean globalMenu;

    public AbstractTabbedUI() {
        this.toolbarContainer.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(3);
        this.tabbedPane.addChangeListener(new TabChangeHandler(this.tabbedPane));
        this.rootEditors = new ArrayList();
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolbarContainer, "North");
        this.add((Component)this.tabbedPane, "Center");
        this.closeAction = this.createCloseAction();
    }

    protected JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public boolean isGlobalMenu() {
        return this.globalMenu;
    }

    public void setGlobalMenu(boolean bl) {
        this.globalMenu = bl;
        if (this.isGlobalMenu()) {
            this.setJMenuBar(this.updateGlobalMenubar());
        } else if (this.getRootEditorCount() > 0) {
            this.setJMenuBar(this.createEditorMenubar(this.getRootEditor(this.getSelectedEditor())));
        }
    }

    public JMenuBar getJMenuBar() {
        return this.jMenuBar;
    }

    protected void setJMenuBar(JMenuBar jMenuBar) {
        JMenuBar jMenuBar2 = this.jMenuBar;
        this.jMenuBar = jMenuBar;
        this.firePropertyChange(JMENUBAR_PROPERTY, jMenuBar2, jMenuBar);
    }

    protected Action createCloseAction() {
        return new ExitAction();
    }

    public Action getCloseAction() {
        return this.closeAction;
    }

    protected abstract JMenu[] getPrefixMenus();

    protected abstract JMenu[] getPostfixMenus();

    private void addMenus(JMenuBar jMenuBar, JMenu[] jMenuArray) {
        for (int i = 0; i < jMenuArray.length; ++i) {
            jMenuBar.add(jMenuArray[i]);
        }
    }

    private JMenuBar updateGlobalMenubar() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            jMenuBar = new JMenuBar();
        } else {
            jMenuBar.removeAll();
        }
        this.addMenus(jMenuBar, this.getPrefixMenus());
        for (int i = 0; i < this.rootEditors.size(); ++i) {
            RootEditor rootEditor = (RootEditor)this.rootEditors.get(i);
            this.addMenus(jMenuBar, rootEditor.getMenus());
        }
        this.addMenus(jMenuBar, this.getPostfixMenus());
        return jMenuBar;
    }

    private JMenuBar createEditorMenubar(RootEditor rootEditor) {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            jMenuBar = new JMenuBar();
        } else {
            jMenuBar.removeAll();
        }
        this.addMenus(jMenuBar, this.getPrefixMenus());
        if (this.isGlobalMenu()) {
            for (int i = 0; i < this.rootEditors.size(); ++i) {
                RootEditor rootEditor2 = (RootEditor)this.rootEditors.get(i);
                this.addMenus(jMenuBar, rootEditor2.getMenus());
            }
        } else {
            this.addMenus(jMenuBar, rootEditor.getMenus());
        }
        this.addMenus(jMenuBar, this.getPostfixMenus());
        return jMenuBar;
    }

    public void addRootEditor(RootEditor rootEditor) {
        this.rootEditors.add(rootEditor);
        this.tabbedPane.add(rootEditor.getEditorName(), rootEditor.getMainPanel());
        rootEditor.addPropertyChangeListener("enabled", new TabEnableChangeListener());
        this.updateRootEditorEnabled(rootEditor);
        if (this.getRootEditorCount() == 1) {
            this.setSelectedEditor(0);
        } else if (this.isGlobalMenu()) {
            this.setJMenuBar(this.updateGlobalMenubar());
        }
    }

    public int getRootEditorCount() {
        return this.rootEditors.size();
    }

    public RootEditor getRootEditor(int n) {
        return (RootEditor)this.rootEditors.get(n);
    }

    public int getSelectedEditor() {
        return this.selectedRootEditor;
    }

    public void setSelectedEditor(int n) {
        RootEditor rootEditor;
        boolean bl;
        int n2;
        int n3 = this.selectedRootEditor;
        if (n3 == n) {
            return;
        }
        this.selectedRootEditor = n;
        for (n2 = 0; n2 < this.rootEditors.size(); ++n2) {
            bl = n2 == n;
            rootEditor = (RootEditor)this.rootEditors.get(n2);
            if (!rootEditor.isActive() || bl) continue;
            rootEditor.setActive(false);
        }
        if (this.currentToolbar != null) {
            this.closeToolbar();
            this.toolbarContainer.removeAll();
            this.currentToolbar = null;
        }
        for (n2 = 0; n2 < this.rootEditors.size(); ++n2) {
            bl = n2 == n;
            rootEditor = (RootEditor)this.rootEditors.get(n2);
            if (rootEditor.isActive() || !bl) continue;
            rootEditor.setActive(true);
            this.setJMenuBar(this.createEditorMenubar(rootEditor));
            this.currentToolbar = rootEditor.getToolbar();
            if (this.currentToolbar != null) {
                this.toolbarContainer.add((Component)this.currentToolbar, "Center");
                this.toolbarContainer.setVisible(true);
                this.currentToolbar.setVisible(true);
            } else {
                this.toolbarContainer.setVisible(false);
            }
            this.getJMenuBar().repaint();
        }
    }

    private void closeToolbar() {
        if (this.currentToolbar != null) {
            Window window;
            if (this.currentToolbar.getParent() != this.toolbarContainer && (window = SwingUtilities.windowForComponent(this.currentToolbar)) != null) {
                window.setVisible(false);
                window.dispose();
            }
            this.currentToolbar.setVisible(false);
        }
    }

    protected abstract void attempExit();

    protected void updateRootEditorEnabled(RootEditor rootEditor) {
        boolean bl = rootEditor.isEnabled();
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            Component component = this.tabbedPane.getComponentAt(i);
            if (component != rootEditor.getMainPanel()) continue;
            this.tabbedPane.setEnabledAt(i, bl);
            return;
        }
    }

    private class TabEnableChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!propertyChangeEvent.getPropertyName().equals("enabled")) {
                Log.debug("PropertyName");
                return;
            }
            if (!(propertyChangeEvent.getSource() instanceof RootEditor)) {
                Log.debug("Source");
                return;
            }
            RootEditor rootEditor = (RootEditor)propertyChangeEvent.getSource();
            AbstractTabbedUI.this.updateRootEditorEnabled(rootEditor);
        }
    }

    private class TabChangeHandler
    implements ChangeListener {
        private final JTabbedPane pane;

        public TabChangeHandler(JTabbedPane jTabbedPane) {
            this.pane = jTabbedPane;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            AbstractTabbedUI.this.setSelectedEditor(this.pane.getSelectedIndex());
        }
    }

    protected class ExitAction
    extends AbstractAction {
        public ExitAction() {
            this.putValue("Name", "Exit");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractTabbedUI.this.attempExit();
        }
    }
}

