/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.ui.junit;

import ai.org.jfree.ui.Size2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class Size2DTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(Size2DTests.class);
    }

    public Size2DTests(String string) {
        super(string);
    }

    public void testEquals() {
        Size2D size2D = new Size2D(1.0, 2.0);
        Size2D size2D2 = new Size2D(1.0, 2.0);
        Size2DTests.assertTrue((boolean)size2D.equals(size2D2));
        Size2DTests.assertTrue((boolean)size2D2.equals(size2D));
        size2D = new Size2D(2.0, 2.0);
        Size2DTests.assertFalse((boolean)size2D.equals(size2D2));
        size2D2 = new Size2D(2.0, 2.0);
        Size2DTests.assertTrue((boolean)size2D.equals(size2D2));
        size2D = new Size2D(2.0, 3.0);
        Size2DTests.assertFalse((boolean)size2D.equals(size2D2));
        size2D2 = new Size2D(2.0, 3.0);
        Size2DTests.assertTrue((boolean)size2D.equals(size2D2));
    }

    public void testCloning() {
        Size2D size2D = new Size2D(1.0, 2.0);
        Size2D size2D2 = null;
        try {
            size2D2 = (Size2D)size2D.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            System.err.println("Failed to clone.");
        }
        Size2DTests.assertTrue((size2D != size2D2 ? 1 : 0) != 0);
        Size2DTests.assertTrue((size2D.getClass() == size2D2.getClass() ? 1 : 0) != 0);
        Size2DTests.assertTrue((boolean)size2D.equals(size2D2));
    }

    public void testSerialization() {
        Size2D size2D = new Size2D(3.0, 4.0);
        Size2D size2D2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(size2D);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            size2D2 = (Size2D)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        Size2DTests.assertTrue((boolean)size2D.equals(size2D2));
    }
}

