/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.ui.action;

import ai.org.jfree.ui.ExtensionFileFilter;
import ai.org.jfree.ui.action.AbstractActionDowngrade;
import ai.org.jfree.util.StringUtils;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;

public abstract class AbstractFileSelectionAction
extends AbstractActionDowngrade {
    private JFileChooser fileChooser;
    private Component parent;

    public AbstractFileSelectionAction(Component component) {
        this.parent = component;
    }

    protected abstract String getFileExtension();

    protected abstract String getFileDescription();

    protected File getCurrentDirectory() {
        return new File(".");
    }

    protected File performSelectFile(File file, int n, boolean bl) {
        if (this.fileChooser == null) {
            this.fileChooser = this.createFileChooser();
        }
        this.fileChooser.setSelectedFile(file);
        this.fileChooser.setDialogType(n);
        int n2 = this.fileChooser.showDialog(this.parent, null);
        if (n2 == 0) {
            File file2 = this.fileChooser.getSelectedFile();
            String string = file2.getAbsolutePath();
            if (!StringUtils.endsWithIgnoreCase(string, this.getFileExtension())) {
                string = string + this.getFileExtension();
            }
            return new File(string);
        }
        return null;
    }

    protected JFileChooser createFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(new ExtensionFileFilter(this.getFileDescription(), this.getFileExtension()));
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setCurrentDirectory(this.getCurrentDirectory());
        return jFileChooser;
    }
}

